/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;

public final class SetTNodeInformationOnEdge
extends Transformation {
    public SetTNodeInformationOnEdge() {
        this.mName = "Set TNode Information on Edge.";
        this.mPassNumbers = new int[]{16};
        this.mTypes = new int[]{101049};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] children;
        ((V5Edge)node).setMixedDMRRelational(Boolean.TRUE);
        IXQEQueryNode qrd = node.getAncestorOfType(101055);
        V5Query query = ((V5QueryResultDefinition)qrd).getV5Query();
        MixedDMRRelUtil.MixedDMRRelParam param = MixedDMRRelUtil.createParam();
        param.env = environment;
        param.factory = environment.getNodeFactory();
        param.selection = query.getV5Selection();
        MixedDMRRelUtil.collectWrappedMeasuresAndLevels(param);
        for (IXQEQueryNode child : children = node.getChildrenOfType(101050)) {
            this.processEdgeGroup(child, param);
        }
    }

    protected void processEdgeGroup(IXQEQueryNode edgeGroup, MixedDMRRelUtil.MixedDMRRelParam param) {
        IXQEQueryNode[] children;
        V5ValueSet valueSet = (V5ValueSet)edgeGroup.getFirstChildByType(101057);
        this.processValueSet(valueSet, param);
        for (IXQEQueryNode child : children = edgeGroup.getChildrenOfType(101050)) {
            this.processEdgeGroup(child, param);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processValueSet(V5ValueSet valueSet, MixedDMRRelUtil.MixedDMRRelParam param) {
        String levelName;
        block11: {
            String parentType;
            String parentRefDataItem;
            String refDataItem = valueSet.getRefDataItemProperty();
            if (refDataItem == null) {
                return;
            }
            V5ValueSet parentValueSet = null;
            IXQEQueryNode group = valueSet.getParent().getParent();
            if (group.getType() == 101050 && refDataItem.equals(parentRefDataItem = (parentValueSet = (V5ValueSet)group.getFirstChildByType(101057)).getRefDataItemProperty())) {
                valueSet.setMixedDMRRelational(parentValueSet.getMixedDMRRelational());
                return;
            }
            V5DataItem v5DataItem = param.selection.getDataItemByRefName(refDataItem);
            IXQEQueryNode[] tnodes = v5DataItem.getDescendantsOfType(601024, false);
            if (tnodes.length == 0) {
                valueSet.setMixedDMRRelational("dmr");
                return;
            }
            Integer tp = null;
            for (IXQEQueryNode tnode : tnodes) {
                String[] aggrRollUp;
                RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                tp = relOLAPDeco.getWrapType();
                if (tp != null || (tp = Integer.valueOf(MixedDMRRelUtil.getWrapType(relOLAPDeco, param, aggrRollUp = new String[]{null, null, null}))) != 0) continue;
                MixedDMRRelUtil.wrapToMeasure(relOLAPDeco, param, aggrRollUp);
            }
            RelationalOlapDecorationNode tnode = MixedDMRRelUtil.getTNodeWrapToLevel(v5DataItem, param);
            if (tnode == null) {
                valueSet.setMixedDMRRelational("TBmeasure_");
                return;
            }
            int[] dimId = new int[]{-1};
            if (parentValueSet != null && (parentType = parentValueSet.getMixedDMRRelational()) != null && parentType.startsWith("TBlevel_")) {
                dimId[0] = this.siblingsUseDimension(group, parentType, valueSet.getParent());
            }
            levelName = null;
            tp = tnode.getWrapType();
            if (tp != null && tp == 1) {
                if (tnodes.length == 1) {
                    IXQEQueryNode[] sorts;
                    String newName = refDataItem + valueSet.getNameProperty();
                    v5DataItem = (V5DataItem)param.factory.deepCopyNode(v5DataItem);
                    v5DataItem.setNameProperty(newName);
                    v5DataItem.setPropertyValue("orgName", refDataItem);
                    param.selection.addChild(v5DataItem);
                    valueSet.setRefDataItemProperty(newName);
                    tnodes = v5DataItem.getDescendantsOfType(601024, false);
                    levelName = MixedDMRRelUtil.updateClonedTNodeWrappedToLevel((RelationalOlapDecorationNode)tnodes[0], param, dimId);
                    for (IXQEQueryNode aSort : sorts = valueSet.getChildrenOfType(101056)) {
                        V5SortItem groupSort = (V5SortItem)aSort;
                        String refName = groupSort.getRefDataItem();
                        if (!refDataItem.equals(refName)) continue;
                        groupSort.setPropertyValue("refDataItem", newName);
                    }
                    break block11;
                } else {
                    String name = tnode.getWrapName();
                    if (name == null) {
                        name = tnode.getWrapRefObjectName();
                    }
                    valueSet.setMixedDMRRelational(name);
                    return;
                }
            }
            String[] aggrRollUp = new String[]{null, null, null};
            tp = MixedDMRRelUtil.getWrapType(tnode, param, aggrRollUp);
            levelName = MixedDMRRelUtil.wrapToLevel(tnode, param, dimId, aggrRollUp[2]);
        }
        valueSet.setMixedDMRRelational("TBlevel_".concat(levelName));
    }

    protected int siblingsUseDimension(IXQEQueryNode parentGroup, String parentType, IXQEQueryNode group) {
        IXQEQueryNode[] children;
        int idx = parentType.lastIndexOf("_");
        String dimName = parentType.substring(0, idx);
        for (IXQEQueryNode child : children = parentGroup.getChildrenOfType(101050)) {
            String dimNm;
            V5ValueSet vs;
            String nm;
            if (child == group || (nm = (vs = (V5ValueSet)child.getFirstChildByType(101057)).getMixedDMRRelational()) == null || !nm.startsWith("TBlevel_") || !dimName.equals(dimNm = nm.substring(0, idx = nm.lastIndexOf("_")))) continue;
            return -1;
        }
        idx = dimName.lastIndexOf("_");
        String dimId = dimName.substring(idx + 1);
        return Integer.parseInt(dimId);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        Boolean b = ((V5Edge)node).isMixedDMRRelational();
        boolean bl = status = b == null || b != Boolean.TRUE;
        if (status) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
            if (qrd == null) {
                status = false;
            } else {
                b = qrd.isMixedDMRRelational();
                boolean bl2 = status = b != null && b == Boolean.TRUE;
            }
        }
        if (status) {
            this.traceNodeCondition(status, "need to set TNode information on the edge.", trace);
        } else {
            this.traceNodeCondition(status, "don't set TNode information on the edge.", trace);
        }
        return status;
    }
}

