/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import java.util.ArrayList;

public final class SetTNodeInformationOnValueSets
extends Transformation {
    public SetTNodeInformationOnValueSets() {
        this.mName = "Set TNode Information on ValueSets.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = ((V5QueryResultDefinition)node).getV5Query();
        MixedDMRRelUtil.MixedDMRRelParam param = MixedDMRRelUtil.createParam();
        param.env = environment;
        param.factory = environment.getNodeFactory();
        param.selection = query.getV5Selection();
        MixedDMRRelUtil.collectWrappedMeasuresAndLevels(param);
        ArrayList<V5DataItem> items = this.getV5DataItemsWithUnResolvedTNode(node);
        for (V5DataItem item : items) {
            IXQEQueryNode[] tnodes;
            for (IXQEQueryNode tnode : tnodes = item.getDescendantsOfType(601024, false)) {
                RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                Integer tp = relOLAPDeco.getWrapType();
                if (tp != null) continue;
                String[] aggrRollUp = new String[]{null, null, null};
                tp = MixedDMRRelUtil.getWrapType(relOLAPDeco, param, aggrRollUp);
                if (tp == 0) {
                    MixedDMRRelUtil.wrapToMeasure(relOLAPDeco, param, aggrRollUp);
                    continue;
                }
                MixedDMRRelUtil.wrapToNewOrExistLevel(relOLAPDeco, param, aggrRollUp[2]);
            }
        }
    }

    protected ArrayList<V5DataItem> getV5DataItemsWithUnResolvedTNode(IXQEQueryNode node) {
        IXQEQueryNode[] valueSets;
        ArrayList<V5DataItem> r = new ArrayList<V5DataItem>();
        V5Query query = ((V5QueryResultDefinition)node).getV5Query();
        V5Selection selection = query.getV5Selection();
        for (IXQEQueryNode vs : valueSets = node.getDescendantsOfType(101057, false)) {
            String refDataItem = ((V5ValueSet)vs).getRefDataItemProperty();
            if (refDataItem == null) continue;
            V5DataItem v5DataItem = selection.getDataItemByRefName(refDataItem);
            IXQEQueryNode[] tnodes = v5DataItem.getDescendantsOfType(601024, false);
            boolean hasUnResolvedTNodes = false;
            for (IXQEQueryNode tnode : tnodes) {
                RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                Integer tp = relOLAPDeco.getWrapType();
                if (tp != null) continue;
                hasUnResolvedTNodes = true;
                break;
            }
            if (!hasUnResolvedTNodes) continue;
            r.add(v5DataItem);
        }
        return r;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        Boolean b = ((V5QueryResultDefinition)node).isMixedDMRRelational();
        boolean bl = status = b != null && b != false;
        if (status) {
            ArrayList<V5DataItem> items = this.getV5DataItemsWithUnResolvedTNode(node);
            boolean bl2 = status = !items.isEmpty();
        }
        if (status) {
            this.traceNodeCondition(status, "need to set TNode information on the value sets.", trace);
        } else {
            this.traceNodeCondition(status, "don't set TNode information on the value sets.", trace);
        }
        return status;
    }
}

