/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import java.util.ArrayList;

public final class SetTNodeInformationRelPAANonFactDetailFilter
extends Transformation {
    public SetTNodeInformationRelPAANonFactDetailFilter() {
        this.mName = "Set TNode Information in relational PAA detail filter using non fact item.";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{101008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ((V5DetailFilter)node).setMixedDMRRelational(null);
        MixedDMRRelUtil.MixedDMRRelParam param = MixedDMRRelUtil.createParam();
        param.env = environment;
        param.factory = environment.getNodeFactory();
        param.selection = ((V5Query)node.getParent()).getV5Selection();
        MixedDMRRelUtil.collectWrappedMeasuresAndLevels(param);
        IXQEQueryNode[] tnodes = node.getDescendantsOfType(601024, false);
        ArrayList<RelationalOlapDecorationNode> facts = new ArrayList<RelationalOlapDecorationNode>();
        ArrayList<RelationalOlapDecorationNode> projectedNonFacts = new ArrayList<RelationalOlapDecorationNode>();
        ArrayList<RelationalOlapDecorationNode> projectedLevelOrProp = new ArrayList<RelationalOlapDecorationNode>();
        ArrayList<RelationalOlapDecorationNode> nonProjectedNonFacts = new ArrayList<RelationalOlapDecorationNode>();
        for (IXQEQueryNode tnode : tnodes) {
            RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
            Integer tp = relOLAPDeco.getWrapType();
            if (tp != null) continue;
            String[] aggrRollUp = new String[]{null, null, null};
            tp = MixedDMRRelUtil.getWrapType(relOLAPDeco, param, aggrRollUp);
            if (tp == 0) {
                facts.add(relOLAPDeco);
                continue;
            }
            RelationalOlapDecorationNode levelOrProp = MixedDMRRelUtil.getExistingLevelOrProperty(param, relOLAPDeco);
            if (levelOrProp != null) {
                projectedNonFacts.add(relOLAPDeco);
                projectedLevelOrProp.add(levelOrProp);
                continue;
            }
            nonProjectedNonFacts.add(relOLAPDeco);
        }
        if (projectedNonFacts.isEmpty() && facts.isEmpty()) {
            V5DetailFilter filter = (V5DetailFilter)node;
            filter.setPropertyValue("postAutoAggregation", Boolean.FALSE);
            filter.setPropertyValue("dmrSlicer", Boolean.TRUE);
            if (!nonProjectedNonFacts.isEmpty()) {
                StringBuilder expStr = new StringBuilder();
                ((RelationalOlapDecorationNode)nonProjectedNonFacts.get(0)).getChild(0).writeFormattedText(expStr);
                int aSeverity = 1;
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PAADetailFilterNonFactNonProj, expStr.toString()));
            }
            for (IXQEQueryNode tnode : tnodes) {
                RelationalOlapDecorationNode relOLAPDeco = (RelationalOlapDecorationNode)tnode;
                Integer tp = relOLAPDeco.getWrapType();
                if (tp != null) continue;
                tnode.extract();
            }
            return;
        }
        if (!(nonProjectedNonFacts.isEmpty() || projectedNonFacts.isEmpty() && facts.isEmpty())) {
            StringBuilder expStr = new StringBuilder();
            ((RelationalOlapDecorationNode)nonProjectedNonFacts.get(0)).getChild(0).writeFormattedText(expStr);
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_PAADetailFilterNonFactNonProjAndFact, expStr.toString());
        }
        for (int i = 0; i < projectedNonFacts.size(); ++i) {
            RelationalOlapDecorationNode nonFact = (RelationalOlapDecorationNode)projectedNonFacts.get(i);
            RelationalOlapDecorationNode levelOrProperty = (RelationalOlapDecorationNode)projectedLevelOrProp.get(i);
            Integer tp = levelOrProperty.getWrapType();
            nonFact.setWrapType(new Integer(2));
            if (tp == 2) {
                nonFact.setWrapRefObjectName(levelOrProperty.getWrapName());
                nonFact.setWrapOwnerName(levelOrProperty.getWrapOwnerName());
                nonFact.detachChildren();
                continue;
            }
            String levelName = levelOrProperty.getWrapName();
            RelationalOlapDecorationNode prop = MixedDMRRelUtil.getLevelProperty(param, levelName, "LEVELKEY");
            if (prop == null) {
                MixedDMRRelUtil.wrapToLevelProperty(nonFact, param, levelName, "LEVELKEY", "LEVELKEY");
                continue;
            }
            nonFact.setWrapRefObjectName(prop.getWrapName());
            nonFact.setWrapOwnerName(prop.getWrapOwnerName());
            nonFact.detachChildren();
        }
        MixedDMRRelUtil.convertOLAPUnsupportedExpr(param.factory, node);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Boolean b = ((V5DetailFilter)node).isMixedDMRRelational();
        boolean bl = status = b != null && b != false;
        if (status) {
            this.traceNodeCondition(status, "need to set TNode information in relational PAA detail filter.", trace);
        } else {
            this.traceNodeCondition(status, "don't set TNode information in relational PAA detail filter.", trace);
        }
        return status;
    }
}

