/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class ValidateListQuery
extends Transformation {
    protected static final int MAX_TRY = 500;

    public ValidateListQuery() {
        this.mName = "Validate the list query RSAPIDataset.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{101055};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        void var14_18;
        IXQEQueryNode[] detailFilters;
        IXQEQueryNode[] dataItems;
        node.removeProperty("wrapTo");
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        rsapiDataset.validateReportLayout();
        String refQueryName = rsapiDataset.getRefQueryName();
        V5QuerySet querySet = (V5QuerySet)rsapiDataset.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(refQueryName);
        HashSet<String> v5DataItemNameUsed = new HashSet<String>();
        HashMap<String, ArrayList<V5DataItem>> v5DataItemsInExpr = new HashMap<String, ArrayList<V5DataItem>>();
        V5Selection selection = query.getV5Selection();
        for (IXQEQueryNode iXQEQueryNode : dataItems = selection.getChildrenOfType(101003)) {
            v5DataItemNameUsed.add(((V5DataItem)iXQEQueryNode).getNameProperty());
            this.getV5DataItemsInExpression(iXQEQueryNode, v5DataItemsInExpr);
        }
        IXQEQueryNode[] iXQEQueryNodeArray = detailFilters = query.getV5DetailFilters();
        int n = iXQEQueryNodeArray.length;
        boolean bl = false;
        while (var14_18 < n) {
            IXQEQueryNode detailFilter = iXQEQueryNodeArray[var14_18];
            this.getV5DataItemsInExpression(detailFilter, v5DataItemsInExpr);
            ++var14_18;
        }
        IXQEQueryNode[] sumFilters = query.getV5SummaryFilters();
        for (IXQEQueryNode sumFilter : sumFilters) {
            this.getV5DataItemsInExpression(sumFilter, v5DataItemsInExpr);
        }
        for (Map.Entry entry : v5DataItemsInExpr.entrySet()) {
            String newName = this.getUniqueName((String)entry.getKey(), v5DataItemNameUsed);
            if (newName.equals(entry.getKey())) continue;
            v5DataItemNameUsed.add(newName);
            for (V5DataItem item : (ArrayList)entry.getValue()) {
                item.setNameProperty(newName);
            }
        }
    }

    protected void getV5DataItemsInExpression(IXQEQueryNode item, HashMap<String, ArrayList<V5DataItem>> v5DataItemsInExpr) {
        IXQEQueryNode[] itemsInExpr;
        for (IXQEQueryNode itemInExpr : itemsInExpr = item.getDescendantsOfType(101003, false)) {
            String name = ((V5DataItem)itemInExpr).getNameProperty();
            ArrayList<Object> list = null;
            if (v5DataItemsInExpr.containsKey(name)) {
                list = v5DataItemsInExpr.get(name);
            } else {
                list = new ArrayList();
                v5DataItemsInExpr.put(name, list);
            }
            list.add((V5DataItem)itemInExpr);
        }
    }

    protected String getUniqueName(String orgName, HashSet<String> v5DataItemNameUsed) {
        if (!v5DataItemNameUsed.contains(orgName)) {
            return orgName;
        }
        for (int i = 0; i < 500; ++i) {
            String newName = orgName + "_" + Integer.toString(i);
            if (v5DataItemNameUsed.contains(newName)) continue;
            return newName;
        }
        return orgName;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String flag = (String)node.getPropertyValue("wrapTo");
        if (flag != null) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "need to validate the list query RSAPIDataset.", trace);
        } else {
            this.traceNodeCondition(status, "don't validate the list query RSAPIDataset.", trace);
        }
        return status;
    }
}

