/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;

public final class ValidateRelationalListForOLAPConstructs
extends Transformation {
    public ValidateRelationalListForOLAPConstructs() {
        this.mName = "Validate relational crosstab for OLAP constructs.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query v5Query = v5QRD.getV5Query();
        if (MixedDMRRelUtil.cleanUpCaptionOnRelational(v5Query)) {
            if (!this.hasOLAPConstructInQuery(v5Query, 0, environment)) {
                v5Query.setPropertyValue("isTabular", true);
            }
            return;
        }
        v5QRD.setMixedDMRRelational(Boolean.TRUE);
        v5QRD.setPropertyValue("checkOLAPFuncOnRelDone", Boolean.TRUE);
        int action = 1;
        if (MixedDMRRelUtil.denyOLAPFuncOnRelInList(environment)) {
            action |= 2;
        }
        this.hasOLAPConstructInQuery(v5Query, action, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean b;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query v5Query = v5QRD.getV5Query();
        if (v5QRD.isList() && !v5Query.isTabular() && v5Query.isRelStyle() && !v5Query.isDMR() && ((b = v5QRD.isMixedDMRRelational()) == null || b != Boolean.TRUE)) {
            status = this.hasOLAPConstructInQuery(v5Query, 0, environment);
        }
        if (status) {
            this.traceNodeCondition(status, "need to throw error because relatioanl list report uses OLAP constructs.", trace);
        } else {
            this.traceNodeCondition(status, "relatioanl list report does not use OLAP constructs .", trace);
        }
        return status;
    }

    protected boolean hasOLAPConstructInQuery(V5Query v5Query, int action, PlanningEnvironment env) {
        IXQEQueryNode[] summaryFilters;
        IXQEQueryNode[] detailFilters;
        IXQEQueryNode[] items;
        boolean b = MixedDMRRelUtil.checkSlicers(v5Query.getV5Slicers(), action, env);
        V5Selection selection = v5Query.getV5Selection();
        for (IXQEQueryNode item : items = selection.getChildrenOfType(101003)) {
            if (!((V5DataItem)item).isOLAPConstruct()) continue;
            MixedDMRRelUtil.applyActions(action, env, item);
            b = true;
        }
        for (IXQEQueryNode aFilter : detailFilters = v5Query.getV5DetailFilters()) {
            V5DetailFilter detailFilter = (V5DetailFilter)aFilter;
            if (!detailFilter.isOLAPConstruct()) continue;
            MixedDMRRelUtil.applyActions(action, env, detailFilter);
            b = true;
        }
        for (IXQEQueryNode aSumFilter : summaryFilters = v5Query.getV5SummaryFilters()) {
            V5SummaryFilter summaryFilter = (V5SummaryFilter)aSumFilter;
            if (!summaryFilter.isOLAPConstruct()) continue;
            MixedDMRRelUtil.applyActions(action, env, summaryFilter);
            b = true;
        }
        return b;
    }
}

