/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;

public final class ValidateRelationalXtabForOLAPConstructs
extends Transformation {
    public ValidateRelationalXtabForOLAPConstructs() {
        this.mName = "Validate relational crosstab for OLAP constructs.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query v5Query = v5QRD.getV5Query();
        if (MixedDMRRelUtil.cleanUpCaptionOnRelational(v5Query)) {
            return;
        }
        v5QRD.setMixedDMRRelational(Boolean.TRUE);
        v5QRD.setPropertyValue("checkOLAPFuncOnRelDone", Boolean.TRUE);
        int action = 1;
        if (MixedDMRRelUtil.denyOLAPFuncOnRelInXtab(environment)) {
            action |= 2;
        }
        this.hasOLAPConstructs(environment, v5QRD, v5Query, action);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Boolean b;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        V5Query v5Query = v5QRD.getV5Query();
        V5Source v5Source = v5Query.getV5Source();
        if (!(v5QRD.isList() || v5Source == null || Boolean.TRUE != v5Source.getPropertyValue("needTabularStream") || !v5Query.isTabular() && !v5Query.isRelStyle() || (b = v5QRD.isMixedDMRRelational()) != null && b == Boolean.TRUE)) {
            status = this.hasOLAPConstructs(environment, v5QRD, v5Query, 0);
        }
        if (status) {
            this.traceNodeCondition(status, "need to throw error because relatioanl crosstab uses OLAP constructs.", trace);
        } else {
            this.traceNodeCondition(status, "relatioanl crosstab does not use OLAP constructs .", trace);
        }
        return status;
    }

    protected boolean hasOLAPConstructs(PlanningEnvironment env, V5QueryResultDefinition v5QRD, V5Query v5Query, int action) {
        IXQEQueryNode[] iXQEQueryNodeArray;
        IXQEQueryNode[] detailFilters;
        boolean b = MixedDMRRelUtil.checkSlicers(v5Query.getV5Slicers(), action, env);
        HashSet<String> itemsToLevelMeasure = new HashSet<String>();
        HashSet<V5DataItem> itemsWithOLAPConstructs = new HashSet<V5DataItem>();
        TreeSet<String> orderedItemsWithOLAP = new TreeSet<String>();
        this.collectToLevelMeasureItemsAndOLAPConstructItems(v5QRD, v5Query, itemsToLevelMeasure, itemsWithOLAPConstructs, orderedItemsWithOLAP);
        V5Selection selection = v5Query.getV5Selection();
        for (String string : orderedItemsWithOLAP) {
            V5DataItem dataItem = selection.getDataItemByRefName(string);
            if (MixedDMRRelUtil.isReportSummaryDataItem(v5QRD, dataItem)) {
                MixedDMRRelUtil.checkthrowWarningReportSummaryWithinSet(env, dataItem);
                continue;
            }
            MixedDMRRelUtil.applyActions(action, env, dataItem);
            if (this.validateExpressionWithOLAPConstruct(dataItem.getChild(0), itemsToLevelMeasure)) continue;
            b = true;
        }
        for (IXQEQueryNode aFilter : detailFilters = v5Query.getV5DetailFilters()) {
            V5DetailFilter detailFilter = (V5DetailFilter)aFilter;
            if (!detailFilter.isOLAPConstruct()) continue;
            MixedDMRRelUtil.applyActions(action, env, detailFilter);
            if (this.validateExpressionWithOLAPConstruct(detailFilter.getChild(0), itemsToLevelMeasure)) continue;
            b = true;
        }
        for (IXQEQueryNode aSumFilter : iXQEQueryNodeArray = v5Query.getV5SummaryFilters()) {
            V5SummaryFilter summaryFilter = (V5SummaryFilter)aSumFilter;
            if (!summaryFilter.isOLAPConstruct()) continue;
            MixedDMRRelUtil.applyActions(action, env, summaryFilter);
            if (this.validateExpressionWithOLAPConstruct(summaryFilter.getChild(0), itemsToLevelMeasure)) continue;
            b = true;
        }
        if (this.groupBodySortHasOLAPConstructs(v5QRD, v5Query)) {
            b = true;
        }
        if (this.reportSummaryHasNonFactChildren(v5QRD, v5Query, itemsToLevelMeasure)) {
            b = true;
        }
        return b;
    }

    protected void collectToLevelMeasureItemsAndOLAPConstructItems(V5QueryResultDefinition v5QRD, V5Query v5Query, HashSet<String> itemsToLevelMeasure, HashSet<V5DataItem> itemsWithOLAPConstructs, TreeSet<String> orderedItemsWithOLAP) {
        IXQEQueryNode[] valueSets;
        V5Selection selection = v5Query.getV5Selection();
        for (IXQEQueryNode valueSet : valueSets = v5QRD.getDescendantsOfType(101057, false)) {
            String refDataItemName = ((V5ValueSet)valueSet).getRefDataItemProperty();
            V5DataItem dataItem = selection.getDataItemByRefName(refDataItemName);
            if (dataItem.isOLAPConstruct()) {
                itemsWithOLAPConstructs.add(dataItem);
                orderedItemsWithOLAP.add(refDataItemName);
                continue;
            }
            itemsToLevelMeasure.add(refDataItemName);
        }
    }

    protected boolean validateExpressionWithOLAPConstruct(IXQEQueryNode expr, HashSet<String> itemsToLevelMeasure) {
        IXQEQueryNode[] children;
        switch (expr.getType()) {
            case 101003: {
                if (!itemsToLevelMeasure.contains(((V5DataItem)expr).getNameProperty())) break;
                return true;
            }
            case 201097: 
            case 201103: 
            case 201116: {
                return false;
            }
            case 201060: {
                if (!((V5BoundDataItemReference)expr).isQueryRefItem()) break;
                return false;
            }
        }
        for (IXQEQueryNode child : children = expr.getChildren()) {
            if (this.validateExpressionWithOLAPConstruct(child, itemsToLevelMeasure)) continue;
            return false;
        }
        return true;
    }

    protected boolean groupBodySortHasOLAPConstructs(V5QueryResultDefinition v5QRD, V5Query v5Query) {
        IXQEQueryNode[] valueSets;
        boolean b = false;
        V5Selection selection = v5Query.getV5Selection();
        for (IXQEQueryNode valueSet : valueSets = v5QRD.getDescendantsOfType(101057, false)) {
            boolean isReportSummary;
            TreeSet<String> itemsInBodySort = new TreeSet<String>();
            TabStreamUtil.collectItemsInGroupBodySort(valueSet, itemsInBodySort);
            if (itemsInBodySort.isEmpty()) continue;
            String refDataItemName = ((V5ValueSet)valueSet).getRefDataItemProperty();
            V5DataItem dataItem = selection.getDataItemByRefName(refDataItemName);
            boolean bl = isReportSummary = TabStreamUtil.getReportSummaryDetailEdgeGroup((V5ValueSet)valueSet, dataItem, null) != null;
            if (isReportSummary || TabStreamUtil.isFactItem(dataItem)) {
                if (!this.checkGroupBodyForReportSummayOrFact(isReportSummary, (V5ValueSet)valueSet, selection)) continue;
                b = true;
                continue;
            }
            if (dataItem.isOLAPConstruct()) {
                b = true;
            }
            for (String itemName : itemsInBodySort) {
                V5DataItem item = selection.getDataItemByRefName(itemName);
                if (!item.isOLAPConstruct()) continue;
                b = true;
            }
        }
        return b;
    }

    protected boolean checkGroupBodyForReportSummayOrFact(boolean isReportSummary, V5ValueSet valueSet, V5Selection selection) {
        HashSet<String> itemsInBody = new HashSet<String>();
        IXQEQueryNode[] groupBodys = valueSet.getChildrenOfType(101051);
        for (IXQEQueryNode aBody : groupBodys) {
            IXQEQueryNode[] refItems;
            V5GroupBody groupBody = (V5GroupBody)aBody;
            for (IXQEQueryNode aItem : refItems = groupBody.getChildrenOfType(101015)) {
                V5DataItemRef ref = (V5DataItemRef)aItem;
                String refName = ref.getDataItemRefProperty();
                itemsInBody.add(refName);
            }
        }
        if (itemsInBody.isEmpty()) {
            return false;
        }
        for (String itemName : itemsInBody) {
            V5DataItem item = selection.getDataItemByRefName(itemName);
            if (item.isOLAPConstruct()) {
                return true;
            }
            if (isReportSummary || !TabStreamUtil.isFactItem(item)) continue;
            return true;
        }
        return false;
    }

    protected boolean reportSummaryHasNonFactChildren(V5QueryResultDefinition v5QRD, V5Query v5Query, HashSet<String> levelAndMeasureItems) {
        V5Selection selection = v5Query.getV5Selection();
        HashSet<String> measureItems = new HashSet<String>();
        for (String itemName : levelAndMeasureItems) {
            V5DataItem dataItem = selection.getDataItemByRefName(itemName);
            if (!TabStreamUtil.isFactItem(dataItem)) continue;
            measureItems.add(itemName);
        }
        ArrayList<IXQEQueryNode> olapValueSets = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] edges = v5QRD.getChildrenOfType(101049);
        for (IXQEQueryNode edge : edges) {
            if (!this.checkEdgeGroupForOLAP(edge, selection, measureItems, olapValueSets)) continue;
            return true;
        }
        for (IXQEQueryNode vs : olapValueSets) {
            String refDataItem = ((V5ValueSet)vs).getRefDataItemProperty();
            V5DataItem v5DataItem = selection.getDataItemByRefName(refDataItem);
            IXQEQueryNode parentGrp = vs.getParent();
            IXQEQueryNode parentOfparentGrp = parentGrp.getParent();
            IXQEQueryNode[] siblings = parentOfparentGrp.getChildrenOfType(101050);
            HashSet<String> itemsToRef = new HashSet<String>();
            for (IXQEQueryNode s : siblings) {
                if (s == parentGrp) continue;
                V5ValueSet valueSet = (V5ValueSet)s.getFirstChildByType(101057);
                String refDI = valueSet.getRefDataItemProperty();
                itemsToRef.add(refDI);
            }
            if (this.validateExpressionWithOLAPConstruct(v5DataItem.getChild(0), itemsToRef)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkEdgeGroupForOLAP(IXQEQueryNode node, V5Selection selection, HashSet<String> measureItems, ArrayList<IXQEQueryNode> olapValueSets) {
        IXQEQueryNode[] children;
        V5ValueSet valueSet;
        String refDataItem;
        V5DataItem v5DataItem;
        if (node.getType() == 101050 && (v5DataItem = selection.getDataItemByRefName(refDataItem = (valueSet = (V5ValueSet)node.getFirstChildByType(101057)).getRefDataItemProperty())).isOLAPConstruct()) {
            if (TabStreamUtil.getReportSummaryDetailEdgeGroup(valueSet, v5DataItem, null) != null) {
                return this.hasNonFactChildren(selection, node, measureItems);
            }
            olapValueSets.add(valueSet);
        }
        for (IXQEQueryNode aChild : children = node.getChildrenOfType(101050)) {
            if (!this.checkEdgeGroupForOLAP(aChild, selection, measureItems, olapValueSets)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNonFactChildren(V5Selection selection, IXQEQueryNode group, HashSet<String> measureItems) {
        IXQEQueryNode[] edgeGroups = group.getChildrenOfType(101050);
        if (edgeGroups.length == 0) {
            return false;
        }
        for (IXQEQueryNode child : edgeGroups) {
            V5ValueSet valueSet = (V5ValueSet)child.getFirstChildByType(101057);
            String refDataItem = valueSet.getRefDataItemProperty();
            V5DataItem v5DataItem = selection.getDataItemByRefName(refDataItem);
            if (v5DataItem.isOLAPConstruct() ? !this.validateExpressionWithOLAPConstruct(v5DataItem.getChild(0), measureItems) : !TabStreamUtil.isFactItem(v5DataItem)) {
                return true;
            }
            IXQEQueryNode[] childchildEdgeGroups = child.getChildrenOfType(101050);
            if (childchildEdgeGroups.length <= 0) continue;
            return true;
        }
        return false;
    }
}

