/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.HashSet;
import java.util.List;

public final class WrapReportSummaryGroupBodyToLevelProperty
extends Transformation {
    public WrapReportSummaryGroupBodyToLevelProperty() {
        this.mName = "Wrap V5DataItem in the report summary groupBody to level property.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101051};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] refItems;
        node.removeProperty("wrapTo");
        IXQEQueryNode thisValueSet = node.getAncestorOfType(101057);
        IXQEQueryNode edgeGroup = thisValueSet.getAncestorOfType(101050);
        edgeGroup = edgeGroup.getAncestorOfType(101050);
        IXQEQueryNode parentValueSet = edgeGroup.getFirstChildByType(101057);
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)edgeGroup.getAncestorOfType(101055);
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, v5QRD);
        V5DataItemToLevelWrapper level = TabStreamUtil.getLevel(env, (V5ValueSet)parentValueSet);
        if (level == null) {
            return;
        }
        List<String> processedNonFactDataItems = TabStreamUtil.getForClauseItems(env, (V5ValueSet)parentValueSet);
        HashSet<String> itemsInBody = new HashSet<String>();
        for (IXQEQueryNode aItem : refItems = node.getChildrenOfType(101015)) {
            V5DataItemRef ref = (V5DataItemRef)aItem;
            String refName = ref.getDataItemRefProperty();
            itemsInBody.add(refName);
        }
        V5Edge edge = (V5Edge)parentValueSet.getAncestorOfType(101049);
        String edgeName = (String)edge.getPropertyValue("name");
        String valueSetName = ((V5ValueSet)thisValueSet).getNameProperty();
        int pos = level.getNumberOfExistingMemberProperties();
        for (String prop : itemsInBody) {
            V5DataItem dataItem = env.mSelection.getDataItemByRefName(prop);
            String orgName = (String)dataItem.getPropertyValue("orgName");
            RSAPIUsage usage = TabStreamUtil.getUsage(dataItem);
            V5DataItemToLevelAttributeWrapper propObj = TabStreamUtil.createALevelPropertyForDataItem(env, prop, pos++, level, processedNonFactDataItems);
            String dataItemNameinRSAPI = prop;
            if (orgName != null && !orgName.equals(prop)) {
                dataItemNameinRSAPI = orgName;
            }
            TabStreamUtil.updateRSAPIDataItem(env, propObj, edgeName, valueSetName, dataItemNameinRSAPI, usage);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Boolean flag = (Boolean)node.getPropertyValue("wrapTo");
        if (flag != null && flag.equals(Boolean.TRUE)) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "need to wrap V5DataItems in report summary groupBody to level property.", trace);
        } else {
            this.traceNodeCondition(status, "don't wrap V5DataItems in groupBody.", trace);
        }
        return status;
    }
}

