/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.CreateExternalRollUp;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public final class WrapV5EdgeToHierarchy
extends Transformation {
    public WrapV5EdgeToHierarchy() {
        this.mName = "Wrap V5DataItem in an edge to levels of a hierarchy.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] edges;
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, (V5QueryResultDefinition)node);
        V5Edge reportMeasureEdge = CreateExternalRollUp.getReportMeasureEdge(env, (V5QueryResultDefinition)node);
        if (reportMeasureEdge != null) {
            reportMeasureEdge.setPropertyValue("reportMeasure", Boolean.TRUE);
        }
        for (IXQEQueryNode edge : edges = node.getChildrenOfType(101049)) {
            boolean bNew = this.wrapV5DataItemsInEdgeNew(env, edge);
            if (bNew) continue;
            this.wrapV5DataItemsInEdge(env, edge);
        }
        node.removeProperty("tabstreamDefinition");
    }

    protected boolean wrapV5DataItemsInEdgeNew(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode edge) {
        IXQEQueryNode[] allGrps;
        ArrayList<List<IXQEQueryNode>> flatList = new ArrayList<List<IXQEQueryNode>>();
        for (IXQEQueryNode g : allGrps = edge.getDescendantsOfType(101050, false)) {
            IXQEQueryNode v5GrpTmp = g.getFirstChildByType(101050);
            if (v5GrpTmp != null) continue;
            ArrayList<IXQEQueryNode> list = new ArrayList<IXQEQueryNode>();
            list.add(g);
            for (IXQEQueryNode parent = g.getParent(); parent != null && parent.getType() != 101049; parent = parent.getParent()) {
                if (parent.getType() != 101050) continue;
                list.add(parent);
            }
            Collections.reverse(list);
            flatList.add(list);
        }
        boolean b = this.wrapV5DataItemsInEdgeTopMeasuresSamePath(env, flatList);
        return b;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean wrapV5DataItemsInEdgeTopMeasuresSamePath(TabStreamUtil.WrapCommonObjects env, ArrayList<List<IXQEQueryNode>> flatList) {
        if (flatList.size() <= 1 || flatList.get(0).size() <= 1) {
            return false;
        }
        for (List<IXQEQueryNode> p : flatList) {
            V5ValueSet v5ValueSet = (V5ValueSet)p.get(0).getFirstChildByType(101057);
            String refDataItem = v5ValueSet.getRefDataItemProperty();
            V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(refDataItem);
            if (!v5DataItem.isOLAPConstruct() && TabStreamUtil.isFactItem(v5DataItem)) continue;
            return false;
        }
        HashMap groupedByPathDataItems = new HashMap();
        for (List list : flatList) {
            ArrayList<Object> diPath = new ArrayList<Object>();
            for (int i = 1; i < list.size(); ++i) {
                V5ValueSet valueSet = (V5ValueSet)((IXQEQueryNode)list.get(i)).getFirstChildByType(101057);
                String refDataItem = valueSet.getRefDataItemProperty();
                V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(refDataItem);
                if (v5DataItem.isOLAPConstruct() || TabStreamUtil.isFactItem(v5DataItem)) {
                    return false;
                }
                diPath.add(refDataItem);
            }
            ArrayList<List> grouped = (ArrayList<List>)groupedByPathDataItems.get(diPath);
            if (grouped == null) {
                grouped = new ArrayList<List>();
                groupedByPathDataItems.put(diPath, grouped);
            }
            grouped.add(list);
        }
        if (groupedByPathDataItems.size() != 1) {
            return false;
        }
        Dimension dimension = this.ensureDimension(env, null);
        Object var5_8 = null;
        Boolean[] itemsInBodySort = null;
        V5ValueSet[] vSets = null;
        List[] relatedVS = null;
        for (List<IXQEQueryNode> p : flatList) {
            int i;
            void var5_9;
            V5ValueSet valueSet = (V5ValueSet)p.get(0).getFirstChildByType(101057);
            String refDataItem = valueSet.getRefDataItemProperty();
            V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(refDataItem);
            this.setV5DataItemInValueSetToMeasure(env, v5DataItem);
            if (var5_9 == null) {
                V5DataItemToLevelWrapper[] v5DataItemToLevelWrapperArray = new V5DataItemToLevelWrapper[p.size()];
                itemsInBodySort = new Boolean[p.size()];
                vSets = new V5ValueSet[p.size()];
                relatedVS = new List[p.size()];
                for (i = 1; i < p.size(); ++i) {
                    vSets[i] = (V5ValueSet)p.get(i).getFirstChildByType(101057);
                    Integer exist = this.getExistsTopValuesetSameRefDataItem(vSets, i);
                    V5DataItemToLevelWrapper lvl = null;
                    int lvlPos = i;
                    if (exist == null) {
                        lvl = this.wrapV5DataItemInValueSetToLevel(env, vSets[i], dimension);
                    } else {
                        lvlPos = exist;
                        lvl = v5DataItemToLevelWrapperArray[exist];
                        if (relatedVS[lvlPos] == null) {
                            relatedVS[lvlPos] = new ArrayList();
                        }
                        relatedVS[lvlPos].add(vSets[i]);
                    }
                    v5DataItemToLevelWrapperArray[i] = lvl;
                    TreeSet<String> tmp = new TreeSet<String>();
                    TabStreamUtil.collectItemsInGroupBodySort(vSets[i], tmp);
                    if (tmp.isEmpty()) continue;
                    itemsInBodySort[lvlPos] = Boolean.TRUE;
                }
                continue;
            }
            for (i = 1; i < p.size(); ++i) {
                valueSet = (V5ValueSet)p.get(i).getFirstChildByType(101057);
                valueSet.setPropertyValue("scope", var5_9[i]);
                int lvlPos = i;
                Integer exist = this.getExistsTopValuesetSameRefDataItem(vSets, i);
                if (exist != null) {
                    lvlPos = exist;
                }
                if (relatedVS[lvlPos] == null) {
                    relatedVS[lvlPos] = new ArrayList();
                }
                relatedVS[lvlPos].add(valueSet);
                TreeSet<String> tmp = new TreeSet<String>();
                TabStreamUtil.collectItemsInGroupBodySort(valueSet, tmp);
                if (tmp.isEmpty()) continue;
                itemsInBodySort[lvlPos] = Boolean.TRUE;
            }
        }
        for (int i = 1; i < itemsInBodySort.length; ++i) {
            if (!Boolean.TRUE.equals(itemsInBodySort[i])) continue;
            vSets[i].setPropertyValue("wrapTo", "none");
            if (relatedVS[i] == null) continue;
            vSets[i].setPropertyValue("sameLevelValueSets", relatedVS[i]);
        }
        return true;
    }

    private Integer getExistsTopValuesetSameRefDataItem(V5ValueSet[] vSets, int endPos) {
        String itemNm;
        String itemName = vSets[endPos].getRefDataItemProperty();
        Integer rt = null;
        for (int i = endPos - 1; i > 0 && (itemNm = vSets[i].getRefDataItemProperty()).equals(itemName); --i) {
            rt = new Integer(i);
        }
        return rt;
    }

    protected void wrapV5DataItemsInEdge(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode edge) {
        Dimension dimension = null;
        ArrayList<HashSet<String>> scope = TabStreamUtil.getScopeProperty(edge);
        boolean sibling = scope != null && scope.size() > 1;
        this.wrapV5DataItemInEdgeGroup(env, edge, dimension, sibling);
    }

    protected void wrapV5DataItemInEdgeGroup(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode node, Dimension dimension, boolean sibling) {
        IXQEQueryNode[] children;
        if (node.getType() == 101050) {
            V5ValueSet valueSet = (V5ValueSet)node.getFirstChildByType(101057);
            String refDataItem = valueSet.getRefDataItemProperty();
            V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(refDataItem);
            if (!v5DataItem.isOLAPConstruct()) {
                if (!TabStreamUtil.isFactItem(v5DataItem)) {
                    if (sibling && this.hasSiblingsNonFact(env, node)) {
                        dimension = TabStreamUtil.createDimensionWrapper(env.mCube);
                        this.setNullsSuppressionOnEdge(node);
                    } else {
                        dimension = this.ensureDimension(env, dimension);
                    }
                    RSAPIDataItem rsapiDataItem = valueSet.getRSAPIDataItem();
                    if (rsapiDataItem.getUsage() == RSAPIUsage.FACT) {
                        rsapiDataItem.setUsage(RSAPIUsage.IDENTIFIER);
                    }
                    this.wrapV5DataItemInValueSetToLevel(env, valueSet, dimension);
                    this.setFlagForGroupBodySort(valueSet);
                } else {
                    this.setV5DataItemInValueSetToMeasure(env, v5DataItem);
                }
            } else if (!TabStreamUtil.useSameDataItemAsParent(refDataItem, node.getParent())) {
                V5DataItem tabDataItem = env.mTabSelection.getDataItemByRefName(refDataItem);
                if (tabDataItem != null) {
                    Integer colPos = TabStreamUtil.getDataItemPos(env.mTabSelection, refDataItem);
                    String newName = refDataItem + valueSet.getNameProperty();
                    v5DataItem = (V5DataItem)env.mFactory.deepCopyNode(v5DataItem);
                    v5DataItem.setNameProperty(newName);
                    v5DataItem.setPropertyValue("orgName", refDataItem);
                    env.mSelection.addChild(v5DataItem);
                    valueSet.setRefDataItemProperty(newName);
                    if (sibling && this.hasSiblingsNonFact(env, node)) {
                        dimension = TabStreamUtil.createDimensionWrapper(env.mCube);
                        this.setNullsSuppressionOnEdge(node);
                    } else {
                        dimension = this.ensureDimension(env, dimension);
                    }
                    V5DataItemToLevelWrapper level = this.replaceV5DataItemExpressionToLevelWrapper(env, v5DataItem, dimension, refDataItem, tabDataItem.getDataType(), colPos);
                    valueSet.setPropertyValue("scope", level);
                    this.updateGroupBodySort(valueSet, refDataItem, newName);
                    this.setFlagForGroupBodySort(valueSet);
                } else {
                    valueSet.setPropertyValue("wrapTo", "TBAggregate_");
                    v5DataItem.setPropertyValue("wrapTo", "TBAggregate_" + valueSet.getNameProperty());
                    if (TabStreamUtil.needDecompose(env.mEnvironment, v5DataItem)) {
                        v5DataItem.setPropertyValue("needDecompose", Boolean.TRUE);
                    }
                }
            }
        }
        for (IXQEQueryNode aChild : children = node.getChildrenOfType(101050)) {
            this.wrapV5DataItemInEdgeGroup(env, aChild, dimension, sibling);
        }
    }

    private void setNullsSuppressionOnEdge(IXQEQueryNode node) {
        if (node.getParent().getType() != 101050) {
            return;
        }
        IXQEQueryNode edge = node.getAncestorOfType(101049);
        if (edge != null) {
            edge.setPropertyValue("suppressNullsForSiblings", Boolean.TRUE);
        }
    }

    protected V5DataItemToLevelWrapper wrapV5DataItemInValueSetToLevel(TabStreamUtil.WrapCommonObjects env, V5ValueSet valueSet, Dimension dimension) {
        int idx;
        String refDataItem = valueSet.getRefDataItemProperty();
        V5DataItem v5DataItem = env.mSelection.getDataItemByRefName(refDataItem);
        Integer colPos = null;
        ArrayList seen = (ArrayList)env.mTabSelection.getPropertyValue("scope");
        if (seen != null && (idx = seen.indexOf(v5DataItem.getNameProperty())) != -1) {
            colPos = XQEIntegerPool.getInteger(idx);
            ArrayList<String> getFromSeen = (ArrayList<String>)env.mTabSelection.getPropertyValue("relationalCrossTab");
            if (getFromSeen == null) {
                getFromSeen = new ArrayList<String>();
                env.mTabSelection.setPropertyValue("relationalCrossTab", getFromSeen);
            }
            getFromSeen.add(v5DataItem.getNameProperty());
        }
        if (colPos == null) {
            colPos = XQEIntegerPool.getInteger(env.mTabSelection.getChildrenOfType(101003).length);
            V5DataItem tabDataItem = (V5DataItem)env.mFactory.deepCopyNode(v5DataItem);
            TabStreamUtil.addItemToListQuery(env, tabDataItem);
        }
        V5DataItemToLevelWrapper level = this.replaceV5DataItemExpressionToLevelWrapper(env, v5DataItem, dimension, refDataItem, v5DataItem.getDataType(), colPos);
        valueSet.setPropertyValue("scope", level);
        return level;
    }

    protected Dimension ensureDimension(TabStreamUtil.WrapCommonObjects env, Dimension dimension) {
        if (dimension != null) {
            return dimension;
        }
        return TabStreamUtil.createDimensionWrapper(env.mCube);
    }

    protected V5DataItemToLevelWrapper replaceV5DataItemExpressionToLevelWrapper(TabStreamUtil.WrapCommonObjects env, V5DataItem v5DataItem, Dimension dimension, String caption, IDataType dataType, Integer colPos) {
        int levelId = dimension.getLevelCount();
        String levelName = "TBlevel_" + levelId;
        V5DataItemToLevelWrapper levelwrapper = new V5DataItemToLevelWrapper(dimension, dimension.getCube().getConnection(), levelName, caption, dataType, Integer.toString(colPos));
        ((Hierarchy)dimension.getDefaultHierarchy()).addLevel(levelwrapper);
        levelwrapper.setProperty("ReturnRaw", Boolean.TRUE);
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)env.mFactory.createNode(201116);
        newNode.setIdentifier(levelwrapper.getV5UniqueName());
        newNode.setMetadata(levelwrapper);
        IXQEQueryNode v5MembersNode = env.mFactory.createNode(201086);
        newNode.insertParent(v5MembersNode);
        v5DataItem.exchangeChildNode(v5DataItem.getChild(0), v5MembersNode);
        return levelwrapper;
    }

    protected void setV5DataItemInValueSetToMeasure(TabStreamUtil.WrapCommonObjects env, V5DataItem v5DataItem) {
        if (TabStreamUtil.needDecompose(env.mEnvironment, v5DataItem)) {
            v5DataItem.setPropertyValue("wrapTo", "calculated");
        } else {
            v5DataItem.setPropertyValue("wrapTo", "summarize");
        }
    }

    protected void setFlagForGroupBodySort(V5ValueSet valueSet) {
        TreeSet<String> itemsInBodySort = new TreeSet<String>();
        TabStreamUtil.collectItemsInGroupBodySort(valueSet, itemsInBodySort);
        if (!itemsInBodySort.isEmpty()) {
            valueSet.setPropertyValue("wrapTo", "none");
        }
    }

    protected void updateGroupBodySort(V5ValueSet valueSet, String refDataItem, String newName) {
        IXQEQueryNode[] sorts;
        IXQEQueryNode[] groupBodys;
        for (IXQEQueryNode aBody : groupBodys = valueSet.getChildrenOfType(101051)) {
            IXQEQueryNode[] refItems;
            V5GroupBody groupBody = (V5GroupBody)aBody;
            for (IXQEQueryNode aItem : refItems = groupBody.getChildrenOfType(101015)) {
                V5DataItemRef ref = (V5DataItemRef)aItem;
                String refName = ref.getDataItemRefProperty();
                if (!refDataItem.equals(refName)) continue;
                ref.setPropertyValue("refDataItem", newName);
            }
        }
        for (IXQEQueryNode aSort : sorts = valueSet.getChildrenOfType(101056)) {
            String refName = ((V5SortItem)aSort).getRefDataItem();
            if (!refDataItem.equals(refName)) continue;
            aSort.setPropertyValue("refDataItem", newName);
        }
    }

    protected boolean hasSiblingsNonFact(TabStreamUtil.WrapCommonObjects env, IXQEQueryNode edgeGroup) {
        IXQEQueryNode[] edgeGroups;
        for (IXQEQueryNode child : edgeGroups = edgeGroup.getParent().getChildrenOfType(101050)) {
            V5ValueSet valueSet;
            String refDataItem;
            V5DataItem v5DataItem;
            if (child == edgeGroup || (v5DataItem = env.mSelection.getDataItemByRefName(refDataItem = (valueSet = (V5ValueSet)child.getFirstChildByType(101057)).getRefDataItemProperty())).isOLAPConstruct() || TabStreamUtil.isFactItem(v5DataItem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Object tabDef = node.getPropertyValue("tabstreamDefinition");
        if (tabDef != null) {
            V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
            V5Query v5Query = v5QRD.getV5Query();
            V5Source src = v5Query.getV5Source();
            Object cube = src.getPropertyValue("needTabularStream");
            status = cube instanceof CubeWrapper;
        }
        if (status) {
            this.traceNodeCondition(status, "need to wrap V5DataItems in an edge to levels of a hierarchy.", trace);
        } else {
            this.traceNodeCondition(status, "don't wrap edge in relatioanl crosstab to hierarchy.", trace);
        }
        return status;
    }
}

