/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.TabStreamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public final class WrapV5GroupBodySortToLevelProperty
extends Transformation {
    public WrapV5GroupBodySortToLevelProperty() {
        this.mName = "Wrap V5DataItem in the groupBody / groupSort to level property.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.removeProperty("wrapTo");
        V5ValueSet valueSet = (V5ValueSet)node;
        String refDataItem = valueSet.getRefDataItemProperty();
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        TabStreamUtil.WrapCommonObjects env = TabStreamUtil.createCommonObjectsWrapper(environment, v5QRD);
        V5DataItemToLevelWrapper level = TabStreamUtil.getLevel(env, valueSet);
        TreeSet<String> itemsInBodySort = new TreeSet<String>();
        TabStreamUtil.collectItemsInGroupBodySort(valueSet, itemsInBodySort);
        List<String> processedNonFactDataItems = TabStreamUtil.getForClauseItems(env, valueSet);
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        String edgeName = (String)edge.getPropertyValue("name");
        String valueSetName = valueSet.getNameProperty();
        ArrayList<IXQEQueryNode> childrenSameItem = (ArrayList<IXQEQueryNode>)valueSet.getPropertyValue("sameLevelValueSets");
        if (childrenSameItem != null) {
            valueSet.removeProperty("sameLevelValueSets");
        } else {
            childrenSameItem = new ArrayList<IXQEQueryNode>();
            TabStreamUtil.getChildrenValueSetSameRefItem(node.getParent(), node, refDataItem, childrenSameItem);
        }
        for (IXQEQueryNode c : childrenSameItem) {
            TabStreamUtil.collectItemsInGroupBodySort(c, itemsInBodySort);
        }
        int pos = 0;
        for (String prop : itemsInBodySort) {
            V5DataItem dataItem = env.mSelection.getDataItemByRefName(prop);
            String orgName = (String)dataItem.getPropertyValue("orgName");
            RSAPIUsage usage = TabStreamUtil.getUsage(dataItem);
            V5DataItemToLevelAttributeWrapper propObj = TabStreamUtil.createALevelPropertyForDataItem(env, prop, pos++, level, processedNonFactDataItems);
            if (TabStreamUtil.itemUsedByGroupBody(valueSet, prop)) {
                String dataItemNameinRSAPI = prop;
                if (orgName != null && !orgName.equals(prop)) {
                    dataItemNameinRSAPI = orgName;
                }
                TabStreamUtil.updateRSAPIDataItem(env, propObj, edgeName, valueSetName, dataItemNameinRSAPI, usage);
            }
            for (IXQEQueryNode c : childrenSameItem) {
                if (!TabStreamUtil.itemUsedByGroupBody(c, prop)) continue;
                String dataItemNameinRSAPI = prop;
                if (orgName != null && !orgName.equals(prop)) {
                    dataItemNameinRSAPI = orgName;
                }
                TabStreamUtil.updateRSAPIDataItem(env, propObj, edgeName, ((V5ValueSet)c).getNameProperty(), dataItemNameinRSAPI, usage);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String flag = (String)node.getPropertyValue("wrapTo");
        if (flag != null && flag.equals("none")) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "need to wrap V5DataItems in groupBody / groupSort to level property.", trace);
        } else {
            this.traceNodeCondition(status, "don't wrap V5DataItems in groupBody / groupSort.", trace);
        }
        return status;
    }
}

