/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream.dmrtorel;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.ReplaceDMRMemberInDetailFilterExpression;
import com.cognos.xqe.transformation.v5.tabstream.dmrtorel.DMRToRelUtil;
import com.cognos.xqe.transformation.v5tocogmdx.binding.ExpandDMRMemberFilterExpression;

public class ExpandDMRMemberPushedFilterExpression
extends Transformation {
    public ExpandDMRMemberPushedFilterExpression() {
        this.mName = "Expand DMR member in pushed filter expression.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ReplaceDMRMemberInDetailFilterExpression.replaceDMRMember(node, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getBooleanPropertyValue("updatedInDMRMemberFilter") != null) {
            this.traceNodeCondition(false, "The MUN has been updated.", trace);
            return false;
        }
        if (!DMRToRelUtil.isInPushedDetailFilter(node)) {
            this.traceNodeCondition(false, "The bound DMR member is not within a pushed detail filter.", trace);
            return false;
        }
        String[] reason = new String[]{""};
        boolean b = ExpandDMRMemberFilterExpression.checkNodeCondition(node, reason);
        this.traceNodeCondition(b, reason[0], trace);
        return b;
    }
}

