/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream.dmrtorel;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.tabstream.dmrtorel.DMRToRelUtil;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.HashSet;

public class IdentityDMRtoRelationalQuery
extends Transformation {
    public IdentityDMRtoRelationalQuery() {
        this.mName = "IdentityDMRtoRelationalQuery";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        String qName = qrd.getRefQueryProperty();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        query.setPropertyValue("containsDMRPushedDetailFilters", Boolean.TRUE);
        if (Boolean.TRUE == query.getPropertyValue("forceDMRtoRQP")) {
            query.removeProperty("forceDMRtoRQP");
            DMRToRelUtil.convertDMRToRelational(environment, query);
            if (query.getPropertyValue("convertDMRToRelWithoutWarning") == null) {
                int aSeverity = 1;
                String queryName = (String)query.getPropertyValue("rootQueryName");
                if (queryName == null) {
                    queryName = (String)query.getPropertyValue("name");
                }
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_mixedDMRAndRelational, queryName));
            }
        } else {
            IXQEQueryNode[] detailFilters;
            for (IXQEQueryNode filter : detailFilters = query.getV5DetailFilters()) {
                if (!DecomposeScalarFunction.containDMRMetadataObjects(filter) || !this.isPushedDetailFilterForDMR(filter)) continue;
                filter.setPropertyValue("containsDMRPushedDetailFilters", Boolean.TRUE);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        String qName = qrd.getRefQueryProperty();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        if (Boolean.TRUE == query.getPropertyValue("forceDMRtoRQP")) {
            this.traceNodeCondition(true, "Query is forced to relational.", environment.getTrace());
            return true;
        }
        if (Boolean.TRUE == query.getPropertyValue("containsDMRPushedDetailFilters")) {
            this.traceNodeCondition(false, "Query is flagged as DMR to relational.", environment.getTrace());
            return false;
        }
        Object f = query.getPropertyValue("isDMR");
        if (f == null || !((Boolean)f).booleanValue()) {
            this.traceNodeCondition(false, "Query is not DMR.", environment.getTrace());
            return false;
        }
        if (this.dmrqueryContainsDMRObjectsOnlyInPushedDetailFilters(qrd, query)) {
            this.traceNodeCondition(true, "Query is DMR to relational.", environment.getTrace());
            return true;
        }
        this.traceNodeCondition(false, "Query is DMR.", environment.getTrace());
        return false;
    }

    protected boolean dmrqueryContainsDMRObjectsOnlyInPushedDetailFilters(V5QueryResultDefinition qrd, V5Query query) {
        IXQEQueryNode[] summaryFilters;
        IXQEQueryNode[] detailFilters;
        IXQEQueryNode[] slicers = query.getV5Slicers();
        if (slicers.length > 0) {
            return false;
        }
        ArrayList<IXQEQueryNode> filtersWithDMR = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode filter : detailFilters = query.getV5DetailFilters()) {
            if (!DecomposeScalarFunction.containDMRMetadataObjects(filter)) continue;
            if (this.isPushedDetailFilterForDMR(filter)) {
                filtersWithDMR.add(filter);
                continue;
            }
            return false;
        }
        if (filtersWithDMR.isEmpty()) {
            return false;
        }
        for (IXQEQueryNode sFilter : summaryFilters = query.getV5SummaryFilters()) {
            if (!DecomposeScalarFunction.containDMRMetadataObjects(sFilter) && !((V5SummaryFilter)sFilter).isOLAPConstruct()) continue;
            return false;
        }
        HashSet<String> projs = DecomposeScalarFunction.getProjectedDataItemNames(qrd, query);
        V5Selection select = query.getV5Selection();
        for (String di : projs) {
            V5DataItem item = select.getDataItemByRefName(di);
            if (!DecomposeScalarFunction.containDMRMetadataObjects(item) && !item.isOLAPConstruct()) continue;
            return false;
        }
        return true;
    }

    protected boolean isPushedDetailFilterForDMR(IXQEQueryNode filter) {
        Boolean masterDetail = (Boolean)filter.getPropertyValue("masterDetailDFilter");
        if (masterDetail != null && masterDetail.booleanValue() && filter.getDescendantsOfType(201127, false).length > 0) {
            return false;
        }
        if (((V5DetailFilter)filter).getPostAutoAggregation()) {
            return false;
        }
        return DMRUtilities.allOLAPFunctionsCanBeConvertedToRelationalExpr(filter) && !RQPUtilities.hasAggregateInExpression(filter);
    }
}

