/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.tabstream.dmrtorel;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.dmrtorel.DMRToRelUtil;
import com.cognos.xqe.transformation.v5tocogmdx.binding.UpdateBoundHierarchyToLevels;

public class UpdateBoundDMRHierarchyToDMRLevels
extends Transformation {
    public UpdateBoundDMRHierarchyToDMRLevels() {
        this.mName = "Update bound DMR hierarchy with DMR levels.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DetailFilter detailFilter = (V5DetailFilter)node.getAncestorOfType(101008);
        IXQEQueryNode filterExpression = detailFilter.getChild(0);
        UpdateBoundHierarchyToLevels.updateBoundHierarchyToLevels(environment.getNodeFactory(), node, filterExpression);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!DMRToRelUtil.isInPushedDetailFilter(node)) {
            this.traceNodeCondition(false, "The bound identifier is not within a pushed detail filter.", trace);
            return false;
        }
        IMetadata metadata = ((V5BoundModelIdentifier)node).getMetadata();
        if (metadata != null && metadata instanceof HierarchyWrapper) {
            this.traceNodeCondition(true, "The bound identifier is for a hierarchy to be converted.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The bound identifier do not need any conversion.", trace);
        return false;
    }
}

