/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.todeprecate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ConvertSetWithSingleMemberToMember
extends Transformation {
    public ConvertSetWithSingleMemberToMember() {
        this.mName = "Remove the Set over a single member expression when filtering on namedSet.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201101};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        parent.exchangeChildNode(node, node.getChild(0));
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode[] v5DetailFilterNodes = node.getAncestorsOfType(101008);
        if (v5DetailFilterNodes != null && v5DetailFilterNodes.length > 0) {
            this.traceNodeCondition(true, "The set has a V5DetailFilter ancestor.", trace);
            status = true;
        } else {
            this.traceQueryCondition(status, "The set has no ancestor of type V5DetailFilter.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int[] categories;
        IXQEQueryNode child;
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 1) {
            this.traceQueryCondition(false, "The V5 set defined has more than one member.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (!parent.isOfCategory(201013) || parent.getPositionOfChild(node) != 1) {
            this.traceQueryCondition(false, "We only strip off the set over single member for detail filter", trace);
            return false;
        }
        if (node.getNumberChildren() == 1 && ((child = node.getChild(0)).isOfCategories(categories = new int[]{201117, 201121}) || child.getType() == 101003 && child.getChild(0).isOfCategories(categories))) {
            this.traceQueryCondition(true, "The V5 set defined only has single member.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The V5 set either has more than one child or the child is not member.", trace);
        return false;
    }
}

