/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.todeprecate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ConvertV5BetweenToV5In
extends Transformation {
    private static final int VALID_NUM_ARGS = 3;

    public ConvertV5BetweenToV5In(int[] passNumbers) {
        this.mName = "Converts V5BetweenExpression to In Condition.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode v5InNode = nodeFactory.createNode(201011);
        IXQEQueryNode v5rangeSetNode = nodeFactory.createNode(201134);
        node.getChild(1).move(v5rangeSetNode);
        node.getChild(1).move(v5rangeSetNode);
        node.getChild(0).move(v5InNode);
        v5InNode.addChild(v5rangeSetNode);
        node.getParent().exchangeChildNode(node, v5InNode, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() < 3) {
            this.traceNodeCondition(false, "The V5BetweenExpression does not have the required number of operands.", trace);
            return false;
        }
        boolean bSetExpr = false;
        if (V5ExpressionCheck.isSetExpression(node.getChild(0)) || V5ExpressionCheck.canBeCoercedToSet(node.getChild(0))) {
            bSetExpr = true;
        }
        if (!bSetExpr) {
            this.traceNodeCondition(false, "The first parameter should be set expression for this transformation.", trace);
            return false;
        }
        boolean isValueExpression = true;
        for (int i = 1; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode valueExpr = node.getChild(i);
            if (V5ExpressionCheck.isValueExpression(valueExpr)) continue;
            isValueExpression = false;
            break;
        }
        if (isValueExpression) {
            this.traceNodeCondition(false, "The second and third parameters for V5BetweenExpression is value, it's invalid for this transformation.", trace);
            return false;
        }
        boolean isMemberExpression = true;
        for (int i = 1; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode valueExpr = node.getChild(i);
            if (V5ExpressionCheck.isMemberExpression(valueExpr)) continue;
            isMemberExpression = false;
            break;
        }
        if (!isMemberExpression) {
            this.traceNodeCondition(false, "The parameter for V5BetweenExpression is invalid.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The V5BetweenExpression is valid.", trace);
        return true;
    }
}

