/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.unwinding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPJoinInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.V5Unwind;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class CreateV5UnwindNode
extends Transformation {
    public CreateV5UnwindNode() {
        this.mName = "CreateV5UnwindNode";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101006};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Unwind v5Unwind = (V5Unwind)environment.getNodeFactory().createNode(101073);
        querySet.addChild(v5Unwind);
        IXQEQueryNode queryCopy = environment.getNodeFactory().deepCopyNode(node);
        v5Unwind.addChild(queryCopy);
        RQPJoinInfo joinInfo = (RQPJoinInfo)queryCopy.getFirstChildByType(801046);
        if (joinInfo != null) {
            joinInfo.createRepositoryInfo(environment.getMetadataConnection());
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getParent().getType() == 101073) {
            return false;
        }
        if (!this.isQueryROLAPOrDMR(node, environment)) {
            this.traceNodeCondition(false, "No relational or ROLAP datasource found", environment.getTrace());
            return false;
        }
        if (node.getPropertyValue("isDMR") != null) {
            this.traceNodeCondition(false, "Query is already marked processed at previous pass", environment.getTrace());
            return false;
        }
        V5Source source = (V5Source)node.getFirstChildByType(101007);
        return source == null || source.getPropertyValue("relational") == null;
    }

    public boolean isQueryROLAPOrDMR(IXQEQueryNode queryNode, PlanningEnvironment environment) {
        V5Query query = (V5Query)queryNode;
        List<IModelDataSource> modelDataSources = query.getMetadataConnectionMetadataPath(environment).getModelDataSources();
        int rolapDataSourceCount = 0;
        int dmrDataSourceCount = 0;
        for (IModelDataSource ds : modelDataSources) {
            if (ds.isROLAP()) {
                ++rolapDataSourceCount;
                continue;
            }
            if (!ds.isRelational() || ds.getCube() == null) continue;
            ++dmrDataSourceCount;
        }
        if (rolapDataSourceCount == modelDataSources.size() ? this.checkROLAPUnwindNeeded(queryNode, environment) : dmrDataSourceCount == modelDataSources.size()) {
            return true;
        }
        IXQEQueryNode[] nodes = queryNode.getDescendantsOfType(201116, false);
        if (!(nodes != null && nodes.length != 0 || (nodes = queryNode.getDescendantsOfType(201117, false)) != null && nodes.length != 0)) {
            return false;
        }
        for (IXQEQueryNode node : nodes) {
            V5BoundMultiPartIdentifier identifier = (V5BoundMultiPartIdentifier)node;
            IMetadata metadata = identifier.getMetadata();
            if (metadata == null) continue;
            if (MetadataType.isROLAP(metadata)) {
                return this.checkROLAPUnwindNeeded(queryNode, environment);
            }
            if (!metadata.isDMR()) continue;
            return true;
        }
        return false;
    }

    private boolean checkROLAPUnwindNeeded(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] nodes;
        for (IXQEQueryNode aNode : nodes = node.getDescendantsOfType(201116, false)) {
            IMeasure measure;
            String expression;
            V5BoundMultiPartIdentifier identifier = (V5BoundMultiPartIdentifier)aNode;
            IMetadata metadata = identifier.getMetadata();
            if (!(metadata instanceof IMeasure) || (expression = (measure = (IMeasure)metadata).getExpression()) == null || expression.length() <= 0) continue;
            return true;
        }
        nodes = node.getDescendantsOfType(201117, false);
        if (nodes.length > 0) {
            for (IXQEQueryNode uniqueName : nodes) {
                ILevel level = ((V5BoundMemberUniqueName)uniqueName).getLevel();
                IHierarchy hierarchy = level.getHierarchy();
                List<IMember> calcMembers = hierarchy.getCalculatedMembers();
                if (calcMembers == null) continue;
                String externalName = (String)uniqueName.getPropertyValue("externalMun");
                for (IMember calcMember : calcMembers) {
                    if (!calcMember.getUniqueName().equals(externalName)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

