/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.unwinding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5EmptySetFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.LocaleConverter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExpandChildrenROLAPCalculatedMember
extends Transformation {
    public ExpandChildrenROLAPCalculatedMember() {
        this.mName = "SubstituteROLAPCalculatedMemberWithModelExp";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201117};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent;
        String nativeName;
        Map<String, V5MemberUniqueName> munList;
        ROLAPCubeReservation reservation;
        V5BoundMemberUniqueName uniqueName = (V5BoundMemberUniqueName)node;
        ILevel level = uniqueName.getLevel();
        IHierarchy hierarchy = level.getHierarchy();
        String externalName = (String)uniqueName.getPropertyValue("externalMun");
        List<IMember> children = null;
        String cubeName = ROLAPContext.getCMDataSourceName(environment);
        if (cubeName == null) {
            cubeName = hierarchy.getDimension().getCube().getName();
        }
        ROLAPCube rolapCube = ROLAPCubeManager.getInstance().getCube(cubeName);
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if (rolapCube != null && (reservation = rolapCube.reserve()) != null) {
            try {
                String expressionLocale;
                String hierName = hierarchy.getName();
                IROLAPHierarchy rolapHier = (IROLAPHierarchy)rolapCube.getHierarchy(hierName);
                if (rolapHier == null && !(expressionLocale = LocaleConverter.localeToStr(reqEnv.getExpressionLocale())).equals(rolapCube.getDefaultLocale())) {
                    Iterator<IMetadata> hiers = rolapCube.getHierarchies().iterator();
                    while (hiers.hasNext() && !(rolapHier = (IROLAPHierarchy)hiers.next()).getName(expressionLocale).equals(hierName)) {
                    }
                }
                Member calcMember = null;
                if (rolapHier != null) {
                    for (ROLAPCalculatedMember hierCalcMember : rolapHier.getROLAPCalculatedMembers(cubeName)) {
                        if (!hierCalcMember.getUniqueName().equals(externalName)) continue;
                        calcMember = hierCalcMember;
                        break;
                    }
                    if (calcMember != null && calcMember.isExtendedCalculatedMember()) {
                        children = ((ROLAPCalculatedMember)calcMember).getAllChildren(cubeName);
                    }
                }
            }
            finally {
                rolapCube.unreserve(reservation);
            }
        }
        if ((munList = reqEnv.getV5Muns()).containsKey(nativeName = uniqueName.getNativeName())) {
            munList.remove(nativeName);
        }
        for (parent = node.getParent(); parent != null && !parent.isOfCategory(201120); parent = parent.getParent()) {
        }
        XQENodeFactory factory = environment.getNodeFactory();
        if (children == null || children.size() == 0) {
            V5EmptySetFunction emptySet = (V5EmptySetFunction)factory.createNode(201063);
            V5BoundModelIdentifier hierarchyNode = (V5BoundModelIdentifier)factory.createNode(201116);
            hierarchyNode.setMetadata(hierarchy);
            hierarchyNode.setIdentifier(hierarchy.getV5UniqueName());
            emptySet.addChild(hierarchyNode);
            parent.exchange(emptySet, false);
        } else {
            V5SetFunction set = (V5SetFunction)factory.createNode(201101);
            for (IMember childMember : children) {
                V5BoundMemberUniqueName boundMember = (V5BoundMemberUniqueName)factory.createNode(201117);
                boundMember.setMetadata(hierarchy.getLevel(childMember.getLevel().getIndex()));
                boundMember.setExternalMemberUniqueName(childMember.getUniqueName());
                boundMember.setNativeName(childMember.getV5UniqueName());
                set.addChild(boundMember);
            }
            parent.exchange(set, false);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent;
        XQETrace xqeTrace = environment.getTrace();
        if (ExpandChildrenROLAPCalculatedMember.isMetadataQuery(environment)) {
            this.traceNodeCondition(false, "Do not apply the transformation for metadata queries", xqeTrace);
            return false;
        }
        for (parent = node.getParent(); parent != null && !parent.isOfCategory(201120); parent = parent.getParent()) {
        }
        if (parent == null || parent.getType() != 201053) {
            this.traceNodeCondition(false, "Do not apply the transformation for members used outside of a children function", xqeTrace);
            return false;
        }
        V5BoundMemberUniqueName uniqueName = (V5BoundMemberUniqueName)node;
        ILevel level = uniqueName.getLevel();
        IHierarchy hierarchy = level.getHierarchy();
        List<IMember> calcMembers = hierarchy.getCalculatedMembers();
        for (IMember calcMember : calcMembers) {
            String externalName = (String)uniqueName.getPropertyValue("externalMun");
            if (!calcMember.getUniqueName().equals(externalName)) continue;
            this.traceNodeCondition(true, "The bound V5 member unique name is a ROLAP calculated member.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The bound V5 member unique name is not a ROLAP calculated member.", xqeTrace);
        return false;
    }

    public static boolean isMetadataQuery(PlanningEnvironment environment) {
        IXQEQueryNode[] nodes = environment.getRoot().getChildrenOfType(1101015);
        if (nodes != null && nodes.length > 0) {
            return true;
        }
        nodes = environment.getRoot().getChildrenOfType(101006);
        return nodes != null && nodes.length == 1 && "metadata".equals(nodes[0].getPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName()));
    }
}

