/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.unwinding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberSetReference;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReplaceV5QueryWithUnwoundV5Query
extends Transformation {
    public ReplaceV5QueryWithUnwoundV5Query() {
        this.mName = "ReplaceV5QueryWithUnwoundV5Query";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101006};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode v5Unwind = node.getParent();
        if (this.needToReplaceV5Query((V5Query)node, environment)) {
            V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
            V5Query unwoundQuery = (V5Query)node;
            V5Query originalQuery = querySet.getV5Query(unwoundQuery.getV5QueryName());
            this.reBindReferences(querySet, originalQuery, unwoundQuery);
            this.reBindDataItemsInMemberSetReference(unwoundQuery);
            querySet.addQueryInQueryMap(unwoundQuery.getV5QueryName(), unwoundQuery);
            originalQuery.detach();
            originalQuery.removeFromIndex();
            node.move(querySet);
            node.setPropertyValue("unwound", Boolean.TRUE);
        }
        v5Unwind.detach();
        v5Unwind.removeFromIndex();
    }

    private boolean needToReplaceV5Query(V5Query query, PlanningEnvironment environment) {
        if (Boolean.TRUE.equals((Boolean)query.getPropertyValue("isROLAP"))) {
            return true;
        }
        if (!query.isDMR()) {
            return false;
        }
        if (query.getPropertyValue("containsRelationalExprUnwoundToDMR") != null) {
            return true;
        }
        if (Boolean.TRUE.equals(query.getBooleanPropertyValue("forceDMRtoRQP"))) {
            Set<String> queryRefs = query.getSubQueryNames(environment);
            if (queryRefs.isEmpty()) {
                return true;
            }
            if (queryRefs.size() > 1) {
                return false;
            }
            String refQueryName = (String)queryRefs.toArray()[0];
            V5QuerySet querySet = V5QuerySet.getRootQuerySet(environment, query);
            V5Query refQuery = querySet.getV5Query(refQueryName);
            if (refQuery.getPropertyValue("isDMR") == null) {
                IXQEQueryNode[] v5UnwoundNodes;
                for (IXQEQueryNode unwindNode : v5UnwoundNodes = querySet.getDescendantsOfType(101073, false)) {
                    V5Query unwoundQuery = (V5Query)unwindNode.getChild(0);
                    if (!refQueryName.equals(unwoundQuery.getV5QueryName())) continue;
                    refQuery = unwoundQuery;
                    break;
                }
            }
            return !refQuery.getForcedDMRToRelational();
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return true;
    }

    protected void reBindReferences(V5QuerySet querySet, V5Query originalQuery, V5Query newQuery) {
        IXQEQueryNode[] queries;
        V5Selection originalSelection = originalQuery.getV5Selection();
        V5Selection newSelection = newQuery.getV5Selection();
        int[] types = new int[]{201060, 201097};
        for (IXQEQueryNode query : queries = querySet.getDescendantsOfType(101006, false)) {
            IXQEQueryNode[] refs;
            if (query == newQuery) continue;
            for (IXQEQueryNode ref : refs = query.getDescendantsOfTypes(types, false)) {
                String itemName;
                V5DataItem item = null;
                if (ref.getType() == 201060) {
                    V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)ref;
                    if (dataItemRef.isQueryRefItem()) {
                        item = dataItemRef.getRefDataItem();
                    }
                } else {
                    item = ((V5BoundQueryItemReference)ref).getRefDataItem();
                }
                if (item == null || item != originalSelection.getDataItemByRefName(itemName = item.getNameProperty()) || newSelection.getDataItemByRefName(itemName) == null) continue;
                if (ref.getType() == 201060) {
                    ((V5BoundDataItemReference)ref).setRefDataItem(newSelection.getDataItemByRefName(itemName));
                    continue;
                }
                ((V5BoundQueryItemReference)ref).setRefDataItem(newSelection.getDataItemByRefName(itemName));
            }
        }
    }

    protected void reBindDataItemsInMemberSetReference(V5Query newQuery) {
        IXQEQueryNode[] membersets;
        V5Selection selection = newQuery.getV5Selection();
        for (IXQEQueryNode memberSet : membersets = newQuery.getDescendantsOfType(201138, false)) {
            V5BoundMemberSetReference memberSetRef = (V5BoundMemberSetReference)memberSet;
            HashMap<V5DataItem, HashSet<String>> mp = memberSetRef.getRefDataItemsToValueSets();
            if (mp == null || mp.isEmpty()) continue;
            HashMap<V5DataItem, HashSet<String>> newMap = new HashMap<V5DataItem, HashSet<String>>();
            for (Map.Entry<V5DataItem, HashSet<String>> e : mp.entrySet()) {
                V5DataItem aItem = e.getKey();
                String name = aItem.getNameProperty();
                V5DataItem newItem = selection.getDataItemByRefName(name);
                newMap.put(newItem, e.getValue());
            }
            memberSetRef.setRefDataItemsToValueSets(newMap);
        }
    }
}

