/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.unwinding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.transformation.v5.unwinding.SubstituteROLAPCalculatedMemberWithModelExp;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;

public class SubstituteROLAPCalculatedMeasureWithModelExp
extends SubstituteROLAPCalculatedMemberWithModelExp {
    public SubstituteROLAPCalculatedMeasureWithModelExp() {
        this.mName = "SubstituteROLAPCalculatedMeasureWithModelExp";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201116};
    }

    @Override
    protected void applyImplementation(IXQEQueryNode node, PlanningEnvironment environment, LoopDetectionChain ldc) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        IMeasure mfwMeasure = (IMeasure)v5BoundID.getMetadata();
        String v5MUN = mfwMeasure.getV5UniqueName();
        String name = mfwMeasure.getName();
        String v5Expression = v5BoundID.getExpression();
        IHierarchy hierarchy = mfwMeasure.getHierarchy();
        Integer solveOrder = mfwMeasure.getSolveOrder();
        if (solveOrder == null) {
            solveOrder = SolveOrderUtil.getMemberSolveOrder();
        }
        String formatString = mfwMeasure.getFormat();
        String format = null;
        if (formatString != null) {
            FormatId formatID = FormatService.getInstance().registerV5Format(formatString, null);
            format = String.valueOf(formatID.getInternalValue());
        }
        this.startUnwind(node, v5Expression, name, v5MUN, environment, hierarchy, null, solveOrder, ldc, format, Boolean.FALSE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!ROLAPUtilities.isQueryROLAP(node, environment)) {
            this.traceNodeCondition(false, "The node does not represent a ROLAP calculated measure.", xqeTrace);
            return false;
        }
        return this.checkIsMeasure(node, xqeTrace);
    }

    @Override
    protected String getROLAPCalculatedMeasureAggregateRule(String calcUniqueName, PlanningEnvironment environment) {
        IMember[] measures;
        for (IMember member : measures = this.getMeasures(calcUniqueName, environment)) {
            IROLAPMeasure measure = (IROLAPMeasure)member;
            String v5UniqueName = measure.getV5UniqueName();
            if (!v5UniqueName.equals(calcUniqueName)) continue;
            String aggregation = measure.getAggregateRule();
            if (aggregation != null && aggregation.equals("sum")) {
                return "total";
            }
            return aggregation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMember[] getMeasures(String calcUniqueName, PlanningEnvironment environment) {
        block6: {
            ROLAPCube cube;
            ICube theCube;
            ROLAPCubeReservation res = null;
            String cubeName = environment.getCubeName();
            if (cubeName == null && (theCube = this.getCube(calcUniqueName, environment.getMetadataConnection().getCubes())) != null) {
                cubeName = theCube.getName();
            }
            if ((cube = ROLAPCubeManager.getInstance().getCube(cubeName)) == null) break block6;
            try {
                res = cube.reserve();
                IMember[] iMemberArray = cube.getMeasures();
                cube.unreserve(res);
                return iMemberArray;
            }
            catch (Throwable throwable) {
                try {
                    cube.unreserve(res);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private ICube getCube(String calcUniqueName, ICube[] cubes) {
        if (cubes.length == 1) {
            return cubes[0];
        }
        try {
            String refCubeName = UniqueNameParser.parserFirstIdentifier(calcUniqueName);
            for (ICube cube : cubes) {
                if (!cube.getModelDataSource().isROLAP() || !refCubeName.equals(cube.getName())) continue;
                return cube;
            }
        }
        catch (UniqueNameParserException uniqueNameParserException) {
            // empty catch block
        }
        return cubes[0];
    }
}

