/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.unwinding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculatedMember;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.unwinding.ExpandChildrenROLAPCalculatedMember;
import com.cognos.xqe.transformation.v5.unwinding.SubstituteDMRMeasureWithModelExp;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.List;
import java.util.Map;

public class SubstituteROLAPCalculatedMemberWithModelExp
extends SubstituteDMRMeasureWithModelExp {
    protected static final String PROP_STRING_NAME = "calcMemberName";
    protected static final String PROP_STRING_EXPRESSION = "expression";
    protected static final String PROP_STRING_SOLVE_ORDER = "solveOrder";
    protected static final String PROP_OBJ_LEVEL = "level";
    protected static final String PROP_STR_V5MUN = "v5MUN";
    public static final String CREATEDFROMROLAPCALCULATEDMEMBER = "createdFromROLAPCalcMember";
    public static final String ORIGINALV5MUN = "originalV5MUN";

    public SubstituteROLAPCalculatedMemberWithModelExp() {
        this.mName = "SubstituteROLAPCalculatedMemberWithModelExp";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201117};
    }

    @Override
    protected void applyImplementation(IXQEQueryNode node, PlanningEnvironment environment, LoopDetectionChain ldc) {
        String nativeName;
        RequestEnvironment reqEnv;
        Map<String, V5MemberUniqueName> munList;
        V5BoundMemberUniqueName uniqueName = (V5BoundMemberUniqueName)node;
        ILevel level = uniqueName.getLevel();
        IHierarchy hierarchy = level.getHierarchy();
        List<IMember> calcMembers = hierarchy.getCalculatedMembers();
        ICalculatedMember mfwCalcMember = null;
        for (IMember calcMember : calcMembers) {
            String externalName = (String)uniqueName.getPropertyValue("externalMun");
            if (!calcMember.getUniqueName().equals(externalName)) continue;
            mfwCalcMember = (ICalculatedMember)calcMember;
            break;
        }
        if ((munList = (reqEnv = (RequestEnvironment)environment.getRequestEnvironment()).getV5Muns()).containsKey(nativeName = uniqueName.getNativeName())) {
            munList.remove(nativeName);
        }
        Integer solveOrder = null;
        if (mfwCalcMember.getSolverOrder() >= 0) {
            solveOrder = mfwCalcMember.getSolverOrder();
        }
        if (mfwCalcMember.isExtendedCalculatedMember() && solveOrder == null) {
            solveOrder = -1;
        }
        String v5MUN = UniqueNameGenerator.createMemberV5UniqueName(level, mfwCalcMember.getUniqueName());
        String name = mfwCalcMember.getName();
        String v5Expression = mfwCalcMember.getV5Expression();
        this.startUnwind(node, v5Expression, name, v5MUN, environment, level.getHierarchy(), level, solveOrder, ldc, null, mfwCalcMember.isExtendedCalculatedMember());
    }

    protected void startUnwind(IXQEQueryNode node, String v5Expression, String name, String v5MUN, PlanningEnvironment environment, IHierarchy hierarchy, ILevel level, Integer solveOrder, LoopDetectionChain ldc, String format, Boolean extendedCalculatedMember) {
        IMetadata metadata;
        IXQEQueryNode[] allV5NodesToCheck;
        if (!ldc.push(v5MUN)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, v5MUN, ldc.serialize());
        }
        IXQEQueryNode tree = RQPUtilities.createV5ValueExpression(v5Expression, environment, null);
        if (!extendedCalculatedMember.booleanValue()) {
            node.exchange(tree);
        } else {
            XQENodeFactory factory = environment.getNodeFactory();
            IXQEQueryNode query = node.getAncestorOfType(101006);
            IXQEQueryNode[] v5ROLAPRelativeTimeMember = (IXQEQueryNode[])factory.createNode(101078);
            query.addChild((IXQEQueryNode)v5ROLAPRelativeTimeMember);
            v5ROLAPRelativeTimeMember.setPropertyValue("externalMun", node.getPropertyValue("externalMun"));
            v5ROLAPRelativeTimeMember.addChild(tree);
        }
        tree = this.bindAndUnwindExpression(tree, environment, ldc);
        boolean containInAccessibleRefrences = false;
        for (IXQEQueryNode oneV5Node : allV5NodesToCheck = tree.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)oneV5Node;
            metadata = identifier.getMetadata();
            if (!metadata.isMFW() || metadata.isAccessible()) continue;
            containInAccessibleRefrences = true;
            break;
        }
        if (!containInAccessibleRefrences) {
            for (IXQEQueryNode oneV5Node : allV5NodesToCheck = tree.getDescendantsOfType(201117, true)) {
                V5BoundMemberUniqueName mun = (V5BoundMemberUniqueName)oneV5Node;
                metadata = mun.getMetadata();
                if (!metadata.isMFW() || metadata.isAccessible()) continue;
                containInAccessibleRefrences = true;
                break;
            }
        }
        ldc.pop();
        if (containInAccessibleRefrences) {
            XQENodeFactory factory = environment.getNodeFactory();
            tree.exchange(factory.createNode(201023));
        }
        this.createV5MemberFunction(tree, name, v5MUN, environment, hierarchy, level, solveOrder, format);
    }

    protected void createV5MemberFunction(IXQEQueryNode node, String name, String v5MUN, PlanningEnvironment environment, IHierarchy hierarchy, ILevel level, Integer solveOrder, String format) {
        String aggregateRule;
        V5MemberFunction memberFunction = V5ToCogMDXUtilities.createV5MemberExpression(node, environment, v5MUN, name, null);
        XQENodeFactory factory = environment.getNodeFactory();
        V5BoundModelIdentifier hierarchyNode = (V5BoundModelIdentifier)factory.createNode(201116);
        hierarchyNode.setMetadata(hierarchy);
        hierarchyNode.setIdentifier(hierarchy.getV5UniqueName());
        memberFunction.addChild(hierarchyNode);
        memberFunction.setPropertyValue(CREATEDFROMROLAPCALCULATEDMEMBER, Boolean.TRUE);
        memberFunction.setPropertyValue(ORIGINALV5MUN, v5MUN);
        if (format != null) {
            memberFunction.setPropertyValue("format", format);
        }
        if (level != null) {
            memberFunction.setPropertyValue(PROP_OBJ_LEVEL, level);
        }
        if (solveOrder != null) {
            memberFunction.setSolveOrder(solveOrder);
            memberFunction.setAbsoluteSolveOrder(Boolean.TRUE);
        }
        if (environment.getCubeName() == null) {
            String cubeName = hierarchy.getDimension().getCube().getName();
            environment.setCubeName(cubeName);
        }
        if ((aggregateRule = this.getROLAPCalculatedMeasureAggregateRule(v5MUN, environment)) != null) {
            V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(aggregateRule);
            memberFunction.setRollupAggregate(rollupAggregate);
        }
    }

    protected String getROLAPCalculatedMeasureAggregateRule(String calcUniqueName, PlanningEnvironment environment) {
        return null;
    }

    public ROLAPCalculatedMember getCalculatedMemberFromRolapCube(ROLAPCube rolapCube, String externalName, IHierarchy hierarchy) {
        ROLAPCalculatedMember calcMember = null;
        if (rolapCube != null) {
            IROLAPHierarchy rolapHier = null;
            String hierUniqueName = hierarchy.getUniqueName();
            List<IHierarchy> hiers = rolapCube.getHierarchies();
            for (IHierarchy hier : hiers) {
                if (!hier.getUniqueName().equalsIgnoreCase(hierUniqueName)) continue;
                rolapHier = (IROLAPHierarchy)hier;
                break;
            }
            if (rolapHier != null) {
                for (ROLAPCalculatedMember hierCalcMember : rolapHier.getROLAPCalculatedMembers(rolapCube.getName())) {
                    if (!hierCalcMember.getUniqueName().equals(externalName)) continue;
                    calcMember = hierCalcMember;
                    break;
                }
            }
        }
        return calcMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent;
        XQETrace xqeTrace = environment.getTrace();
        if (ExpandChildrenROLAPCalculatedMember.isMetadataQuery(environment)) {
            this.traceNodeCondition(false, "Do not apply the transformation for metadata queries", xqeTrace);
            return false;
        }
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        if (v5Query.getPropertyValue("isROLAP") == null) {
            this.traceNodeCondition(false, "The node does not represent a ROLAP calculated member.", xqeTrace);
            return false;
        }
        for (parent = node.getParent(); parent != null && !parent.isOfCategory(201120); parent = parent.getParent()) {
        }
        if (parent != null && parent.getType() == 201053) {
            this.traceNodeCondition(false, "Do not apply the transformation for members used in a children function", xqeTrace);
            return false;
        }
        V5BoundMemberUniqueName uniqueName = (V5BoundMemberUniqueName)node;
        ILevel level = uniqueName.getLevel();
        IHierarchy hierarchy = level.getHierarchy();
        List<IMember> calcMembers = hierarchy.getCalculatedMembers();
        String cubeName = ROLAPContext.getCMDataSourceName(environment);
        if (cubeName == null) {
            cubeName = hierarchy.getDimension().getCube().getName();
        }
        ROLAPCube rolapCube = ROLAPCubeManager.getInstance().getCube(cubeName);
        for (IMember calcMember : calcMembers) {
            ROLAPCubeReservation reservation;
            String externalName = (String)uniqueName.getPropertyValue("externalMun");
            if (!calcMember.getUniqueName().equals(externalName) || rolapCube == null || (reservation = rolapCube.reserve()) == null) continue;
            try {
                boolean status;
                ROLAPCalculatedMember hierCalcMember = this.getCalculatedMemberFromRolapCube(rolapCube, externalName, hierarchy);
                boolean bl = status = !calcMember.isExtendedCalculatedMember();
                if (!status && hierCalcMember != null) {
                    status = hierCalcMember.isRolapCalculatedMemberVisible(rolapCube, hierarchy);
                    if (status) {
                        status = hierCalcMember.isExtendedCalculatedMemberWithFormula();
                    }
                    if (status) {
                        IXQEQueryNode[] children;
                        IXQEQueryNode query = node.getAncestorOfType(101006);
                        for (IXQEQueryNode child : children = query.getChildrenOfType(101078)) {
                            if (!externalName.equals(child.getPropertyValue("externalMun"))) continue;
                            status = false;
                        }
                    }
                } else if (hierCalcMember != null) {
                    status = hierCalcMember.isRolapCalculatedMemberVisible(rolapCube, hierarchy);
                }
                if (!status) continue;
                this.traceNodeCondition(true, "The bound V5 member unique name is a ROLAP calculated member.", xqeTrace);
                boolean bl2 = true;
                return bl2;
            }
            finally {
                rolapCube.unreserve(reservation);
            }
        }
        this.traceNodeCondition(false, "The bound V5 member unique name is not a ROLAP calculated member.", xqeTrace);
        return false;
    }
}

