/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.unwinding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPJoinInfo;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.util.V5ParameterUtil;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.binding.AddEmbeddedFiltersOfDimensionToV5Query;
import com.cognos.xqe.transformation.v5.binding.BindV5MultiPartIdentifierToModel;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.symboltable.SymbolTableForQS;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class UnwindV5BoundModelId
extends Transformation {
    public static final String PROP_QUERY_HAS_RELATIONAL_EXPR_UNWOUND_TO_DMR = "containsRelationalExprUnwoundToDMR";
    public static final String STR_DOT = ".";

    public UnwindV5BoundModelId(int[] passNumbers) {
        this.mName = "UnwindV5BoundModelId";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201116};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        LoopDetectionChain ldc = new LoopDetectionChain();
        this.applyImplementation(node, environment, ldc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyImplementation(IXQEQueryNode node, PlanningEnvironment environment, LoopDetectionChain ldc) {
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        String idToPush = v5BoundID.getIdentifier();
        String[] parts = UniqueNameParser.parseNoThrow(idToPush);
        if (parts != null && parts.length <= 1 && environment.getMetadataConnection() != null && "module".equals(environment.getMetadataConnection().getModelType()) && v5BoundID.getMetadata().getObjectType() == MetadataType.QUERY_ITEM) {
            idToPush = ((IQueryItem)v5BoundID.getMetadata()).getQuerySubject().getUniqueName() + STR_DOT + v5BoundID.getIdentifier();
        }
        if (!ldc.push(idToPush)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, "Model Expression", ldc.serialize());
        }
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        try (MetadataConnectionContext mc = null;){
            if (v5Query != null) {
                mc = environment.pushMetadataConnectionContext(v5Query);
            }
            if (this.canBeUnwound(v5BoundID, environment)) {
                V5Parameter param = V5ParameterUtil.getSiblingV5ParameterOfModelIdentifier(v5BoundID);
                if (param != null && param.getModelIdentifier() == null) {
                    param.setModelIdentifier(v5BoundID.getIdentifier());
                }
                IXQEQueryNode v5BoundIDExpr = v5BoundID.getV5ValueExpression(environment);
                MoserQuerySubject miniQS = RQPUtilities.getMinimizedQS(environment, v5BoundID);
                if (miniQS != null) {
                    v5BoundIDExpr = RQPUtilities.createQueryItemInMiniQS(environment, v5BoundIDExpr, v5BoundID, miniQS);
                }
                DMRUtilities.isDMRExpressionHasSummaryFunction(environment, v5BoundID, v5BoundIDExpr);
                IQuerySubject qs = v5BoundID.getQuerySubject();
                if (v5Query != null && v5Query.getPropertyValue("customValuePushDown") == null && !this.isStandaloneCalcOrFilter(v5BoundID) && !UnwindV5BoundModelId.filtersAlreadyAddedToV5Query(v5Query, qs)) {
                    AddEmbeddedFiltersOfDimensionToV5Query.createV5DetailFiltersForEmbeddedOrPreview(qs, qs.getFilters(), v5Query, node, environment);
                    if (node.getGovernors().getDesignMode().booleanValue()) {
                        AddEmbeddedFiltersOfDimensionToV5Query.createV5DetailFiltersForEmbeddedOrPreview(qs, qs.getPreviewFilters(), v5Query, node, environment);
                    }
                    AddEmbeddedFiltersOfDimensionToV5Query.createV5DetailFilterForSecurityFilters(qs, qs.getSecurityFilters(), v5Query, node, environment);
                }
                MetadataContext context = null;
                if (qs != null && (context = (MetadataContext)qs.getProperty("metadataContext")) != null) {
                    context.setMetadataContextOnV5MultiPartIdentifier(v5BoundIDExpr);
                }
                node.exchange(v5BoundIDExpr);
                try {
                    if (qs != null) {
                        IMetadata mdObj = v5BoundID.getMetadata();
                        environment.pushSymbolTable(new SymbolTableForQS(qs, mdObj, false));
                        environment.getSymbolTableStack().pushSelf(mdObj);
                    }
                    this.bindAndUnwindExpression(v5BoundIDExpr, environment, ldc);
                }
                finally {
                    if (qs != null) {
                        environment.popSymbolTable();
                        environment.getSymbolTableStack().popSelf();
                    }
                }
            } else {
                IXQEQueryNode parent;
                v5BoundID.setIsUnwound();
                if (v5BoundID.getQuerySubject() == null && ldc.numberVisitedObjects() > 1 && v5Query != null && (parent = v5Query.getParent()) != null && parent.getType() == 101073) {
                    v5Query.setPropertyValue(PROP_QUERY_HAS_RELATIONAL_EXPR_UNWOUND_TO_DMR, true);
                }
            }
            ldc.pop();
        }
    }

    public static boolean filtersAlreadyAddedToV5Query(V5Query v5Query, IMetadata metadata) {
        IXQEQueryNode[] v5DetailFilters;
        for (IXQEQueryNode df : v5DetailFilters = v5Query.getV5DetailFilters()) {
            V5DetailFilter v5DetailFilter = (V5DetailFilter)df;
            if (v5DetailFilter.getFilterOwner() == null || metadata.compareTo(v5DetailFilter.getFilterOwner()) != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canBeUnwound(V5BoundModelIdentifier v5BoundID, PlanningEnvironment environment) {
        if (this.isStandaloneCalcOrFilter(v5BoundID)) {
            return true;
        }
        IQuerySubject querySubject = v5BoundID.getQuerySubject();
        if (querySubject == null) {
            return false;
        }
        MoserQuerySubject miniQS = RQPUtilities.getMinimizedQS(environment, v5BoundID);
        if (miniQS != null) {
            return true;
        }
        V5Query v5Query = (V5Query)v5BoundID.getAncestorOfType(101006);
        if (UnwindV5BoundModelId.querySubjectInvolvedInPreferredJoins(v5Query, querySubject)) {
            return false;
        }
        if (SummaryQuerySubjectUtilities.isDynamicSQS(querySubject)) {
            SummaryQuerySubjectUtilities.registerDynamicSQS(v5Query, querySubject);
            return false;
        }
        if (SummaryQuerySubjectUtilities.isSummaryQuerySubject(querySubject)) {
            return false;
        }
        if (!querySubject.getGeneratedSQLOption().equals("minimized")) {
            return false;
        }
        if (!querySubject.getDefinitionType().equals("modelQuery")) {
            return false;
        }
        MetadataConnectionContext mc = null;
        if (querySubject.getInvolvedInJoins() == null) {
            if (v5Query != null) {
                try {
                    mc = environment.pushMetadataConnectionContext(v5Query);
                    RQPJoinInfo joinInfo = (RQPJoinInfo)v5Query.getFirstChildByType(801046);
                    if (joinInfo == null) {
                        joinInfo = (RQPJoinInfo)environment.getNodeFactory().createNode(801046);
                        v5Query.addChild(joinInfo);
                        joinInfo.createRepositoryInfo(environment.getMetadataConnection());
                    } else if (!joinInfo.hasRepositoryInfo()) {
                        joinInfo.createRepositoryInfo(environment.getMetadataConnection());
                    }
                    RQPUtilities.setQuerySubjectInvolvedInJoins(joinInfo, querySubject);
                }
                finally {
                    if (mc != null) {
                        mc.close();
                    }
                }
            } else {
                return false;
            }
        }
        return querySubject.getInvolvedInJoins() == false;
    }

    public static boolean querySubjectInvolvedInPreferredJoins(V5Query v5Query, IQuerySubject querySubject) {
        if (v5Query == null) {
            return false;
        }
        List<IMetadata> joins = v5Query.getPreferredJoins();
        if (joins == null || joins.isEmpty()) {
            return false;
        }
        IShortcut sc = null;
        if (querySubject instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)((Object)querySubject)).isAccessedViaShortcut()) {
            sc = ((IAccessedViaShortcut)((Object)querySubject)).getShortcut();
        }
        for (IMetadata j : joins) {
            if (!(j instanceof IRelationship)) continue;
            IRelationship join = (IRelationship)j;
            if (join.getLeftRefObject().equals(querySubject) || join.getRightRefObject().equals(querySubject)) {
                return true;
            }
            if (sc == null || !sc.equals(join.getLeftRefObject()) && !sc.equals(join.getRightRefObject())) continue;
            return true;
        }
        return false;
    }

    private boolean isStandaloneCalcOrFilter(V5BoundModelIdentifier v5BoundID) {
        IMetadata metadata = v5BoundID.getMetadata();
        return metadata instanceof ICalculation && !((ICalculation)metadata).getCalcType().equals("namedSet") || metadata instanceof IFilter;
    }

    private void bindAndUnwindExpression(IXQEQueryNode expression, PlanningEnvironment environment, LoopDetectionChain ldc) {
        IXQEQueryNode[] allV5BoundNodes;
        IXQEQueryNode[] allV5NodesToBind;
        IXQEQueryNode parent = expression.getParent();
        int positionOfChild = parent.getPositionOfChild(expression);
        int[] pn = new int[]{1};
        BindV5MultiPartIdentifierToModel transformation = new BindV5MultiPartIdentifierToModel(pn);
        for (IXQEQueryNode v5Node : allV5NodesToBind = expression.getDescendantsOfType(201030, true)) {
            if (!((Transformation)transformation).passesQueryCondition(v5Node, environment)) continue;
            ((Transformation)transformation).apply(v5Node, environment);
        }
        for (IXQEQueryNode v5Node : allV5BoundNodes = parent.getChild(positionOfChild).getDescendantsOfType(201116, true)) {
            if (!this.passesNodeCondition(v5Node, environment)) continue;
            this.applyImplementation(v5Node, environment, ldc);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)node;
        if (v5BoundID.isUnwound()) {
            this.traceNodeCondition(false, "The identifier is already unwound.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "An attempt to unwind the identifier will be made.", xqeTrace);
        return true;
    }
}

