/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.utils.V5NodeFormatResolver;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5FormatFunction;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.UnknownType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.symboltable.SymbolTableForQS;

public class V5FormatResolver {
    private FormatService formatService;
    private static final String EMPTY_FORMAT = "<format>&amp;lt;formatGroup&amp;gt;&amp;lt;/formatGroup&amp;gt;</format>";
    private static final String STR_DOT = ".";
    private static final String MODEL_STRING = "Model Expression";
    PlanningEnvironment env;
    final FormatId[][] addTable = new FormatId[][]{{FormatId.DATE_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID, FormatId.DATETIME_FORMAT_FID}, {FormatId.INTERVAL_FORMAT_FID, FormatId.DATE_FORMAT_FID, FormatId.DATETIME_FORMAT_FID}, {FormatId.DATETIME_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID, FormatId.DATETIME_FORMAT_FID}, {FormatId.INTERVAL_FORMAT_FID, FormatId.DATETIME_FORMAT_FID, FormatId.DATETIME_FORMAT_FID}, {FormatId.TIME_FORMAT_FID, FormatId.DATE_FORMAT_FID, FormatId.DATETIME_FORMAT_FID}, {FormatId.DATE_FORMAT_FID, FormatId.TIME_FORMAT_FID, FormatId.DATETIME_FORMAT_FID}, {FormatId.TIMETZ_FORMAT_FID, FormatId.DATE_FORMAT_FID, FormatId.DATETIMETZ_FORMAT_FID}, {FormatId.DATE_FORMAT_FID, FormatId.TIMETZ_FORMAT_FID, FormatId.DATETIMETZ_FORMAT_FID}, {FormatId.DATETIMETZ_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID, FormatId.DATETIMETZ_FORMAT_FID}, {FormatId.INTERVAL_FORMAT_FID, FormatId.DATETIMETZ_FORMAT_FID, FormatId.DATETIMETZ_FORMAT_FID}, {FormatId.TIMETZ_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID, FormatId.TIMETZ_FORMAT_FID}, {FormatId.INTERVAL_FORMAT_FID, FormatId.TIMETZ_FORMAT_FID, FormatId.TIMETZ_FORMAT_FID}};
    final FormatId[][] subtractTable = new FormatId[][]{{FormatId.DATE_FORMAT_FID, FormatId.DATE_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATETIME_FORMAT_FID, FormatId.DATETIME_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATETIME_FORMAT_FID, FormatId.DATE_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATE_FORMAT_FID, FormatId.DATETIME_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATE_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID, FormatId.DATETIME_FORMAT_FID}, {FormatId.DATETIME_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID, FormatId.DATETIME_FORMAT_FID}, {FormatId.TIMETZ_FORMAT_FID, FormatId.TIMETZ_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATETIMETZ_FORMAT_FID, FormatId.DATETIMETZ_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.TIMETZ_FORMAT_FID, FormatId.TIME_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.TIME_FORMAT_FID, FormatId.TIMETZ_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATETIMETZ_FORMAT_FID, FormatId.DATE_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATE_FORMAT_FID, FormatId.DATETIMETZ_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATETIMETZ_FORMAT_FID, FormatId.DATETIME_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.DATETIME_FORMAT_FID, FormatId.DATETIMETZ_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}, {FormatId.INVALID_FORMAT_FID, FormatId.DATETIME_FORMAT_FID, FormatId.INTERVAL_FORMAT_FID}};
    String idName = null;
    private LoopDetectionChain ldc = null;

    public V5FormatResolver(PlanningEnvironment environment) {
        this.formatService = FormatService.getInstance();
        this.env = environment;
        this.ldc = new LoopDetectionChain();
    }

    public String getFormat(IXQEQueryNode expr) {
        return this.getFormat(expr, true);
    }

    public String getFormat(IXQEQueryNode expr, boolean returnEmptyForDefaultDatatypeFormat) {
        String formatStr = (String)expr.getPropertyValue("calculationFormat");
        if (formatStr != null) {
            return formatStr;
        }
        formatStr = "";
        switch (expr.getType()) {
            case 201069: {
                V5FormatFunction formatFunction = (V5FormatFunction)expr;
                formatStr = this.resolveFormatFromFDS(formatFunction);
                break;
            }
            case 201051: {
                V5CastTarget target = (V5CastTarget)expr.getChild(1);
                formatStr = this.resolveFormatFromDataType(target.getDataType());
                break;
            }
            case 201014: {
                FormatId formatId = null;
                String leftString = this.getFormat(expr.getChild(0), false);
                FormatId leftId = V5FormatResolver.getFormatId(leftString);
                FormatId rightId = null;
                String rightString = null;
                int subType = ((V5ValueExpression)expr).getSubType();
                if (subType == 6 || subType == 5) {
                    formatId = leftId;
                    formatStr = leftString;
                    break;
                }
                rightString = this.getFormat(expr.getChild(1), false);
                rightId = V5FormatResolver.getFormatId(rightString);
                String leftTypeName = this.formatService.getFormatTypeName(leftId);
                String rightTypeName = this.formatService.getFormatTypeName(rightId);
                switch (subType) {
                    case 1: 
                    case 2: {
                        formatId = this.resolveFromRules(subType, leftId, rightId);
                        formatStr = this.formatService.retrieveFormatString(formatId);
                        if (!formatId.equals(FormatId.INVALID_FORMAT_FID)) break;
                        if (leftId.equals(FormatId.INVALID_FORMAT_FID)) {
                            formatId = rightId;
                            formatStr = rightString;
                            break;
                        }
                        formatId = leftId;
                        formatStr = leftString;
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (subType == 3 && leftTypeName.equals("currencyFormat") && leftString.equalsIgnoreCase(rightString)) {
                            formatId = FormatId.NUMBER_FORMAT_FID;
                            formatStr = this.formatService.retrieveFormatString(formatId);
                            break;
                        }
                        if (leftTypeName.equals("percentFormat")) {
                            formatId = rightId;
                            formatStr = rightString;
                            break;
                        }
                        if (rightTypeName.equals("percentFormat")) {
                            formatId = leftId;
                            formatStr = leftString;
                            break;
                        }
                        if (this.isIntegerFormat(leftId)) {
                            formatId = rightId;
                            formatStr = rightString;
                            break;
                        }
                        if (this.isIntegerFormat(rightId)) {
                            formatId = leftId;
                            formatStr = leftString;
                            break;
                        }
                        int leftDec = this.findDecimalSize(leftString);
                        int rightDec = this.findDecimalSize(rightString);
                        if (leftDec == 0) {
                            formatId = rightId;
                            formatStr = rightString;
                            break;
                        }
                        if (rightDec == 0) {
                            formatId = leftId;
                            formatStr = leftString;
                            break;
                        }
                        if (this.isNumberFormat(leftId)) {
                            formatId = rightId;
                            formatStr = rightString;
                            break;
                        }
                        if (this.isNumberFormat(rightId)) {
                            formatId = leftId;
                            formatStr = leftString;
                            break;
                        }
                        if (leftId.equals(FormatId.INVALID_FORMAT_FID)) {
                            formatId = rightId;
                            formatStr = rightString;
                            break;
                        }
                        formatId = leftId;
                        formatStr = leftString;
                        break;
                    }
                    case 0: {
                        String strFormat = "stringFormat";
                        if (leftTypeName.equals(strFormat) && rightTypeName.equals(strFormat)) {
                            formatId = leftId;
                            formatStr = leftString;
                            break;
                        }
                        formatId = FormatId.INVALID_FORMAT_FID;
                        formatStr = this.formatService.retrieveFormatString(formatId);
                        break;
                    }
                }
                if (!this.isIntegerFormat(formatId)) break;
                formatId = FormatId.NUMBER_FORMAT_FID;
                formatStr = this.formatService.retrieveFormatString(formatId);
                break;
            }
            case 201030: {
                V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)this.env.getNodeFactory().createNode(201116);
                String identifier = ((V5MultiPartIdentifier)expr).getIdentifier();
                newNode.setMetadata(this.env.bindMetadataReference(identifier));
                newNode.setIdentifier(identifier);
                formatStr = this.getFormat(newNode);
                newNode.detach();
                break;
            }
            case 201116: {
                formatStr = this.resolveFormatForBoundIdentifier((V5BoundModelIdentifier)expr, returnEmptyForDefaultDatatypeFormat);
                break;
            }
            case 201026: {
                if (((V5LiteralValue)expr).getDataType().isInteger()) {
                    formatStr = this.formatService.retrieveFormatString(FormatId.INTEGER_FORMAT_FID);
                    break;
                }
                formatStr = this.resolveFormatFromDataType(((V5LiteralValue)expr).getDataType());
                break;
            }
            case 201023: {
                break;
            }
            case 201060: 
            case 201097: {
                formatStr = this.getFormatFromItemReference((V5BoundMultiPartIdentifier)expr);
                break;
            }
            case 101003: {
                return this.getFormat(((V5DataItem)expr).getDetailExpression());
            }
            case 201017: {
                FormatId fId;
                formatStr = this.getFormat(expr.getChild(1), returnEmptyForDefaultDatatypeFormat);
                if ("".equals(formatStr)) {
                    formatStr = this.getFormat(expr.getChild(2), returnEmptyForDefaultDatatypeFormat);
                }
                if ("currencyFormat".equals(this.formatService.getFormatTypeName(fId = V5FormatResolver.getFormatId(formatStr)))) break;
                formatStr = "";
                break;
            }
            case 201018: {
                IXQEQueryNode when;
                IXQEQueryNode[] whens;
                IXQEQueryNode[] iXQEQueryNodeArray = whens = expr.getChildrenOfType(201019);
                int n = iXQEQueryNodeArray.length;
                for (int i = 0; i < n && "".equals(formatStr = this.getFormat((when = iXQEQueryNodeArray[i]).getChild(1), returnEmptyForDefaultDatatypeFormat)); ++i) {
                }
                if ("".equals(formatStr) && expr.getChild(expr.getNumberChildren() - 1).getType() != 201019) {
                    formatStr = this.getFormat(expr.getChild(expr.getNumberChildren() - 1), returnEmptyForDefaultDatatypeFormat);
                }
                if ("currencyFormat".equals(this.formatService.getFormatTypeName(V5FormatResolver.getFormatId(formatStr)))) break;
                formatStr = "";
                break;
            }
            default: {
                if (!(expr instanceof AbstractV5ValueExpression)) break;
                formatStr = this.resolveFormatFromFDS((AbstractV5ValueExpression)expr, returnEmptyForDefaultDatatypeFormat);
            }
        }
        if (formatStr == null) {
            formatStr = "";
        } else if (returnEmptyForDefaultDatatypeFormat) {
            IDataType dt;
            FormatId fId = this.formatService.registerV5Format(formatStr, null);
            if (expr.getType() == 101004) {
                expr = expr.getChild(0);
            }
            if ((dt = ((V5SimpleNode)expr).getDataType()) != null && dt != UnknownType.UNKNOWNTYPE) {
                if (dt.isInteger()) {
                    String defaultNumberFormatStr = this.formatService.retrieveFormatString(FormatId.NUMBER_FORMAT_FID);
                    String defaultIntegerFormatStr = this.formatService.retrieveFormatString(FormatId.INTEGER_FORMAT_FID);
                    if (defaultNumberFormatStr.equals(formatStr) || defaultIntegerFormatStr.equals(formatStr)) {
                        formatStr = "";
                        fId = FormatId.INVALID_FORMAT_FID;
                    }
                } else {
                    String defaultFormatStr;
                    FormatId defaultfId = this.resolveFormatIDFromDataType(dt);
                    if (defaultfId != null && defaultfId.equals(fId) && (defaultFormatStr = this.formatService.retrieveFormatString(defaultfId)).equals(formatStr)) {
                        formatStr = "";
                        fId = FormatId.INVALID_FORMAT_FID;
                    }
                }
            }
        }
        return formatStr;
    }

    private boolean isIntegerFormat(FormatId id) {
        return id == FormatId.INTEGER_FORMAT_FID;
    }

    private boolean isNumberFormat(FormatId id) {
        String formatTypeName = this.formatService.getFormatTypeName(id);
        return formatTypeName.equals("numberFormat");
    }

    private FormatId resolveFromRules(int oper, FormatId leftId, FormatId rightId) {
        FormatId[][] table = oper == 2 ? this.addTable : this.subtractTable;
        FormatId newLeftId = this.resolveTimeZoneFormatId(leftId);
        FormatId newRightId = this.resolveTimeZoneFormatId(rightId);
        if (newLeftId != leftId || newRightId != rightId) {
            for (FormatId[] entry : table) {
                if (!entry[0].equals(newLeftId) || !entry[1].equals(newRightId)) continue;
                return entry[2];
            }
        } else {
            String leftFormatTypeName = this.formatService.getFormatTypeName(leftId);
            String rightFormatTypeName = this.formatService.getFormatTypeName(rightId);
            for (FormatId[] entry : table) {
                if (!this.formatService.getFormatTypeName(entry[0]).equals(leftFormatTypeName) || !this.formatService.getFormatTypeName(entry[1]).equals(rightFormatTypeName)) continue;
                return entry[2];
            }
        }
        return FormatId.INVALID_FORMAT_FID;
    }

    public FormatId resolveTimeZoneFormatId(FormatId formatId) {
        if (this.formatService.retrieveFormatString(formatId).contains("showTimeZone=&quot;true&quot;")) {
            if (V5NodeFormatResolver.isDateTimeFormat(this.formatService.getFormatTypeName(formatId))) {
                return FormatId.DATETIMETZ_FORMAT_FID;
            }
            if (V5NodeFormatResolver.isTimeFormat(this.formatService.getFormatTypeName(formatId))) {
                return FormatId.TIMETZ_FORMAT_FID;
            }
        }
        return formatId;
    }

    public static FormatId getFormatId(String format) {
        return FormatService.getInstance().registerV5Format(format, null);
    }

    public static String getFormatIdString(FormatId formatId) {
        return FormatService.getInstance().getFormatStringId(formatId);
    }

    private String resolveFormatFromFDS(V5FormatFunction formatFunction) {
        String format = null;
        switch (formatFunction.getOption()) {
            case 0: {
                return formatFunction.getFormat();
            }
            case 1: {
                format = "PERCENTAGE_0";
                break;
            }
            case 2: {
                format = "PERCENTAGE_1";
                break;
            }
            case 3: {
                format = "PERCENTAGE_2";
                break;
            }
        }
        return IFunctionDefinition.Util.getFormatForSpec(format);
    }

    private String resolveFormatFromFDS(AbstractV5ValueExpression function, boolean returnEmptyForDefaultDatatypeFormat) {
        String formatStr = (String)function.getPropertyValue("fdsFormatString");
        if (formatStr == null) {
            formatStr = IFunctionDefinition.Util.getFunctionFormatTypeBasedOnVendorID(function.getNativeName(), this.env.getMetadataConnection());
        }
        int pos = 0;
        if (formatStr.equals("@1")) {
            pos = 1;
        } else if (formatStr.equals("@2")) {
            pos = 2;
        } else if (formatStr.equals("@3")) {
            pos = 3;
        } else if (formatStr.equals("@1==@2..n")) {
            if (function.getNumberChildren() == 0) {
                return "";
            }
            IXQEQueryNode[] args = function.getChildren();
            String argFormat = this.getFormat(args[0], returnEmptyForDefaultDatatypeFormat);
            for (int i = 1; i < args.length; ++i) {
                if (argFormat.equalsIgnoreCase(this.getFormat(args[i], returnEmptyForDefaultDatatypeFormat))) continue;
                return "";
            }
            return argFormat;
        }
        if (pos == 0) {
            return formatStr;
        }
        if (function.getNumberChildren() == 0) {
            return "";
        }
        IXQEQueryNode[] args = function.getChildren();
        return this.getFormat(args[pos - 1], false);
    }

    private String resolveFormatFromDataType(IDataType dataType) {
        FormatId formatId = null;
        if (dataType == null || dataType.getCCLTypeCode() == 0) {
            return "";
        }
        if (dataType.isExactNumeric()) {
            formatId = FormatId.NUMBER_FORMAT_FID;
        } else if (dataType.isApproximateNumeric()) {
            formatId = FormatId.NUMBER_FORMAT_FID;
        } else if (dataType.isDate()) {
            formatId = FormatId.DATE_FORMAT_FID;
        } else if (dataType.isTime()) {
            formatId = dataType.getTypeName() == "time with time zone" ? FormatId.TIMETZ_FORMAT_FID : FormatId.TIME_FORMAT_FID;
        } else if (dataType.isTimestamp()) {
            formatId = dataType.getTypeName() == "timestamp with time zone" ? FormatId.DATETIMETZ_FORMAT_FID : FormatId.DATETIME_FORMAT_FID;
        } else if (dataType.isInterval()) {
            formatId = FormatId.INTERVAL_FORMAT_FID;
        } else if (dataType.isTextType()) {
            formatId = FormatId.STRING_FORMAT_FID;
        }
        return this.formatService.retrieveFormatString(formatId);
    }

    private FormatId resolveFormatIDFromDataType(IDataType dataType) {
        FormatId formatId = null;
        if (dataType == null || dataType.getCCLTypeCode() == 0) {
            return formatId;
        }
        if (dataType.isInteger()) {
            formatId = FormatId.INTEGER_FORMAT_FID;
        } else if (dataType.isExactNumeric()) {
            formatId = FormatId.NUMBER_FORMAT_FID;
        } else if (dataType.isApproximateNumeric()) {
            formatId = FormatId.NUMBER_FORMAT_FID;
        } else if (dataType.isDate()) {
            formatId = FormatId.DATE_FORMAT_FID;
        } else if (dataType.isTime()) {
            formatId = FormatId.TIME_FORMAT_FID;
        } else if (dataType.getTypeName().equals("timestamp with time zone")) {
            formatId = FormatId.DATETIMETZ_FORMAT_FID;
        } else if (dataType.isTimestamp()) {
            formatId = FormatId.DATETIME_FORMAT_FID;
        } else if (dataType.isInterval()) {
            formatId = FormatId.INTERVAL_FORMAT_FID;
        } else if (dataType.isTextType()) {
            formatId = FormatId.STRING_FORMAT_FID;
        }
        return formatId;
    }

    public static String trimFormatTag(String format) {
        String fmt = "<format>";
        int start = format.indexOf(fmt);
        int end = format.indexOf("</format>");
        if (start != -1) {
            format = format.substring(start + fmt.length(), end);
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveFormatForBoundIdentifier(V5BoundModelIdentifier v5Id, boolean returnEmptyForDefaultDatatypeFormat) {
        String format = null;
        if (v5Id.isQueryItem()) {
            format = ((IQueryItem)v5Id.getMetadata()).getFormat();
            if (format == null || format.length() == 0 || format.equals(EMPTY_FORMAT)) {
                IQuerySubject qs = v5Id.getQuerySubject();
                if (qs == null || "mdQuery".equals(qs.getDefinitionType())) {
                    return "";
                }
                try {
                    IMetadata mdObj = v5Id.getMetadata();
                    this.env.pushSymbolTable(new SymbolTableForQS(qs, mdObj, false));
                    this.env.getSymbolTableStack().pushSelf(mdObj);
                    if (null == v5Id.getExpression()) {
                        if (returnEmptyForDefaultDatatypeFormat) {
                            String string = "";
                            return string;
                        }
                        String string = this.resolveFormatFromDataType(v5Id.getDataType());
                        return string;
                    }
                    String idToPush = v5Id.getIdentifier();
                    if (!v5Id.getIdentifier().contains(STR_DOT) && this.env.getMetadataConnection() != null && "module".equals(this.env.getMetadataConnection().getModelType()) && v5Id.getMetadata().getObjectType() == MetadataType.QUERY_ITEM) {
                        idToPush = ((IQueryItem)v5Id.getMetadata()).getQuerySubject().getUniqueName() + STR_DOT + v5Id.getIdentifier();
                    }
                    if (!this.ldc.push(mdObj, idToPush)) {
                        throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, MODEL_STRING, this.ldc.serialize());
                    }
                    format = this.resolveFormatFromExpression(v5Id);
                }
                finally {
                    this.ldc.pop();
                    this.env.popSymbolTable();
                    this.env.getSymbolTableStack().popSelf();
                }
                return format;
            }
            format = V5FormatResolver.trimFormatTag(format);
        } else if (v5Id.isCalculation()) {
            ICalculation calculation = (ICalculation)v5Id.getMetadata();
            if (!calculation.getCalcType().equals("namedSet") && ((format = v5Id.getFormat()) == null || format.length() == 0 || format.equals(EMPTY_FORMAT))) {
                if (!this.ldc.push(calculation, v5Id.getIdentifier())) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, MODEL_STRING, this.ldc.serialize());
                }
                format = this.resolveFormatFromExpression(v5Id);
                this.ldc.pop();
                return format;
            }
        } else if (v5Id.isMeasure()) {
            format = (String)v5Id.getMetadata().getProperty("format");
        }
        return format;
    }

    private String getFormatFromItemReference(V5BoundMultiPartIdentifier reference) {
        V5DataItem v5DataItem = null;
        if (reference.getType() == 201060) {
            v5DataItem = ((V5BoundDataItemReference)reference).getRefDataItem();
        } else if (reference.getType() == 201097) {
            v5DataItem = ((V5BoundQueryItemReference)reference).getRefDataItem();
        }
        if (v5DataItem == null) {
            return null;
        }
        IXQEQueryNode newQueryNode = v5DataItem.getDetailExpression();
        if (!newQueryNode.isOfCategory(201120)) {
            newQueryNode = newQueryNode.getChild(0);
        }
        if (!this.ldc.push(reference.getIdentifier(), reference.getIdentifier())) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, MODEL_STRING, this.ldc.serialize());
        }
        String format = this.getFormat(newQueryNode);
        this.ldc.pop();
        return format;
    }

    private String resolveFormatFromExpression(V5BoundModelIdentifier v5Id) {
        IXQEQueryNode v5Expr = RQPUtilities.createV5ValueExpressionMetadata(v5Id.getExpression(), this.env, v5Id, v5Id.getMetadata());
        if (v5Expr == null) {
            return null;
        }
        String format = this.getFormat(v5Expr);
        v5Expr.detach();
        return format;
    }

    private int findDecimalSize(String formatString) {
        String patternString;
        int end;
        String pattern1 = "decimalSize=";
        String pattern2 = "quot;";
        String pattern3 = "\"";
        int start = formatString.indexOf(pattern1);
        if (start < 0) {
            return -1;
        }
        int newStart = formatString.indexOf(pattern2, start + pattern1.length());
        if (newStart >= 0) {
            start = newStart;
            end = formatString.indexOf("&", start);
            patternString = pattern2;
        } else {
            start = formatString.indexOf(pattern3, start + pattern1.length());
            end = formatString.indexOf(pattern3, start + 1);
            patternString = pattern3;
        }
        String decString = formatString.substring(start + patternString.length(), end);
        if (decString.length() == 0) {
            return -1;
        }
        return Integer.parseInt(decString);
    }
}

