/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.util.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class V5MultiModelsUtil {
    public static boolean needToSwitchMetadataConnection(PlanningEnvironment environment, V5QuerySet querySet) {
        Set<Pair> models = V5MultiModelsUtil.getMetadataPathFromReferencedV5Query(querySet, environment);
        if (models.isEmpty()) {
            return false;
        }
        String topModelPath = querySet.getModelPath();
        if (models.size() > 1) {
            return true;
        }
        Pair modelPathAndType = models.iterator().next();
        return !topModelPath.equals(modelPathAndType.getFirst());
    }

    protected static Set<Pair> getMetadataPathFromReferencedV5Query(V5QuerySet querySet, PlanningEnvironment environment) {
        IXQEQueryNode[] qrds;
        HashSet<Pair> rt = new HashSet<Pair>();
        String topModelPath = querySet.getModelPath();
        for (IXQEQueryNode c : qrds = querySet.getChildrenOfType(101055)) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)c;
            String queryName = qrd.getRefQueryProperty();
            V5Query refQuery = querySet.getV5Query(queryName);
            if (refQuery == null) continue;
            TreeSet<String> leafQueryNames = new TreeSet<String>();
            V5MultiModelsUtil.getLeafQueryNames(refQuery, leafQueryNames, querySet, environment);
            for (String leafQName : leafQueryNames) {
                V5Query leafQuery = querySet.getV5Query(leafQName);
                if (leafQuery == null) continue;
                String orgmetadataPath = leafQuery.getMetadataPathInSource();
                if (orgmetadataPath == null) {
                    orgmetadataPath = topModelPath;
                }
                if (orgmetadataPath == null) continue;
                Pair p = new Pair();
                p.setFirst(orgmetadataPath);
                V5Source src = leafQuery.getV5Source();
                if (src != null) {
                    String modelType = src.getModelType();
                    if ("module".equals(modelType)) {
                        p.setSecond(modelType);
                    } else {
                        p.setSecond("package");
                    }
                }
                rt.add(p);
            }
        }
        return rt;
    }

    protected static void getLeafQueryNames(V5Query query, Set<String> leafQueryNames, V5QuerySet querySet, PlanningEnvironment environment) {
        Set<String> queryRefs = query.getSubQueryNames(environment);
        if (queryRefs.isEmpty()) {
            leafQueryNames.add(query.getV5QueryName());
            return;
        }
        for (String subQueryRef : queryRefs) {
            V5Query subQuery = querySet.getV5Query(subQueryRef);
            if (subQuery == null) continue;
            V5MultiModelsUtil.getLeafQueryNames(subQuery, leafQueryNames, querySet, environment);
        }
    }

    public static void switchMetadataConnection(PlanningEnvironment environment, V5QuerySet querySet) {
        Set<Pair> models = V5MultiModelsUtil.getMetadataPathFromReferencedV5Query(querySet, environment);
        if (models.size() > 1) {
            String cmd = ((RequestEnvironment)environment.getRequestEnvironment()).getOperationName();
            if ("execute".equals(cmd) || "validate".equals(cmd)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedMultiModels, V5MultiModelsUtil.getModelNames(models));
            }
            environment.enableMultiModelForQuery();
            V5MultiModelsUtil.setMetadataPathInReferencedV5Query(querySet, environment);
            return;
        }
        Pair modelPathAndType = models.iterator().next();
        String modelPath = (String)modelPathAndType.getFirst();
        String modelType = MetadataService.getProviderTypeFromModelPath((String)modelPathAndType.getSecond(), modelPath);
        boolean forceMetadataRefresh = true;
        boolean forceCMTrusted = false;
        boolean reuseCachedConnection = true;
        boolean metadataRequest = false;
        boolean[] connectionOptions = MetadataService.getConnectionOptions(forceCMTrusted, forceMetadataRefresh, metadataRequest);
        MetadataConnection metadataConnection = MetadataService.getInstance().getConnection(modelType, modelPath, (IExecutionEnvironment)environment.getExecutionEnvironment(), reuseCachedConnection, connectionOptions);
        environment.setMetdataConnection(metadataConnection);
        ((RequestEnvironment)environment.getRequestEnvironment()).setModelPath(modelPath);
        String org = querySet.getModelPath();
        querySet.setPropertyValue("modelPath", modelPath);
        if (org != null) {
            querySet.setPropertyValue("orgModelPath", org);
        }
    }

    private static String getModelNames(Set<Pair> models) {
        StringBuffer listOfModels = new StringBuffer("[");
        int i = 0;
        for (Pair p : models) {
            if (i > 0) {
                listOfModels.append(", ");
            }
            listOfModels.append(p.getFirst());
            ++i;
        }
        listOfModels.append("]");
        return listOfModels.toString();
    }

    protected static void setMetadataPathInReferencedV5Query(V5QuerySet querySet, PlanningEnvironment environment) {
        IXQEQueryNode[] qrds;
        String topModelPath = querySet.getModelPath();
        for (IXQEQueryNode c : qrds = querySet.getChildrenOfType(101055)) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)c;
            String queryName = qrd.getRefQueryProperty();
            V5Query refQuery = querySet.getV5Query(queryName);
            if (refQuery == null) continue;
            TreeSet<String> leafQueryNames = new TreeSet<String>();
            V5MultiModelsUtil.getLeafQueryNames(refQuery, leafQueryNames, querySet, environment);
            for (String leafQName : leafQueryNames) {
                V5Query leafQuery = querySet.getV5Query(leafQName);
                if (leafQuery == null) continue;
                String orgmetadataPath = leafQuery.getMetadataPathInSource();
                if (orgmetadataPath == null) {
                    orgmetadataPath = topModelPath;
                }
                if (orgmetadataPath == null) continue;
                leafQuery.setMetadataPath(orgmetadataPath);
            }
        }
    }
}

