/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5MdProjectedItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XTree;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqemoser.MoserMetadataConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class V5SubQueryBuilder {
    private static final String DATAITEM_NAME = "member";
    private static final String QUERY_NAME = "q1";
    private static final String SQL_QUERY_NAME = "sql1";
    private static final String VALUE_SET_NAME = "vs";
    private static final String EDGE_NAME = "e";
    private static final String EDGE1_NAME = "e1";
    private static final String QRD1_NAME = "qrd1";
    private static final String NONE = "none";
    private static final String NAME = "name";
    private static final AtomicInteger SUB_QUERY_ID = new AtomicInteger(0);
    private static final String SUB_QUERY = "subQuery";
    private static final String EDGE_ID = "edgeID";
    private static final String COGSQL = "cogSQL";
    private static final String ERR_CREATING_SUBQUERY_ENVIRONMENT = "Error creating sub-query environment.";

    public static PlanningEnvironment createPlanningEnvironment(ExecutionEnvironment executionEnvironment, PlanningEnvironment mainPlanEnv) {
        RequestEnvironment mainReqEnv = (RequestEnvironment)executionEnvironment.getRequestEnvironment();
        ExecutionEnvironment mainExecEnv = (ExecutionEnvironment)mainReqEnv.getExecutionEnvironment();
        return V5SubQueryBuilder.createPlanningEnvironment(mainPlanEnv, mainReqEnv, mainExecEnv, true);
    }

    public static PlanningEnvironment createPlanningEnvironmentWithoutTracing(ExecutionEnvironment executionEnvironment, PlanningEnvironment mainPlanEnv) {
        RequestEnvironment mainReqEnv = (RequestEnvironment)executionEnvironment.getRequestEnvironment();
        ExecutionEnvironment mainExecEnv = (ExecutionEnvironment)mainReqEnv.getExecutionEnvironment();
        return V5SubQueryBuilder.createPlanningEnvironment(mainPlanEnv, mainReqEnv, mainExecEnv, false);
    }

    private static PlanningEnvironment createPlanningEnvironment(PlanningEnvironment mainPlanEnv, RequestEnvironment mainReqEnv, ExecutionEnvironment mainExecEnv, boolean initPlanLogging) {
        RequestEnvironment newReqEnv = mainReqEnv.duplicate();
        newReqEnv.setSubRequestID(SUB_QUERY + SUB_QUERY_ID.getAndIncrement());
        ExecutionEnvironment newExecEnv = (ExecutionEnvironment)newReqEnv.getExecutionEnvironment();
        newExecEnv.setDataSource(mainExecEnv.getDataSource());
        newExecEnv.setDumpMDX(mainExecEnv.getDumpMDX());
        newExecEnv.setXIteratorLoggingList(mainExecEnv.getXIteratorLoggingList());
        newExecEnv.setRSAPITabularIteratorLogging(mainExecEnv.getRSAPITabularIteratorLogging());
        newExecEnv.setTrace(mainExecEnv.getTrace());
        PlanningEnvironment newPlanEnv = QueryPlanner.setupEnvironment(newReqEnv, initPlanLogging);
        newPlanEnv.setCheckTransformationAppliedTwiceToNodeInSamePass(mainPlanEnv.getCheckTransformationAppliedTwiceToNodeInSamePass());
        newPlanEnv.setMetdataConnection(mainPlanEnv.getMetadataConnection());
        newPlanEnv.setQueryNodeMultiplierLimit(mainPlanEnv.getQueryNodeMultiplerLimit());
        newPlanEnv.setQueryNodeIndexMultiplierLimit(mainPlanEnv.getQueryNodeIndexMultiplierLimit());
        newPlanEnv.setQueryPlanningTimeLimit(mainPlanEnv.getQueryPlanningTimeLimit());
        MultiRequestContext multiRequestContext = mainPlanEnv.getMultiRequestContext();
        if (multiRequestContext != null) {
            newPlanEnv.getMultiRequestContext().setXQEConfigurationMap(multiRequestContext.getXQEConfigurationMap());
        }
        if (null == newPlanEnv.getNodeFactory()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERR_CREATING_SUBQUERY_ENVIRONMENT);
        }
        return newPlanEnv;
    }

    public static V5QuerySet createSingleMemberQuery(IXQEQueryNode v5BoundMemberUniqueName, PlanningEnvironment environment) {
        return V5SubQueryBuilder.createSingleMemberQuery(v5BoundMemberUniqueName, environment, null);
    }

    public static V5QuerySet createSingleMemberQuery(IXQEQueryNode v5BoundMemberUniqueName, PlanningEnvironment environment, Map<String, Object> queryProperties) {
        XQENodeFactory nf = environment.getNodeFactory();
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        environment.getNodeIndex().addNode(v5QuerySet);
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5Query.setPropertyValue(NAME, QUERY_NAME);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        V5SubQueryBuilder.setupV5Source(environment.getMetadataConnection(), v5Source);
        v5Query.addChild(v5Source);
        IXQEQueryNode v5Selection = nf.createNode(101009);
        v5Query.addChild(v5Selection);
        if (queryProperties != null) {
            for (Map.Entry<String, Object> e : queryProperties.entrySet()) {
                v5Query.setPropertyValue(e.getKey(), e.getValue());
            }
        }
        V5DataItem v5DataItem = (V5DataItem)nf.createNode(101003);
        v5DataItem.setNameProperty(DATAITEM_NAME);
        v5DataItem.setAggregateProperty(NONE);
        v5Selection.addChild(v5DataItem);
        IXQEQueryNode v5Expression = nf.createNode(101004);
        v5DataItem.addChild(v5Expression);
        v5Expression.addChild(v5BoundMemberUniqueName);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefiniton.setRefQueryProperty(QUERY_NAME);
        v5QueryResultDefiniton.setPropertyValue(NAME, QRD1_NAME);
        v5QuerySet.addChild(v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue(NAME, EDGE_NAME);
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        V5ValueSet v5ValueSet = (V5ValueSet)nf.createNode(101057);
        v5ValueSet.setNameProperty(VALUE_SET_NAME);
        v5ValueSet.setRefDataItemProperty(DATAITEM_NAME);
        v5EdgeGroup.addChild(v5ValueSet);
        return v5QuerySet;
    }

    public static V5QuerySet createSingleExpressionQuery(String expression, PlanningEnvironment environment) {
        XQENodeFactory nf = environment.getNodeFactory();
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        environment.getNodeIndex().addNode(v5QuerySet);
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5Query.setPropertyValue(NAME, QUERY_NAME);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        V5SubQueryBuilder.setupV5Source(environment.getMetadataConnection(), v5Source);
        v5Query.addChild(v5Source);
        IXQEQueryNode v5Selection = nf.createNode(101009);
        v5Query.addChild(v5Selection);
        V5DataItem v5DataItem = (V5DataItem)nf.createNode(101003);
        v5DataItem.setNameProperty(DATAITEM_NAME);
        v5DataItem.setAggregateProperty(NONE);
        v5Selection.addChild(v5DataItem);
        V5Expression v5Expression = (V5Expression)nf.createNode(101004);
        v5Expression.setExpression(expression);
        v5DataItem.addChild(v5Expression);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefiniton.setRefQueryProperty(QUERY_NAME);
        v5QueryResultDefiniton.setPropertyValue(NAME, QRD1_NAME);
        v5QuerySet.addChild(v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue(NAME, EDGE_NAME);
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        V5ValueSet v5ValueSet = (V5ValueSet)nf.createNode(101057);
        v5ValueSet.setNameProperty(VALUE_SET_NAME);
        v5EdgeGroup.addChild(v5ValueSet);
        V5GroupBody v5GroupBody = (V5GroupBody)nf.createNode(101051);
        v5ValueSet.addChild(v5GroupBody);
        V5DataItemRef v5DataItemRef = (V5DataItemRef)nf.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", DATAITEM_NAME);
        v5GroupBody.addChild(v5DataItemRef);
        return v5QuerySet;
    }

    public static V5QuerySet createSingleSetExpressionQuery(String expression, PlanningEnvironment environment) {
        return V5SubQueryBuilder.createSingleSetExpressionQuery(expression, environment, QRD1_NAME);
    }

    public static V5QuerySet createSingleSetExpressionQuery(String expression, PlanningEnvironment environment, String qrdName) {
        XQENodeFactory nf = environment.getNodeFactory();
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        environment.getNodeIndex().addNode(v5QuerySet);
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5Query.setPropertyValue(NAME, QUERY_NAME);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        V5SubQueryBuilder.setupV5Source(environment.getMetadataConnection(), v5Source);
        v5Query.addChild(v5Source);
        IXQEQueryNode v5Selection = nf.createNode(101009);
        v5Query.addChild(v5Selection);
        V5DataItem v5DataItem = (V5DataItem)nf.createNode(101003);
        v5DataItem.setNameProperty(DATAITEM_NAME);
        v5DataItem.setAggregateProperty(NONE);
        v5Selection.addChild(v5DataItem);
        V5Expression v5Expression = (V5Expression)nf.createNode(101004);
        v5Expression.setExpression(expression);
        v5DataItem.addChild(v5Expression);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefiniton.setRefQueryProperty(QUERY_NAME);
        v5QueryResultDefiniton.setPropertyValue(NAME, qrdName);
        v5QuerySet.addChild(v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue(NAME, EDGE_NAME);
        v5Edge.setPropertyValue(EDGE_ID, 1);
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5Edge1 = nf.createNode(101049);
        v5Edge1.setPropertyValue(NAME, EDGE1_NAME);
        v5Edge1.setPropertyValue(EDGE_ID, 2);
        v5QueryResultDefiniton.addChild(v5Edge1);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        V5ValueSet v5ValueSet = (V5ValueSet)nf.createNode(101057);
        v5ValueSet.setNameProperty(VALUE_SET_NAME);
        v5ValueSet.setRefDataItemProperty(DATAITEM_NAME);
        v5EdgeGroup.addChild(v5ValueSet);
        V5DataItemRef v5DataItemRef = (V5DataItemRef)nf.createNode(101015);
        v5DataItemRef.setPropertyValue("refDataItem", DATAITEM_NAME);
        return v5QuerySet;
    }

    public static IHybridResultSet executeSubQuery(XDataContext dataContext, PlannedV5QuerySet v5QuerySet) {
        List<IXQEQueryNode> mdxQueries = v5QuerySet.getDescendantsOfCategory(501017, true);
        if (mdxQueries.size() != 1) {
            v5QuerySet.throwInternalError("Sub-Query planning resulted in more than 1 query, this is not expected.");
        }
        XMdx mdxNode = (XMdx)mdxQueries.get(0);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)dataContext.getEnvironment();
        boolean dumpMDX = execEnv.getDumpMDX();
        if (dumpMDX) {
            XQEDebugLog.out.println("Execute subquery:");
            XQEDebugLog.out.println(mdxNode.getMdxText());
            XQEDebugLog.out.println();
        }
        return (IHybridResultSet)mdxNode.execute(dataContext);
    }

    public static IHybridResultSet executeSubQuery(XDataContext dataContext, XMdx mdxNode) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)dataContext.getEnvironment();
        boolean dumpMDX = execEnv.getDumpMDX();
        if (dumpMDX) {
            XQEDebugLog.out.println("Execute XMdx subquery:");
            XQEDebugLog.out.println(mdxNode.getMdxText());
            XQEDebugLog.out.println();
        }
        return (IHybridResultSet)mdxNode.execute(dataContext);
    }

    public static TabularHybridResultSet executeSubQuery(XDataContext dataContext, XSql sqlNode) {
        return (TabularHybridResultSet)sqlNode.getJDBCTabularResultSet(dataContext);
    }

    public static IHybridResultSet executeSubQuery(XDataContext dataContext, XTree xTree) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)dataContext.getEnvironment();
        boolean dumpMDX = execEnv.getDumpMDX();
        if (dumpMDX) {
            XQEDebugLog.out.println("Execute XTree subquery:");
            XQEDebugLog.out.println(xTree.dumpToString());
            XQEDebugLog.out.println();
        }
        return (IHybridResultSet)xTree.execute(dataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMember getMemberFromSubQuery(IHybridResultSet hybridResultSet) {
        IMember theMember;
        XIterator xIt = null;
        try {
            xIt = hybridResultSet.getAxisIterator(0);
            ITuple tuple = (ITuple)xIt.next();
            if (tuple == null) {
                IMember iMember = null;
                return iMember;
            }
            theMember = tuple.getMembers()[0];
        }
        finally {
            if (null != xIt) {
                xIt.release();
            }
        }
        return theMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IValue getValueFromSubQuery(IHybridResultSet hybridResultSet) {
        IValue theValue;
        ITabularIterator it = null;
        try {
            it = hybridResultSet.getTabularIterator();
            RowValue row = (RowValue)it.next();
            if (row == null) {
                IValue iValue = null;
                return iValue;
            }
            IValue[] columns = row.getColumns();
            theValue = columns.length == 0 ? null : columns[0];
        }
        finally {
            if (null != it) {
                it.release();
            }
        }
        return theValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMember> getMemberListFromCubeHybridResultSet(IHybridResultSet hybridResultSet) {
        ArrayList<IMember> theMemberList = new ArrayList<IMember>();
        XIterator xIt = null;
        try {
            xIt = hybridResultSet.getAxisIterator(0);
            ITuple tuple = (ITuple)xIt.next();
            while (tuple != null) {
                IMember theMember = tuple.getMembers()[0];
                theMemberList.add(theMember);
                tuple = (ITuple)xIt.next();
            }
        }
        finally {
            if (null != xIt) {
                xIt.release();
            }
        }
        return theMemberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMember> getMemberListFromTabularHybridResultSet(IHybridResultSet hybridResultSet) {
        ArrayList<IMember> theMemberList = new ArrayList<IMember>();
        ITabularIterator tabIt = null;
        try {
            tabIt = hybridResultSet.getTabularIterator();
            RowValue row = (RowValue)tabIt.next();
            while (row != null) {
                String memberName = row.getColumn(0).toString();
                Member theMember = new Member(memberName);
                theMember.setCaption(memberName);
                theMember.setUniqueName(memberName);
                theMember.setProperty("memberUniqueName", memberName);
                theMemberList.add(theMember);
                row = (RowValue)tabIt.next();
            }
        }
        finally {
            if (null != tabIt) {
                tabIt.release();
            }
        }
        return theMemberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMember> getMemberListFromV5HybridResultSet(IHybridResultSet hybridResultSet, RSAPIEdge rsapiEdge) {
        ArrayList<IMember> theMemberList = new ArrayList<IMember>();
        XIterator xIt = null;
        try {
            xIt = hybridResultSet.getV5EdgeIterator(rsapiEdge);
            RowValue rowValue = (RowValue)xIt.next();
            while (rowValue != null) {
                if (rowValue.getColumn(0) instanceof ContextMember) {
                    ContextMember theMember = (ContextMember)rowValue.getColumn(0);
                    theMemberList.add(theMember);
                } else if (rowValue.getColumn(0) instanceof ContextValue) {
                    String memberName = rowValue.getColumn(0).toString();
                    Member theMember = new Member(memberName);
                    theMember.setCaption(memberName);
                    theMember.setUniqueName(memberName);
                    theMember.setProperty("memberUniqueName", memberName);
                    theMemberList.add(theMember);
                } else {
                    throw new IllegalStateException("rowValue.getColumn(0) instanceof ???");
                }
                rowValue = (RowValue)xIt.next();
            }
        }
        finally {
            if (null != xIt) {
                xIt.release();
            }
        }
        return theMemberList;
    }

    public static boolean isSubquery(String subrequestId) {
        return subrequestId.contains(SUB_QUERY);
    }

    public static PlannedV5QuerySet planSingleExpressionQuery(String expression, PlanningEnvironment planEnv, boolean isModelSecurityCheckRequired, boolean isSetQuery) {
        return V5SubQueryBuilder.planSingleExpressionQuery(expression, planEnv, null, null, isModelSecurityCheckRequired, isSetQuery);
    }

    public static PlannedV5QuerySet planSingleExpressionQuery(String expression, PlanningEnvironment planEnv, boolean isModelSecurityCheckRequired) {
        return V5SubQueryBuilder.planSingleExpressionQuery(expression, planEnv, null, null, isModelSecurityCheckRequired, false);
    }

    public static PlannedV5QuerySet planSingleExpressionQuery(String expression, PlanningEnvironment planEnv, Collection<V5MemberUniqueName> explicitMUNs, Map<String, Object> queryProperties, boolean isModelSecurityCheckRequired, boolean isSetQuery) {
        MultiRequestContext mrc = ((ExecutionEnvironment)planEnv.getExecutionEnvironment()).getMultiRequestContext();
        PlannedV5QuerySet plannedQuery = mrc.getSingleExpressionQuery(expression);
        if (plannedQuery != null) {
            return plannedQuery;
        }
        if (planEnv.getMetadataConnection() == null) {
            return null;
        }
        PlanningEnvironment subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironment((ExecutionEnvironment)planEnv.getExecutionEnvironment(), planEnv);
        RequestEnvironment subReqEnv = (RequestEnvironment)subQueryEnvironment.getRequestEnvironment();
        V5QuerySet v5QuerySet = !isSetQuery ? V5SubQueryBuilder.createSingleExpressionQuery(expression, subQueryEnvironment) : V5SubQueryBuilder.createSingleSetExpressionQuery(expression, subQueryEnvironment);
        V5Query v5Query = (V5Query)v5QuerySet.getFirstChildByType(101006);
        v5Query.setModelSecurityCheckRequired(isModelSecurityCheckRequired);
        if (queryProperties != null) {
            for (Map.Entry<String, Object> e : queryProperties.entrySet()) {
                v5Query.setPropertyValue(e.getKey(), e.getValue());
            }
        }
        plannedQuery = QueryPlanner.getInstance().planQuery(v5QuerySet, subQueryEnvironment);
        if (explicitMUNs != null) {
            explicitMUNs.addAll(subReqEnv.getV5Muns().values());
        }
        mrc.cacheSingleExpressionQuery(expression, plannedQuery);
        return plannedQuery;
    }

    public static boolean containsAggregateWithinDetail(IXQEQueryNode node) {
        IXQEQueryNode[] withinClauses = node.getDescendantsOfType(201039, false);
        if (withinClauses.length > 0) {
            for (IXQEQueryNode withinclause : withinClauses) {
                if (((V5AggregateWithinClause)withinclause).getWithinClauseType() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerTreeInEnvironment(PlanningEnvironment subQueryEnvironment, IXQEQueryNode queryNode) {
        V5SubQueryBuilder.registerNodeInEnvironment(subQueryEnvironment, queryNode);
        for (IXQEQueryNode child : queryNode.getChildren()) {
            V5SubQueryBuilder.registerTreeInEnvironment(subQueryEnvironment, child);
        }
    }

    private static void registerNodeInEnvironment(PlanningEnvironment environment, IXQEQueryNode queryNode) {
        queryNode.setPlanningEnvironment(environment);
        queryNode.saveNodeType(queryNode.getNodeType());
    }

    public static void setupV5Source(MetadataConnection metadataConnection, V5Source v5Source) {
        if (metadataConnection != null) {
            v5Source.setModel(metadataConnection.getModelName());
            if (metadataConnection instanceof MoserMetadataConnection) {
                v5Source.setModelType("module");
            }
        }
    }

    public static V5QuerySet createTypeInSQLQuery(String sql, String[] projectedColumns, PlanningEnvironment environment, IDataSource ds) {
        XQENodeFactory nf = environment.getNodeFactory();
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        environment.getNodeIndex().addNode(v5QuerySet);
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5Query.setPropertyValue(NAME, QUERY_NAME);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        v5Query.addChild(v5Source);
        V5SqlQuery v5SqlQuery = (V5SqlQuery)nf.createNode(101016);
        v5SqlQuery.setPropertyValue(NAME, SQL_QUERY_NAME);
        v5SqlQuery.setPropertyValue("sqlText", sql);
        v5SqlQuery.setPropertyValue("type", COGSQL);
        V5SubQueryBuilder.setDataSourceProperty(v5SqlQuery, environment, ds);
        v5SqlQuery.setModel(environment.getMetadataConnection().getModelName());
        v5Source.addChild(v5SqlQuery);
        V5Selection v5Selection = (V5Selection)nf.createNode(101009);
        v5Selection.setAutoSummary(false);
        v5Query.addChild(v5Selection);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefiniton.setRefQueryProperty(QUERY_NAME);
        v5QueryResultDefiniton.setPropertyValue(NAME, QRD1_NAME);
        v5QuerySet.addChild(v5QueryResultDefiniton);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue(NAME, EDGE_NAME);
        v5QueryResultDefiniton.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        V5ValueSet v5ValueSet = (V5ValueSet)nf.createNode(101057);
        v5ValueSet.setNameProperty(VALUE_SET_NAME);
        v5EdgeGroup.addChild(v5ValueSet);
        V5GroupBody v5GroupBody = (V5GroupBody)nf.createNode(101051);
        v5ValueSet.addChild(v5GroupBody);
        for (String columnName : projectedColumns) {
            V5MdProjectedItem projectedItem = (V5MdProjectedItem)nf.createNode(101041);
            projectedItem.setPropertyValue(NAME, columnName);
            v5SqlQuery.addChild(projectedItem);
            V5DataItem v5DataItem = (V5DataItem)nf.createNode(101003);
            v5DataItem.setNameProperty(columnName);
            v5Selection.addChild(v5DataItem);
            V5Expression v5Expression = (V5Expression)nf.createNode(101004);
            String columnReference = UniqueNameGenerator.createUniqueName(SQL_QUERY_NAME, columnName);
            v5Expression.setExpression(columnReference);
            v5DataItem.addChild(v5Expression);
            V5DataItemRef v5DataItemRef = (V5DataItemRef)nf.createNode(101015);
            v5DataItemRef.setPropertyValue("refDataItem", columnName);
            v5GroupBody.addChild(v5DataItemRef);
        }
        return v5QuerySet;
    }

    private static void setDataSourceProperty(V5SqlQuery v5SqlQuery, PlanningEnvironment environment, IDataSource datasrc) {
        if (datasrc != null) {
            v5SqlQuery.removeProperty("dataSource");
            v5SqlQuery.setPropertyValue("dataSource", datasrc.getCMDataSourceName());
            return;
        }
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        List<IModelDataSource> dataSources = metadataConnection.getModelDataSources();
        if (dataSources != null && !dataSources.isEmpty()) {
            ArrayList<String> dataSourceNames = new ArrayList<String>();
            for (IModelDataSource ds : dataSources) {
                dataSourceNames.add(ds.getCMDataSourceName());
            }
            v5SqlQuery.removeProperty("dataSource");
            v5SqlQuery.setPropertyValue("dataSource", dataSourceNames.get(0));
        }
    }
}

