/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import java.util.ArrayList;

public final class ValidateComparisonFunctionDataTypes
extends Transformation {
    private static final String DASH = "-";
    private static final String UNKNOWN_DATA_TYPE = "unknown";

    public ValidateComparisonFunctionDataTypes() {
        this.mName = "Validate data types of the operands in a comparison function.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{201013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        StringBuilder sb;
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        messageContext.add(node);
        String slhParam = null;
        String srhParam = null;
        FDSDataTypeEnum lhParam = null;
        FDSDataTypeEnum rhParam = null;
        if (node.getNumberChildren() > 0 && node.getChild(0) != null) {
            lhParam = V5ExpressionCheck.getFDSDataTypeForV5Expression(node.getChild(0));
            if (lhParam == null) {
                IDataType lhsDataType = ((V5SimpleNode)node).getChildDataTypes()[0];
                if (lhsDataType != null) {
                    sb = new StringBuilder(lhsDataType.getTypeName());
                    sb.append(DASH);
                    sb.append(lhsDataType.getSubTypeName());
                    slhParam = sb.toString();
                }
            } else {
                slhParam = lhParam.toFDSKeyword();
            }
            if (slhParam == null) {
                slhParam = UNKNOWN_DATA_TYPE;
            }
        }
        if (node.getNumberChildren() > 1 && node.getChild(1) != null) {
            rhParam = V5ExpressionCheck.getFDSDataTypeForV5Expression(node.getChild(1));
            if (rhParam == null) {
                IDataType rhsDataType = ((V5SimpleNode)node).getChildDataTypes()[1];
                if (rhsDataType != null) {
                    sb = new StringBuilder(rhsDataType.getTypeName());
                    sb.append(DASH);
                    sb.append(rhsDataType.getSubTypeName());
                    srhParam = sb.toString();
                }
            } else {
                srhParam = rhParam.toFDSKeyword();
            }
            if (srhParam == null) {
                srhParam = UNKNOWN_DATA_TYPE;
            }
        }
        XQEMessage message = new XQEMessage(XQEMessageKeys.EXE_InvalidComparison, slhParam, srhParam, messageContext);
        throw new XQERuntimeException(message);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query v5query = (V5Query)node.getAncestorOfType(101006);
        if (v5query != null && (v5query.isTabular() || v5query.isRelStyle())) {
            this.traceQueryCondition(false, "This is a relational query.", trace);
            return false;
        }
        IDataType lhsDataType = ((V5SimpleNode)node).getChildDataTypes()[0];
        IDataType rhsDataType = ((V5SimpleNode)node).getChildDataTypes()[1];
        if (this.isInvalidDataType(lhsDataType) || this.isInvalidDataType(rhsDataType)) {
            this.traceQueryCondition(false, "Invalid data type.", trace);
            return false;
        }
        if (DataTypeComparator.areCompatibleDataTypes(lhsDataType, rhsDataType)) {
            this.traceQueryCondition(false, "The data types are compatible.", trace);
            return false;
        }
        if (node.getChild(0).getType() == 101003 && this.isRollupAggregateCountOrCountDistinct(node.getChild(0)) && node.getAncestorOfType(101011) != null) {
            lhsDataType = IntegerType.INTEGERTYPE;
        }
        if (node.getChild(1).getType() == 101003 && this.isRollupAggregateCountOrCountDistinct(node.getChild(1)) && node.getAncestorOfType(101011) != null) {
            rhsDataType = IntegerType.INTEGERTYPE;
        }
        if (DataTypeComparator.isComparableTo(lhsDataType, rhsDataType)) {
            this.traceQueryCondition(false, "The data types are comparable.", trace);
            return false;
        }
        if (lhsDataType == VariantType.VARIANT || rhsDataType == VariantType.VARIANT) {
            this.traceQueryCondition(false, "Variant data type is comparable.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The data types are not comparable or compatible.", trace);
        return true;
    }

    private boolean isInvalidDataType(IDataType dataType) {
        return dataType != null && dataType == BusinessKeyType.DEFAULTBUSINESSKEYTYPE;
    }

    private boolean isRollupAggregateCountOrCountDistinct(IXQEQueryNode node) {
        return ((V5DataItem)node).getRollupAggregateProperty().equalsIgnoreCase("count") || ((V5DataItem)node).getRollupAggregateProperty().equalsIgnoreCase("countDistinct");
    }
}

