/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.ast.v5Exp.V5CastFunction;
import com.cognos.xqe.ast.v5Exp.V5CoalesceFunction;
import com.cognos.xqe.ast.v5Exp.V5ExtractFunction;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5IsMissingExpression;
import com.cognos.xqe.ast.v5Exp.V5LikeExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralSpecial;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LookupExpression;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5MovingAndRunningSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5ScalarFunction;
import com.cognos.xqe.ast.v5Exp.V5StringFunction;
import com.cognos.xqe.ast.v5Exp.V5TrimFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class ValidateV5ConstructForROLAPCalculatedMember
extends Transformation {
    private static final String STRING_OPENQUOTE = "(";
    private static final String STRING_CLOSEQUOTE = ")";
    private static final String STRING_SPACE = " ";

    public ValidateV5ConstructForROLAPCalculatedMember() {
        this.mName = "Validate there are no V5 relational constructs in ROLAP calculated member/measure definition.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201014, 201004, 201020, 201009, 201033, 201031, 201037, 201035, 201042, 201025, 201041, 201040, 201065, 201109, 201055, 201051};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MemberFunction memberFcn = null;
        IXQEQueryNode[] memberFcnList = node.getAncestorsOfType(201085);
        if (memberFcnList != null) {
            for (IXQEQueryNode fnc : memberFcnList) {
                if (fnc.getPropertyValue("createdFromROLAPCalcMember") == null) continue;
                memberFcn = (V5MemberFunction)fnc;
                break;
            }
        }
        if (memberFcn == null) {
            return false;
        }
        StringBuilder invalidExpr = new StringBuilder("");
        switch (node.getType()) {
            case 201014: {
                if (((V5ValueExpression)node).getSubType() != 0) break;
                invalidExpr.append(((V5ValueExpression)node).getName());
                invalidExpr.append(STRING_OPENQUOTE);
                invalidExpr.append("||");
                invalidExpr.append(STRING_CLOSEQUOTE);
                break;
            }
            case 201033: {
                if (((V5ValueAnalyticFunction)node).getSubType() == 14 || ((V5ValueAnalyticFunction)node).getSubType() == 12 || ((V5ValueAnalyticFunction)node).getSubType() == 13 || ((V5ValueAnalyticFunction)node).getSubType() == 16 || ((V5ValueAnalyticFunction)node).getSubType() == 15 || ((V5ValueAnalyticFunction)node).getSubType() == 16 || ((V5ValueAnalyticFunction)node).getSubType() == 17 || ((V5ValueAnalyticFunction)node).getSubType() == 18 || ((V5ValueAnalyticFunction)node).getSubType() == 19) {
                    invalidExpr.append(((V5ValueAnalyticFunction)node).getNativeName());
                    invalidExpr.append(STRING_OPENQUOTE);
                    invalidExpr.append(V5AggregateFunctionSubtype.getName(((V5ValueAnalyticFunction)node).getSubType()));
                    invalidExpr.append(STRING_CLOSEQUOTE);
                }
                if (((V5ValueAnalyticFunction)node).getPrefilter()) {
                    invalidExpr.append(((V5ValueAnalyticFunction)node).getNativeName());
                    invalidExpr.append(STRING_OPENQUOTE);
                    invalidExpr.append("prefilter");
                    invalidExpr.append(STRING_CLOSEQUOTE);
                }
                if (!((V5ValueAnalyticFunction)node).getDistinct()) break;
                invalidExpr.append(((V5ValueAnalyticFunction)node).getNativeName());
                invalidExpr.append(STRING_OPENQUOTE);
                invalidExpr.append("distinct");
                invalidExpr.append(STRING_CLOSEQUOTE);
                break;
            }
            case 201031: {
                if (((V5ValueSummaryFunction)node).getSubType() == 8 || ((V5ValueSummaryFunction)node).getSubType() == 11) {
                    invalidExpr.append(((V5ValueSummaryFunction)node).getNativeName());
                    invalidExpr.append(STRING_OPENQUOTE);
                    invalidExpr.append(V5AggregateFunctionSubtype.getName(((V5ValueSummaryFunction)node).getSubType()));
                    invalidExpr.append(STRING_CLOSEQUOTE);
                }
                if (((V5ValueSummaryFunction)node).getPrefilter()) {
                    invalidExpr.append(((V5ValueSummaryFunction)node).getNativeName());
                    invalidExpr.append(STRING_OPENQUOTE);
                    invalidExpr.append("prefilter");
                    invalidExpr.append(STRING_CLOSEQUOTE);
                }
                if (!((V5ValueSummaryFunction)node).getDistinct()) break;
                invalidExpr.append(((V5ValueSummaryFunction)node).getNativeName());
                invalidExpr.append(STRING_OPENQUOTE);
                invalidExpr.append("distinct");
                invalidExpr.append(STRING_CLOSEQUOTE);
                break;
            }
            case 201041: {
                if (((V5StringFunction)node).getSubType() == 1 && ((V5StringFunction)node).getSubType() == 0) break;
                invalidExpr.append(((V5StringFunction)node).getName());
                break;
            }
            case 201040: {
                if (((V5ScalarFunction)node).getSubType() != 6) break;
                invalidExpr.append(((V5ScalarFunction)node).getNodeSubTypeName());
                break;
            }
            case 201065: {
                invalidExpr.append(((V5ExtractFunction)node).getName());
                break;
            }
            case 201109: {
                invalidExpr.append(((V5TrimFunction)node).getName());
                break;
            }
            case 201055: {
                invalidExpr.append(((V5CoalesceFunction)node).getName());
                break;
            }
            case 201051: {
                invalidExpr.append(((V5CastFunction)node).getName());
                break;
            }
            case 201037: {
                invalidExpr.append(((V5AggregateBreakClause)node).getNativeName());
                break;
            }
            case 201025: {
                invalidExpr.append(((V5LiteralSpecial)node).getNodeSubTypeName());
                break;
            }
            case 201035: {
                invalidExpr.append(((V5MovingAndRunningSummaryFunction)node).getNativeName());
                break;
            }
            case 201004: {
                invalidExpr.append(((V5LikeExpression)node).getNativeName());
                break;
            }
            case 201020: {
                invalidExpr.append(((V5LookupExpression)node).getName());
                break;
            }
            case 201009: {
                invalidExpr.append(((V5IsMissingExpression)node).getNativeName());
                break;
            }
            case 201042: {
                invalidExpr.append(((V5GenericFunction)node).getName());
                break;
            }
        }
        if (!invalidExpr.toString().equals("")) {
            StringBuilder calcInfo = new StringBuilder();
            IXQEQueryNode[] names = memberFcn.getChildrenOfType(201026);
            if (names != null) {
                for (IXQEQueryNode name : names) {
                    calcInfo.append(((V5LiteralValue)name).getValue());
                    calcInfo.append(STRING_SPACE);
                }
            }
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedV5ConstructWithinCubeCalculatedMemberDefn, invalidExpr.toString(), calcInfo.toString(), DataSourceTypeEnum.getProviderName("RO"));
        }
        return false;
    }
}

