/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.validate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5JsonFunction;
import com.cognos.xqe.ast.v5Exp.V5XmlFunction;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class ValidateV5DetailFilterExpIsBoolean
extends Transformation {
    public static final String DONOTVALIDATE = "doNotValidate";
    public static final String PROP_IS_VALIDED = "validated";

    public ValidateV5DetailFilterExpIsBoolean() {
        this.mName = "Validate whether detail filter expression evaluates to boolean .";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedDFNonBoolean, node);
        if (!"validateAll".equals(((RequestEnvironment)environment.getRequestEnvironment()).getOperationName())) {
            throw new XQEOlapUnsupportedQueryException(message);
        }
        ResponseMessage msg = new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, message);
        ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(msg, node, environment.getRoot());
        node.setPropertyValue(PROP_IS_VALIDED, true);
    }

    public boolean isBooleanExpression(IXQEQueryNode v5Expr) {
        IXQEQueryNode exprNode = v5Expr;
        while (exprNode.getType() == 101003 || exprNode.getType() == 101004) {
            exprNode = exprNode.getChild(0);
        }
        V5ExpressionTypeEnum expressionType = V5ExpressionCheck.getExpressionType(v5Expr);
        if (expressionType == V5ExpressionTypeEnum.VALUE) {
            if (exprNode.getType() == 201017 && exprNode.getBooleanPropertyValue("isIfThenElseCouldBeCollapsed") == Boolean.TRUE) {
                IXQEQueryNode thenChild = exprNode.getChild(1);
                if (this.isBooleanExpression(thenChild)) {
                    return true;
                }
            } else if (exprNode.getType() == 201018 && exprNode.getBooleanPropertyValue("isCaseCouldBeCollapsed") == Boolean.TRUE) {
                IXQEQueryNode whenChild = exprNode.getFirstChildByType(201019);
                IXQEQueryNode thenChild = whenChild.getChild(1);
                if (this.isBooleanExpression(thenChild)) {
                    return true;
                }
            } else {
                if (exprNode.getType() == 201133 && ((V5XmlFunction)exprNode).getSubType() == 2) {
                    return true;
                }
                if (exprNode.getType() == 201142 && ((V5JsonFunction)exprNode).getSubType() == 1) {
                    return true;
                }
                if (exprNode.getType() == 201015) {
                    return true;
                }
            }
        }
        return expressionType == V5ExpressionTypeEnum.BOOLEAN;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(DONOTVALIDATE) != null || node.getPropertyValue(PROP_IS_VALIDED) != null) {
            return false;
        }
        IXQEQueryNode filterChild = node.getChild(0);
        if (filterChild != null && !this.isBooleanExpression(filterChild)) {
            this.traceQueryCondition(true, "The filter expression is not a boolean expression", trace);
            return true;
        }
        this.traceQueryCondition(false, "The filter expression is boolean expression.", trace);
        return false;
    }
}

