/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.valueuniquename;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundValueUniqueName;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5InExpression;
import com.cognos.xqe.ast.v5Exp.V5IsNullExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralNull;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.ReplaceDMRMemberWithRelationalLiteral;
import com.cognos.xqe.util.Governors;
import java.util.List;

public class ConvertSimpleVUNSetToDetailFilter
extends Transformation {
    public ConvertSimpleVUNSetToDetailFilter() {
        this.mName = "Convert slicer or data item member set with value unique names to a detail filter.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201101, 201118};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] v5Literals;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        query.addChild(detailFilter);
        List<IXQEQueryNode> memberRefs = node.getDescendantsOfTypeOrdered(201118, true);
        IMetadata munMetadata = ((V5BoundValueUniqueName)memberRefs.get(0)).getMetadata();
        IDataType munDataType = munMetadata.getDataType();
        if (munDataType.isApproximateNumeric()) {
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedApproximateNumericValueUniqueName, ((V5BoundValueUniqueName)memberRefs.get(0)).getNativeName(), node);
            throw new XQERuntimeException(message);
        }
        this.convertLogicalPartToLiteral(nodeFactory, memberRefs, detailFilter, munMetadata);
        IXQEQueryNode parent = node.getParent();
        if (parent.getNodeType() == 101014) {
            parent.getAncestorOfType(101010).detach();
        } else if (parent.isOfCategory(201126)) {
            parent.getAncestorOfType(101008).detach();
        } else {
            node.detach();
            V5BoundModelIdentifier boundMeta = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            boundMeta.setMetadata(munMetadata);
            parent.addChild(boundMeta);
        }
        Governors.DMREmptyMUNTreatment emptyMUNTreatment = Governors.DMREmptyMUNTreatment.ASNULL;
        Governors governors = query.getGovernors();
        emptyMUNTreatment = governors.getTreatEmptyDMRMUN();
        for (IXQEQueryNode v5Literal : v5Literals = detailFilter.getDescendantsOfType(201026, false)) {
            V5LiteralValue v5LiteralValue = (V5LiteralValue)v5Literal;
            if (Boolean.TRUE != v5LiteralValue.getPropertyValue("null")) continue;
            if (emptyMUNTreatment == Governors.DMREmptyMUNTreatment.ASNULL) {
                ReplaceDMRMemberWithRelationalLiteral.treatEmptyAsNull(nodeFactory, v5LiteralValue);
                continue;
            }
            if (emptyMUNTreatment != Governors.DMREmptyMUNTreatment.EMPTY_OR_NULL) continue;
            ReplaceDMRMemberWithRelationalLiteral.treatEmptyAsEmptyOrNull(nodeFactory, v5LiteralValue);
        }
    }

    private void convertLogicalPartToLiteral(XQENodeFactory nodeFactory, List<IXQEQueryNode> memberRefs, V5DetailFilter detailFilter, IMetadata munMetadata) {
        if (memberRefs.size() == 1) {
            V5BoundModelIdentifier boundMeta = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            boundMeta.setMetadata(munMetadata);
            V5BoundValueUniqueName v5VUN = (V5BoundValueUniqueName)memberRefs.get(0);
            if (v5VUN.getLogical() == null) {
                V5IsNullExpression isNull = (V5IsNullExpression)nodeFactory.createNode(201010);
                isNull.addChild(nodeFactory.deepCopyNode(boundMeta));
                detailFilter.addChild(isNull);
            } else {
                V5ComparisonExpression comparisonExpr = (V5ComparisonExpression)nodeFactory.createNode(201013);
                comparisonExpr.setSubType(2);
                comparisonExpr.addChild(boundMeta);
                V5LiteralValue v5LiteralValue = ReplaceDMRMemberWithRelationalLiteral.createV5LiteralValue(nodeFactory, munMetadata, v5VUN.getLogicalPart(), true);
                comparisonExpr.addChild(v5LiteralValue);
                detailFilter.addChild(comparisonExpr);
            }
            return;
        }
        V5BoundModelIdentifier boundMeta = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        boundMeta.setMetadata(munMetadata);
        V5InExpression inExpr = (V5InExpression)nodeFactory.createNode(201011);
        inExpr.addChild(boundMeta);
        for (IXQEQueryNode vun : memberRefs) {
            V5BoundValueUniqueName v5VUN = (V5BoundValueUniqueName)vun;
            if (v5VUN.getLogical() == null) {
                V5LiteralNull v5LiteralNull = (V5LiteralNull)nodeFactory.createNode(201023);
                inExpr.addChild(v5LiteralNull);
                continue;
            }
            V5LiteralValue v5LiteralValue = ReplaceDMRMemberWithRelationalLiteral.createV5LiteralValue(nodeFactory, munMetadata, v5VUN.getLogicalPart(), true);
            inExpr.addChild(v5LiteralValue);
        }
        detailFilter.addChild(inExpr);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] vunRefs = node.getDescendantsOfType(201118, true);
        if (vunRefs.length == 0) {
            this.traceNodeCondition(false, "The slicer memberset has no V5BoundValueUniqueName.", environment.getTrace());
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getNodeType() != 101014 && parent.getNodeType() != 101003) {
            this.traceNodeCondition(false, "Parent is not slicer or a data item. Other transformations should be applied.", environment.getTrace());
            return false;
        }
        if (vunRefs.length == 1 && node.getNodeType() == 201118) {
            if (parent.getNodeType() == 201101) {
                this.traceNodeCondition(false, "This V5BoundValueUniqueName is in a set function, it will be converted when set is converted.", environment.getTrace());
                return false;
            }
            if (parent.getNodeType() == 101003 && !((V5DataItem)parent).getIsProjected()) {
                this.traceNodeCondition(false, "This V5BoundValueUniqueName is not projected.", environment.getTrace());
                return false;
            }
        }
        this.traceNodeCondition(true, "VUN or VUN set will be converted to a V5DetailFilter.", trace);
        return true;
    }
}

