/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.valueuniquename;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundValueUniqueName;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.dmr.ReplaceDMRMemberWithRelationalLiteral;
import com.cognos.xqe.util.Governors;

public class ConvertVUNToLiteral
extends Transformation {
    public ConvertVUNToLiteral(int[] passNumbers) {
        this.mName = "Convert V5BoundValueUniqueName to a V5Literal node.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201118};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode parent = node.getParent();
        IXQEQueryNode[] children = parent.getChildrenOfType(201118);
        if (children.length != 0) {
            for (IXQEQueryNode vunRef : children) {
                if (((V5BoundValueUniqueName)vunRef).getLogical() == null) {
                    IXQEQueryNode theNull = nodeFactory.createNode(201023);
                    vunRef.exchange(theNull);
                    continue;
                }
                String literalString = ((V5BoundValueUniqueName)vunRef).getLogicalPart();
                IDataType dataType = ((V5BoundValueUniqueName)vunRef).getMetadata().getDataType();
                V5LiteralValue literalValue = (V5LiteralValue)nodeFactory.createNode(201026);
                literalValue.setNativeName(literalString);
                literalValue.setDataType(dataType);
                literalValue.setValue(literalString);
                vunRef.exchange(literalValue);
                if (!literalString.isEmpty()) continue;
                Governors governors = null;
                Governors.DMREmptyMUNTreatment emptyMUNTreatment = Governors.DMREmptyMUNTreatment.ASNULL;
                V5Query v5Query = (V5Query)parent.getAncestorOfType(101006);
                if (v5Query != null) {
                    governors = v5Query.getGovernors();
                    emptyMUNTreatment = governors.getTreatEmptyDMRMUN();
                }
                if (emptyMUNTreatment == Governors.DMREmptyMUNTreatment.ASNULL) {
                    ReplaceDMRMemberWithRelationalLiteral.treatEmptyAsNull(nodeFactory, literalValue);
                    continue;
                }
                if (emptyMUNTreatment != Governors.DMREmptyMUNTreatment.EMPTY_OR_NULL) continue;
                ReplaceDMRMemberWithRelationalLiteral.treatEmptyAsEmptyOrNull(nodeFactory, literalValue);
            }
        }
        if (parent.isOfCategory(201122)) {
            parent.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        this.traceNodeCondition(true, "The V5BoundValueUniqueName will be converted to a V5Literal node.", environment.getTrace());
        return true;
    }
}

