/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5.valueuniquename;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Slicer;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5BoundValueUniqueName;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItemOfQuerySubject;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public final class ValidateV5QueryWithVuns
extends Transformation {
    public ValidateV5QueryWithVuns() {
        this.mName = "Validate V5Query with value unique names.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        ((V5Query)node).setPropertyValue("isTabular", Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] vunRefs = node.getDescendantsOfType(201118, true);
        if (vunRefs.length == 0) {
            this.traceNodeCondition(false, "The V5Query has no V5BoundValueUniqueName.", environment.getTrace());
            return false;
        }
        for (IXQEQueryNode v5BoundVun : vunRefs) {
            IMetadata metadata = ((V5BoundValueUniqueName)v5BoundVun).getMetadata();
            if (metadata instanceof IQueryItemOfQuerySubject) continue;
            this.traceNodeCondition(false, "Not a member from a query item.", environment.getTrace());
            return false;
        }
        LinkedHashSet<IXQEQueryNode> ancestorsSet = null;
        if (vunRefs.length != 0) {
            ancestorsSet = new LinkedHashSet<IXQEQueryNode>();
            for (IXQEQueryNode vunRef : vunRefs) {
                ancestorsSet.addAll(Arrays.asList(vunRef.getAncestorsOfTypes(new int[]{101010, 101008, 101003})));
            }
        }
        ArrayList<IMetadata> metadataList = null;
        if (ancestorsSet != null && !ancestorsSet.isEmpty()) {
            List<IXQEQueryNode> v5BoundToMetadatas = null;
            for (IXQEQueryNode ancestor : ancestorsSet) {
                v5BoundToMetadatas = ancestor.getDescendantsOfCategoryOrdered(201029, false);
                if (v5BoundToMetadatas != null && v5BoundToMetadatas.size() > 0) {
                    metadataList = new ArrayList<IMetadata>();
                    for (IXQEQueryNode boundToMetadata : v5BoundToMetadatas) {
                        IMetadata metadata1 = ((V5BoundToMetadata)boundToMetadata).getMetadata();
                        if (!metadataList.contains(metadata1)) {
                            metadataList.add(metadata1);
                        }
                        if (metadataList.size() <= 1) continue;
                        String messageParam2 = ((V5QueryNode)ancestor).getNodeTypeName();
                        String messageParam3 = null;
                        messageParam3 = ancestor.getType() == 101003 ? ((V5DataItem)ancestor).getNameProperty() : ((V5QueryNode)ancestor).getOriginalExpression();
                        XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_MultiQueryItemExpression, ((Object)metadataList).toString(), messageParam2, messageParam3, ancestor);
                        ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(message.getTitle(XQEMessages.getCurrProductLocale()));
                    }
                }
                if (metadataList != null && !metadataList.isEmpty()) {
                    XQEMessage message;
                    IQueryItemOfQuerySubject munQueryItem = (IQueryItemOfQuerySubject)metadataList.iterator().next();
                    if (munQueryItem.getDataType().isApproximateNumeric()) {
                        message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedApproximateNumericValueUniqueName, ((V5BoundToMetadata)v5BoundToMetadatas.get(0)).getNativeName(), ancestor);
                        throw new XQERuntimeException(message);
                    }
                    if (munQueryItem.isFact()) {
                        message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedFactValueUniqueName, ((V5BoundToMetadata)v5BoundToMetadatas.get(0)).getNativeName(), ancestor);
                        throw new XQERuntimeException(message);
                    }
                }
                if (ancestor == null || ancestor.getNodeType() != 101010) continue;
                V5Query query = (V5Query)node;
                String suppress = (String)query.getPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName());
                if (suppress != null && suppress.equalsIgnoreCase("none")) {
                    XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedSlicerAndSuppressionDefinition, ((V5Slicer)ancestor).getOriginalExpression(), node);
                    throw new XQERuntimeException(message);
                }
                IXQEQueryNode expressionNode = ancestor;
                while (expressionNode.getType() == 101003 || expressionNode.getType() == 101010 || expressionNode.getType() == 101014 || expressionNode.getType() == 101008 || expressionNode.getType() == 101004) {
                    expressionNode = expressionNode.getChild(0);
                }
                V5ExpressionTypeEnum type = V5ExpressionCheck.getExpressionTypeLookingForProjectedValueExpression(expressionNode);
                if (type == V5ExpressionTypeEnum.MEMBER || type == V5ExpressionTypeEnum.SET) continue;
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedValueExpressionInSlicer, ancestor);
                throw new XQERuntimeException(message);
            }
        }
        if ((v5Query = (V5Query)node).isTabular()) {
            this.traceNodeCondition(false, "The V5Query with value unique name is valid and supported. And no need to reset PROP_BOOLEAN_IS_TABULAR property.", trace);
            return false;
        }
        if (node.getDescendantsOfType(201107, true).length != 0 || node.getDescendantsOfType(201048, true).length != 0) {
            this.traceNodeCondition(false, "The V5Query has V5TopPercentFunction or V5BottomPercentFunction and the PROP_BOOLEAN_IS_TABULAR should be false", trace);
            return false;
        }
        if (node.getParent().getType() == 101002 && node.getParent().getDescendantsOfType(101049, false).length > 1) {
            this.traceNodeCondition(false, "The query contains multiple edges", trace);
            return false;
        }
        this.traceNodeCondition(true, "Need to set PROP_BOOLEAN_IS_TABULAR property.", trace);
        return true;
    }
}

