/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeProjProperty;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MetadatatoMDXMemberPropertyTranslator;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.HandleRowsProjectingDuplicatedSets;

public final class AddAxisDimensionProperties
extends Transformation {
    public static final String PROJECTED_PROPERTY_ORIGINAL_LEVELINFO = "ProjectedPropertyOrgLevelInfo";
    private static final String[] PROVIDER_TYPES = new String[]{"YK", "M8", "M12", "M14", "M16", "M17", "M19", "MAZ", "XO", "X8", "XI", "RO", "X5"};
    private static final String[] MSAS_ATTR_REQUESTED_BYDEFAULT = new String[]{"MEMBER_CAPTION", "MEMBER_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_NUMBER"};
    private static final String[] CS_ATTR_ALLOWED = new String[]{"CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_NUMBER", "MEMBER_KEY", "KEY", "MEMBER_UNIQUE_NAME", "MEMBER_NAME", "MEMBER_TYPE", "MEMBER_GUID", "MEMBER_ORDINAL", "CHILDREN_CARDINALITY", "PARENT_LEVEL", "PARENT_UNIQUE_NAME", "PARENT_COUNT"};

    public AddAxisDimensionProperties() {
        this.mName = "Add Projected Member Properties to the Axi's DIMENSION PROPERTIES Clause.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        TNodeProjProperty tNode = (TNodeProjProperty)node;
        this.flagAncestorCogMDX(tNode);
        while (node.getNumberChildren() > 1) {
            IQueryItem queryItemProperty = null;
            String propertyName = null;
            BaseProperty baseProperty = (BaseProperty)node.detachChild(1);
            if (baseProperty.getPropertyMetadata() != null) {
                queryItemProperty = baseProperty.getPropertyMetadata();
                propertyName = MetadatatoMDXMemberPropertyTranslator.translate(queryItemProperty.getUniqueName());
                if (propertyName == null) {
                    propertyName = queryItemProperty.getUniqueName();
                    queryItemProperty = null;
                } else if (!propertyName.equals("PPDS_KEY") && queryItemProperty.getUniqueName().equals(propertyName)) {
                    propertyName = null;
                } else {
                    queryItemProperty = null;
                }
            } else if (baseProperty.getPropertyName() != null) {
                propertyName = baseProperty.getPropertyName();
            }
            if (propertyName != null) {
                int i;
                boolean isMSASDataSource = false;
                boolean addToDimensionPropertyList = true;
                MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
                String dataSource = mdxQuery.getDataSourceType();
                for (i = 0; i < PROVIDER_TYPES.length; ++i) {
                    if (!dataSource.equals(PROVIDER_TYPES[i])) continue;
                    isMSASDataSource = true;
                }
                if (isMSASDataSource) {
                    for (i = 0; i < MSAS_ATTR_REQUESTED_BYDEFAULT.length; ++i) {
                        if (propertyName.compareTo(MSAS_ATTR_REQUESTED_BYDEFAULT[i]) != 0) continue;
                        addToDimensionPropertyList = false;
                    }
                }
                if (DataSourceTypeEnum.isEssbase(dataSource)) {
                    IDataSourceCapabilities capabilities;
                    boolean isLOLAP = false;
                    IXQEQueryNode cogMDXQueryNode = node.getAncestorOfType(1002);
                    if (cogMDXQueryNode != null && (capabilities = ((MDXQuery)cogMDXQueryNode).getCapabilities()).isSupported("v5.useLocalOLAP")) {
                        isLOLAP = true;
                    }
                    if (!isLOLAP && propertyName.equalsIgnoreCase("DESCRIPTION")) {
                        propertyName = "COMMENTS";
                    }
                    addToDimensionPropertyList = true;
                }
                if ((DataSourceTypeEnum.isCubingServices(dataSource) || DataSourceTypeEnum.isROLAP(dataSource)) && queryItemProperty == null) {
                    addToDimensionPropertyList = false;
                    if (propertyName.equalsIgnoreCase("levelLabel")) {
                        propertyName = "MEMBER_NAME";
                        addToDimensionPropertyList = true;
                    } else if (propertyName.equalsIgnoreCase("MEMBER_CAPTION")) {
                        propertyName = "CAPTION";
                        addToDimensionPropertyList = true;
                    } else {
                        for (i = 0; i < CS_ATTR_ALLOWED.length; ++i) {
                            if (!propertyName.equalsIgnoreCase(CS_ATTR_ALLOWED[i])) continue;
                            addToDimensionPropertyList = true;
                            break;
                        }
                    }
                }
                if (!addToDimensionPropertyList) continue;
                edge.addMemberProperty(propertyName);
                continue;
            }
            if (queryItemProperty != null) {
                edge.addCustomMemberProperty(queryItemProperty);
                continue;
            }
            node.throwInternalError("Unable get name of property, TNode id=" + node.getId());
        }
        node.extract();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getAncestorOfType(1006) != null) {
            status = true;
            this.traceQueryCondition(status, "The TNodeProjProperty node is within a MDXEdge.", trace);
        } else {
            this.traceQueryCondition(status, "The TNodeProjProperty node is not within a MDXEdge.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery;
        String dataSource;
        int numChildren;
        XQETrace trace = environment.getTrace();
        int[] types = new int[]{1027, 1026};
        if (node.getParent().isOfTypes(types)) {
            IXQEQueryNode[] groupsAndsNests;
            for (IXQEQueryNode gORn : groupsAndsNests = node.getParent().getDescendantsOfTypes(types, true)) {
                if (!HandleRowsProjectingDuplicatedSets.nodeCondition(gORn, environment, null)) continue;
                this.traceQueryCondition(false, "Wait for HandleRowsProjectingDuplicatedSets to be applied first.", trace);
                return false;
            }
        }
        if ((numChildren = node.getNumberChildren()) > 1 && (dataSource = (mdxQuery = (MDXQuery)node.getAncestorOfType(1002)).getDataSourceType()).equals("BW")) {
            for (int i = 1; i < numChildren; ++i) {
                IQueryItem property;
                BaseProperty baseProperty = (BaseProperty)node.getChild(i);
                if (baseProperty.getPropertyMetadata() == null || !(property = baseProperty.getPropertyMetadata()).isBusinessKey()) continue;
                this.traceQueryCondition(false, "The TNodeProjProperty has a businesskey property, and is against SAPBW provider. AddSAPBusinessKey should be applied.", trace);
                return false;
            }
        }
        this.traceQueryCondition(true, "The edge dose not project an SAP business key property.", trace);
        return true;
    }

    private void flagAncestorCogMDX(TNodeProjProperty tNode) {
        int[] cogMDXTypes = new int[]{1027, 1026};
        AbstractMDXSet cogMDX = (AbstractMDXSet)tNode.getAncestorOfTypes(cogMDXTypes);
        if (cogMDX != null) {
            if ((cogMDX.getChild(0) == tNode || ((AbstractMDXSet)cogMDX.getChild(0)).isProjectedDescendant(tNode)) && cogMDX.getPropertyValue(PROJECTED_PROPERTY_ORIGINAL_LEVELINFO) == null) {
                MDXLevelInfo levelInfo = tNode.getLevelInfo();
                cogMDX.setPropertyValue(PROJECTED_PROPERTY_ORIGINAL_LEVELINFO, levelInfo);
            }
        } else {
            int[] v5Types = new int[]{101057, 101015};
            V5QueryNode v5Node = (V5QueryNode)tNode.getAncestorOfTypes(v5Types);
            if (v5Node != null) {
                MDXLevelInfo levelInfo = tNode.getLevelInfo();
                v5Node.setPropertyValue(PROJECTED_PROPERTY_ORIGINAL_LEVELINFO, levelInfo);
            }
        }
    }
}

