/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXIn;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public class ConvertDetailFilterCogMDXEqNeqToCogMDXIn
extends Transformation {
    public ConvertDetailFilterCogMDXEqNeqToCogMDXIn() {
        this.mName = "Coerce '=' and '<>' operators in detail filter conditions to Cog MDX In";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXIn cogMDXInNode = (CogMDXIn)nodeFactory.createNode(1029);
        node.getParent().exchangeChildNode(node, cogMDXInNode, true);
        MDXSet setNode = (MDXSet)nodeFactory.createNode(1039);
        cogMDXInNode.getChild(1).insertParent(setNode);
        if (((V5ComparisonExpression)node).getSubType() == 3) {
            IXQEQueryNode notNode = nodeFactory.createNode(1109);
            cogMDXInNode.insertParent(notNode);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode detailFilterNode = node.getAncestorOfType(1010);
        if (detailFilterNode != null) {
            status = true;
            this.traceQueryCondition(status, "The node is within a Cog MDX Detail Filter.", trace);
        } else {
            this.traceQueryCondition(status, "The node is not within a Cog MDX Detail Filter.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        boolean status = ConvertDetailFilterCogMDXEqNeqToCogMDXIn.nodeCondition(node, traceMsg);
        this.traceNodeCondition(status, traceMsg.toString(), trace);
        return status;
    }

    public static boolean nodeCondition(IXQEQueryNode node, StringBuilder traceMsg) {
        boolean status = false;
        boolean invalidFilter = false;
        int subtype = ((V5ComparisonExpression)node).getSubType();
        if (subtype == 2 || subtype == 3) {
            if (node.getNumberChildren() == 2) {
                IXQEQueryNode firstOperand = node.getChild(0);
                if (firstOperand.isOfCategory(1021)) {
                    IXQEQueryNode secondOperand = node.getChild(1);
                    if (secondOperand.getType() == 1129) {
                        status = true;
                    } else if (secondOperand.isOfCategory(1022)) {
                        MDXHierInfo hierInfoLeftExpression = ((AbstractMDXNode)firstOperand).getHierarchyInfo();
                        MDXHierInfo hierInfoRightExpression = ((AbstractMDXNode)secondOperand).getHierarchyInfo();
                        if (hierInfoLeftExpression.getNumProjectedHierarchies() == 1 && hierInfoLeftExpression.compareProjectedHierarchies(hierInfoRightExpression)) {
                            status = true;
                        }
                    } else if (secondOperand.isOfCategory(1021)) {
                        invalidFilter = true;
                    }
                }
            } else if (node.getNumberChildren() > 2) {
                invalidFilter = true;
            }
            if (invalidFilter) {
                String filterExp = "";
                CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
                filterExp = detailFilter.getOriginalExpression();
                status = false;
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidComparisonExpression, filterExp);
            }
        }
        if (status) {
            traceMsg.append("The '='/'<>' node is used in a detailFilter condition, and the LH operand is a set.");
        } else {
            traceMsg.append("The '='/'<>' node is not used in a detailFilter condition, or the LH operand is not a set");
        }
        return status;
    }
}

