/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeSort;
import com.cognos.xqe.ast.olap.TNodeSortItem;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.v5.XV5Reform;
import com.cognos.xqe.runtree.v5.XV5Sort;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class ConvertLocalSortToXV5Sort
extends AbstractV5ToCogMDXTransformation {
    public static final String STRING_NAME = "name";
    public static final String STRING_REFDATAITEM = "refDataItem";
    public static final String STRING_DESCENDING = "descending";

    public ConvertLocalSortToXV5Sort() {
        this.mName = "Convert TNodeSort To XV5Sort for local sorting";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        String edgeName = (String)edge.getPropertyValue(STRING_NAME);
        XV5Reform xNode = (XV5Reform)node.getAncestorOfType(501096);
        RSAPIDataset rsapiDataset = xNode != null ? xNode.getDataSet() : (RSAPIDataset)node.getAncestorOfType(401005);
        RSAPIEdge[] edges = rsapiDataset.getEdges();
        int edgeNum = 0;
        for (edgeNum = 0; edgeNum < edges.length && !edges[edgeNum].getName().equals(edgeName); ++edgeNum) {
        }
        if (edgeNum >= edges.length) {
            throw new InternalError("Bad index");
        }
        ConvertLocalSortToXV5Sort.convertTNodeSortToXV5Sort((TNodeSort)node, environment, edgeNum);
    }

    public static void convertTNodeSortToXV5Sort(TNodeSort tNodeSort, PlanningEnvironment environment, int edgeNum) {
        int oriRowsetID;
        int rowsetId;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        XV5Reform xNode = (XV5Reform)tNodeSort.getAncestorOfType(501096);
        RSAPIDataset rsapiDataset = xNode != null ? xNode.getDataSet() : (RSAPIDataset)tNodeSort.getAncestorOfType(401005);
        RSAPIDataset originalDataset = (RSAPIDataset)tNodeSort.getAncestorOfType(401005);
        XV5Sort xSort = (XV5Sort)tNodeSort.getAncestorOfType(501039);
        if (xSort == null) {
            xSort = (XV5Sort)nodeFactory.createXNode(501039);
            IXQEQueryNode topNode = originalDataset.getChild(0);
            topNode.insertParent(xSort);
        }
        MDXQuery mdxQuery = (MDXQuery)tNodeSort.getAncestorOfType(1002);
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        NullBehavior nullBehavior = NullBehavior.getDataSourceNullOrderBehavior(capabilities, NullBehavior.ZERO_FIRST);
        xSort.setNullBehaviorFromCofig(nullBehavior);
        RSAPIEdgeRowset[] rowsets = rsapiDataset.getEdge(edgeNum).getRowsets();
        String sValueSet = tNodeSort.getPropertyValue(STRING_NAME).toString();
        for (rowsetId = 0; rowsetId < rowsets.length; ++rowsetId) {
            String rowsetName = rowsets[rowsetId].getName();
            if ((rowsetName = ConvertLocalSortToXV5Sort.getOriginalRowsetName(rowsetName)).equals(sValueSet)) break;
        }
        RSAPIDataItem[] dataItems = rowsets[rowsetId].getDataItems();
        IXQEQueryNode[] sortItemNodes = tNodeSort.getChildrenOfTypeOrdered(1118);
        String vsRefDataItem = (String)tNodeSort.getPropertyValue(STRING_REFDATAITEM);
        int edgeNumber = tNodeSort.getPropertyValue("edgeID") == null ? edgeNum : (Integer)tNodeSort.getPropertyValue("edgeID");
        RSAPIEdgeRowset[] oriRowsets = originalDataset.getEdge(edgeNumber).getRowsets();
        String vsName = tNodeSort.getPropertyValue(STRING_NAME).toString();
        for (oriRowsetID = 0; oriRowsetID < oriRowsets.length; ++oriRowsetID) {
            String rowsetName = oriRowsets[oriRowsetID].getName();
            if ((rowsetName = ConvertLocalSortToXV5Sort.getOriginalRowsetName(rowsetName)).equals(vsName)) break;
        }
        for (int i = 0; i < sortItemNodes.length; ++i) {
            String strOrdering;
            TNodeSortItem sortItem = (TNodeSortItem)sortItemNodes[i];
            int columnNum = -1;
            String siRefDataItem = sortItem.getRefDataItem();
            if (vsRefDataItem == null || !vsRefDataItem.equals(siRefDataItem)) {
                for (columnNum = 0; columnNum < dataItems.length && !dataItems[columnNum].getName().equals(siRefDataItem); ++columnNum) {
                }
                if (columnNum >= dataItems.length) {
                    throw new UnsupportedOperationException("Local sorting of a non-projected dataItem");
                }
            }
            boolean isAscending = (strOrdering = sortItem.getSortOrder()).compareTo(STRING_DESCENDING) != 0;
            xSort.addSortSpec(edgeNumber, oriRowsetID, columnNum, isAscending);
            tNodeSort.detachChild(sortItem);
        }
        if (tNodeSort.getNumberChildren() != 1) {
            throw new InternalError("TNodeSort still has children");
        }
        tNodeSort.extract();
    }

    public static boolean doLocalSort(IXQEQueryNode cogMDXQueryNode, PlanningEnvironment environment) {
        IDataSourceCapabilities capabilities = ((MDXQuery)cogMDXQueryNode).getCapabilities();
        if (!capabilities.isSupported("v5.sort.local")) {
            return false;
        }
        String location = capabilities.getStringValue("v5.sort.location", "unspecified");
        return location.equals("local");
    }

    public static boolean supportLocalSort(IXQEQueryNode node, PlanningEnvironment env) {
        int rowsetId;
        boolean supported = true;
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        String edgeName = (String)edge.getPropertyValue(STRING_NAME);
        XV5Reform xNode = (XV5Reform)node.getAncestorOfType(501096);
        RSAPIDataset rsapiDataset = xNode != null ? xNode.getDataSet() : (RSAPIDataset)node.getAncestorOfType(401005);
        RSAPIEdge[] edges = rsapiDataset.getEdges();
        int edgeNum = 0;
        for (edgeNum = 0; edgeNum < edges.length && !edges[edgeNum].getName().equals(edgeName); ++edgeNum) {
        }
        RSAPIEdgeRowset[] rowsets = rsapiDataset.getEdge(edgeNum).getRowsets();
        String sValueSet = node.getPropertyValue(STRING_NAME).toString();
        for (rowsetId = 0; rowsetId < rowsets.length; ++rowsetId) {
            String rowsetName = rowsets[rowsetId].getName();
            if ((rowsetName = ConvertLocalSortToXV5Sort.getOriginalRowsetName(rowsetName)).equals(sValueSet)) break;
        }
        RSAPIDataItem[] dataItems = rowsets[rowsetId].getDataItems();
        IXQEQueryNode[] sortItemNodes = node.getChildrenOfTypeOrdered(1118);
        String vsRefDataItem = (String)node.getPropertyValue(STRING_REFDATAITEM);
        for (int i = 0; i < sortItemNodes.length; ++i) {
            TNodeSortItem sortItem = (TNodeSortItem)sortItemNodes[i];
            int columnNum = -1;
            String siRefDataItem = sortItem.getRefDataItem();
            if (vsRefDataItem != null && vsRefDataItem.equals(siRefDataItem)) continue;
            for (columnNum = 0; columnNum < dataItems.length && !dataItems[columnNum].getName().equals(siRefDataItem); ++columnNum) {
            }
            if (columnNum < dataItems.length) continue;
            supported = false;
            break;
        }
        return supported;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] sortItemNodes = node.getChildrenOfType(1118);
        if (sortItemNodes.length == 0) {
            this.traceNodeCondition(false, "The TNodeSort node does not have any TNodeSortItem child nodes.", trace);
            return false;
        }
        IXQEQueryNode[] summaries = node.getAncestorsOfType(1080);
        if (summaries.length != 0) {
            this.traceNodeCondition(false, "V5ValueSet is a descendant of a Report Summary", trace);
            return false;
        }
        IXQEQueryNode cogMDXQueryNode = node.getAncestorOfType(1002);
        if (!ConvertLocalSortToXV5Sort.doLocalSort(cogMDXQueryNode, environment)) {
            this.traceNodeCondition(false, "Local sort processing not required.", trace);
            return false;
        }
        if (!ConvertLocalSortToXV5Sort.supportLocalSort(node, environment)) {
            this.traceNodeCondition(false, "Local sort processing not supported.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Local sort processing required.", trace);
        return true;
    }

    private static String getOriginalRowsetName(String name) {
        int idx = name.indexOf("_rm_");
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        return name;
    }
}

