/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXParameterBooleanValue;
import com.cognos.xqe.ast.olap.MDXParameterDateTimeValue;
import com.cognos.xqe.ast.olap.MDXParameterMember;
import com.cognos.xqe.ast.olap.MDXParameterNumericValue;
import com.cognos.xqe.ast.olap.MDXParameterStringValue;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.util.V5ParameterUtil;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.types.NumericType;
import com.cognos.xqe.data.types.TextType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;

public class ConvertV5BoundParameterToMDXParameter
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5BoundParameterToMDXParameter() {
        this.mName = "Converts V5 parameter node into MDX Parameter node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201127};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXNode newNode = null;
        V5BoundParameter v5BoundParameter = (V5BoundParameter)node;
        if (v5BoundParameter.isLiteral()) {
            IDataType dataType = v5BoundParameter.getDataType();
            if (dataType instanceof NumericType || dataType instanceof IntervalType) {
                MDXParameterNumericValue mdxParameterNode = (MDXParameterNumericValue)nodeFactory.createNode(1161);
                mdxParameterNode.setName(v5BoundParameter.getParameterName());
                mdxParameterNode.setIdentifier(v5BoundParameter.getIdentifier());
                newNode = mdxParameterNode;
            } else if (dataType instanceof TextType) {
                MDXParameterStringValue mdxParameterNode = (MDXParameterStringValue)nodeFactory.createNode(1159);
                mdxParameterNode.setName(v5BoundParameter.getParameterName());
                mdxParameterNode.setIdentifier(v5BoundParameter.getIdentifier());
                newNode = mdxParameterNode;
            } else if (dataType instanceof BooleanType) {
                MDXParameterBooleanValue mdxParameterNode = (MDXParameterBooleanValue)nodeFactory.createNode(1163);
                mdxParameterNode.setName(v5BoundParameter.getParameterName());
                mdxParameterNode.setIdentifier(v5BoundParameter.getIdentifier());
                newNode = mdxParameterNode;
            } else if (dataType instanceof DateType || dataType instanceof TimeType || dataType instanceof TimestampType) {
                MDXParameterDateTimeValue mdxParameterNode = (MDXParameterDateTimeValue)nodeFactory.createNode(1162);
                mdxParameterNode.setName(v5BoundParameter.getParameterName());
                mdxParameterNode.setIdentifier(v5BoundParameter.getIdentifier());
                newNode = mdxParameterNode;
            } else {
                node.throwInternalError("Literal V5BoundParameter node has an unsupported data type");
            }
        } else {
            MDXParameterMember mdxParameterNode = ConvertV5BoundParameterToMDXParameter.convertToMdxMember(nodeFactory, v5BoundParameter, environment);
            if (mdxParameterNode == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "ConvertV5BoundParameterToMDXParameter requires metadata");
            }
            newNode = mdxParameterNode;
        }
        MDXQuery query = (MDXQuery)node.getAncestorOfType(1002);
        if (null != query) {
            query.addMDXParameter(newNode);
        }
        node.getParent().exchangeChildNode(node, newNode, false);
    }

    public static MDXParameterMember convertToMdxMember(IXQENodeFactory nodeFactory, V5BoundParameter v5BoundParameter, PlanningEnvironment environment) {
        MultiRequestContext multiRequestContext;
        RequestParameters requestParameters;
        Parameter parameter;
        List<ILevel> levels = V5ParameterUtil.getLevels(v5BoundParameter);
        if (levels.size() == 0) {
            return null;
        }
        MDXParameterMember mdxParameterNode = (MDXParameterMember)nodeFactory.createNode(1129);
        mdxParameterNode.setName(v5BoundParameter.getParameterName());
        mdxParameterNode.setIdentifier(v5BoundParameter.getIdentifier());
        if (!mdxParameterNode.getExternalValues().isEmpty()) {
            String memberExternalName = mdxParameterNode.getExternalValues().get(0);
            mdxParameterNode.bindExternalName(memberExternalName);
        }
        V5QuerySet v5QuerySet = (V5QuerySet)v5BoundParameter.getAncestorOfType(101002);
        if (levels.size() > 1 && v5BoundParameter.isMasterDetailParameter() && (v5QuerySet == null || !v5QuerySet.isMultidimensionalSubquery()) && (parameter = (requestParameters = (multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext()).getRequestParameters()).getParameters().getParameter(v5BoundParameter.getParameterName())) != null) {
            if (parameter.isResolved()) {
                ParameterValues parameterValues = requestParameters.getParameterValueItems(parameter);
                if (parameterValues != null && parameterValues.size() == 1 && parameterValues.get(0) != null && ((ParameterValueItem)parameterValues.get(0)).getBoundValue() != null && ((ParameterValueItem)parameterValues.get(0)).getBoundValue() instanceof V5BoundMemberUniqueName) {
                    V5BoundMemberUniqueName mun = (V5BoundMemberUniqueName)((ParameterValueItem)parameterValues.get(0)).getBoundValue();
                    BaseMember mdxMember = (BaseMember)nodeFactory.createNode(1067);
                    mdxMember.bindLevel(mun.getLevel());
                    mdxMember.bindExternalName(mun.getExternalMemberUniqueName());
                    mdxMember.bindLogicalName(mun.getLogical());
                    mdxMember.setRollupAggregate(mun.getRollupAggregate());
                    mdxParameterNode.setReplacementMDXMember(mdxMember);
                }
            } else {
                MDXParameterMember mdxParameterNodeDummy = (MDXParameterMember)nodeFactory.createNode(1129);
                mdxParameterNodeDummy.setName(v5BoundParameter.getParameterName());
                mdxParameterNodeDummy.setIdentifier(v5BoundParameter.getIdentifier());
                ArrayList<ILevel> dummyLevels = new ArrayList<ILevel>();
                dummyLevels.addAll(levels);
                mdxParameterNodeDummy.bindLevels(dummyLevels);
                mdxParameterNode.setReplacementMDXMember(mdxParameterNodeDummy);
            }
        }
        mdxParameterNode.bindLevels(levels);
        if (v5BoundParameter.couldBeEmpty()) {
            mdxParameterNode.setCouldBeEmpty(true);
        }
        return mdxParameterNode;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        XQETrace trace = environment.getTrace();
        V5BoundParameter prompt = (V5BoundParameter)node;
        if (!prompt.isLiteral() && !prompt.isMetadataAvailable()) {
            this.traceNodeCondition(status, "Metadata of V5BoundParameter node is not available.", trace);
            return status;
        }
        StringBuilder msg = new StringBuilder();
        MultiRequestContext multiRequestContext = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext();
        if (prompt.isPromptValueRequiredBeforePlanning(msg, multiRequestContext, environment)) {
            this.traceNodeCondition(status, msg.toString(), trace);
            return status;
        }
        status = true;
        if (prompt.isLiteral()) {
            this.traceNodeCondition(status, "The prompt node is a single value selection prompt that can be converted to MDXParameterValue.", trace);
        } else {
            this.traceNodeCondition(status, "The prompt node can be converted to MDXParameterMember because it has valid metadata.", trace);
        }
        return status;
    }
}

