/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5NamedSetToMDXNamedSet
extends AbstractV5ToCogMDXTransformation {
    private static final String VALID_EXPRESSION = "The V5 NamedSet function is a valid supported expression.";

    public ConvertV5NamedSetToMDXNamedSet() {
        this.mName = "Convert V5 NamedSet function to a MDX NamedSet.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201147};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXSet definition = (AbstractMDXSet)node.detachChild(0);
        MDXNamedSetReference namedSet = MDXBuilder.buildMDXNamedSet(nodeFactory, mdxQuery, "USER", definition);
        node.exchange(namedSet, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int nbrChildren = node.getNumberChildren();
        if (nbrChildren != 1) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidChildNode, node.getNodeTypeName());
        }
        IXQEQueryNode valueExpr = node.getChild(0);
        if (valueExpr.isOfCategory(1021)) {
            status = true;
            this.traceNodeCondition(status, VALID_EXPRESSION, trace);
        }
        if (!status) {
            this.traceNodeCondition(status, "The V5 NamedSet function is not a valid supported expression.", trace);
        }
        return status;
    }
}

