/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXDateTimeConstant;
import com.cognos.xqe.ast.olap.MDXNumericOperator;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5NumericOpToMDXNumericOp
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5NumericOpToMDXNumericOp() {
        this.mName = "Convert V5 Numeric Operator to MDX Numeric Operator: +, -, * and /.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201014};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXNumericOperator newNode = (MDXNumericOperator)nodeFactory.createNode(1084);
        switch (((V5ValueExpression)node).getSubType()) {
            case 1: {
                newNode.setOperatorProperty(0);
                break;
            }
            case 2: {
                newNode.setOperatorProperty(1);
                break;
            }
            case 3: {
                newNode.setOperatorProperty(2);
                break;
            }
            case 4: {
                newNode.setOperatorProperty(3);
                break;
            }
            case 5: {
                newNode.setOperatorProperty(4);
                break;
            }
            case 6: {
                newNode.setOperatorProperty(5);
                break;
            }
        }
        node.getParent().exchangeChildNode(node, newNode, true);
        newNode.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode valueExpr;
        int i;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int nbrChildren = node.getNumberChildren();
        int subtype = ((V5ValueExpression)node).getSubType();
        if (nbrChildren == 2 && (subtype == 3 || subtype == 4 || subtype == 1 || subtype == 2)) {
            status = true;
        } else if (nbrChildren == 1 && (subtype == 5 || subtype == 6)) {
            status = true;
        }
        String operatorName = ((V5ValueExpression)node).getNodeSubTypeName();
        for (i = 0; i < node.getNumberChildren() && status; ++i) {
            valueExpr = node.getChild(i);
            if (valueExpr.isOfCategory(1061) || valueExpr.isOfCategory(1022) || valueExpr.isOfCategory(1068)) continue;
            status = false;
        }
        for (i = 0; i < node.getNumberChildren(); ++i) {
            String contextConstant;
            valueExpr = node.getChild(i);
            Value constantVal = null;
            if (!valueExpr.isOfCategory(1151) && !valueExpr.isOfCategory(1127)) continue;
            if (valueExpr.isOfCategory(1151)) {
                constantVal = ((MDXDateTimeConstant)valueExpr).getConstantValue();
                contextConstant = constantVal.getString();
            } else {
                contextConstant = ((MDXStringConstant)valueExpr).getConstantValue();
            }
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidArithmeticContext, operatorName, contextConstant);
        }
        if (status) {
            this.traceNodeCondition(status, "It is a supported numeric operator.", trace);
        } else {
            this.traceNodeCondition(status, "It is not a supported numeric operator.", trace);
        }
        return status;
    }
}

