/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5RangeSetToMDXRangeSet
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5RangeSetToMDXRangeSet() {
        this.mName = "Convert the V5 rangeSet expression to the MDX rangeSet.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201134};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxRangeSetNode = nodeFactory.createNode(1147);
        node.getParent().exchangeChildNode(node, mdxRangeSetNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() > 2) {
            this.traceNodeCondition(false, "The V5 rangeSet expression doesn't have valid number of arguments", trace);
            return false;
        }
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode child = node.getChild(i);
            if (child.isOfCategory(1022)) continue;
            this.traceNodeCondition(false, "The argument for V5 rangeSet expression should be member expression", trace);
            return false;
        }
        this.traceNodeCondition(true, "The V5 rangeSet expression is a valid.", trace);
        return true;
    }
}

