/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public final class ConvertV5RoleValueToMDXProperties
extends AbstractV5ToCogMDXTransformation {
    private static final String THE_TRANSFORMATION_IS_NOT_APPLICABLE = "The transformation is not applicable.";

    public ConvertV5RoleValueToMDXProperties() {
        this.mName = "Convert a V5RoleValueFunction node into a MDXProperties node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201098};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Object propertyName;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5RoleValueFunction v5RoleValueFunction = (V5RoleValueFunction)node;
        boolean isGoupBodyProjectingPeerlessLevelInfo = ConvertV5RoleValueToMDXProperties.isGoupBodyProjectingPeerlessLevelInfo(v5RoleValueFunction, null);
        RoleTypeEnum roleType = v5RoleValueFunction.getRoleType();
        AbstractMDXNode contextNode = (AbstractMDXNode)v5RoleValueFunction.detachChild(1);
        CogMDXProperties mdxProperties = (CogMDXProperties)nodeFactory.createNode(1016);
        BaseProperty baseProperty = (BaseProperty)nodeFactory.createNode(1025);
        boolean bound = false;
        IQueryItem propertyMetadata = v5RoleValueFunction.getPropertyMetadata();
        if (propertyMetadata == null) {
            propertyName = ((MDXStringConstant)v5RoleValueFunction.getChild(0)).getConstantValue();
            propertyMetadata = ConvertV5RoleValueToMDXProperties.bindV5RoleValueMetadataProperty(v5RoleValueFunction, (String)propertyName, contextNode);
        }
        if (propertyMetadata != null && (roleType == RoleTypeEnum.MEMBER_CUSTOM_PROPERTY || roleType == RoleTypeEnum.BUSINESS_KEY || roleType.getDataType() == null)) {
            baseProperty.bind(propertyMetadata);
            bound = true;
        } else {
            bound = baseProperty.bind(roleType, v5RoleValueFunction.getDataType(), v5RoleValueFunction.getMDXName());
            if (propertyMetadata != null) {
                baseProperty.setSupplementaryMetadata(propertyMetadata);
            }
        }
        if (bound) {
            mdxProperties.addChild(baseProperty);
            mdxProperties.addChild(contextNode);
            if (isGoupBodyProjectingPeerlessLevelInfo) {
                MDXQuery mdxQuery = (MDXQuery)v5RoleValueFunction.getAncestorOfType(1002);
                MDXCalculatedMemberReference propertyCalc = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, mdxQuery.getMeasuresHierarchy(), "_PROPGBODY", mdxProperties, SolveOrderUtil.getCubeCalcSolveOrder());
                v5RoleValueFunction.exchange(propertyCalc, false);
            } else {
                v5RoleValueFunction.exchange(mdxProperties, false);
            }
        } else if (roleType.isIntrinsic()) {
            AbstractMDXNode nullValue = (AbstractMDXNode)nodeFactory.createNode(1089);
            v5RoleValueFunction.exchange(nullValue, false);
        } else {
            propertyName = (MDXStringConstant)v5RoleValueFunction.getChild(0);
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidRole, ((MDXStringConstant)propertyName).getConstantValue());
        }
    }

    public static IQueryItem bindV5RoleValueMetadataProperty(V5RoleValueFunction v5RoleValueFunction, String propertyName, AbstractMDXNode contextNode) {
        IHierarchy hierarchy;
        MDXLevelInfo levelInfo = contextNode.getLevelInfo();
        if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            contextNode.throwInternalError("Rolevalue's second child must project a single hierarchy.");
        }
        if (levelInfo.getNumProjectedLevels(hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0)) == 1) {
            return (IQueryItem)((Object)MetadataUtil.getPropertyByRole(levelInfo.getProjectedLevel(hierarchy, 0), propertyName));
        }
        return null;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesQueryCondition(node, environment)) {
            this.traceQueryCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5RoleValueFunction v5RoleValueFunction = (V5RoleValueFunction)node;
        StringBuilder traceMsg = null;
        if (trace.getTraceLevel() != 0) {
            traceMsg = new StringBuilder();
        }
        boolean status = ConvertV5RoleValueToMDXProperties.validateV5RoleValueFunction(v5RoleValueFunction, traceMsg);
        if (trace.getTraceLevel() != 0) {
            this.traceNodeCondition(status, traceMsg.toString(), trace);
        }
        if (!status) {
            return false;
        }
        boolean bl = status = ConvertV5RoleValueToMDXProperties.doCreateMDXProperty(v5RoleValueFunction, traceMsg) == Result.doCreate;
        if (trace.getTraceLevel() != 0) {
            this.traceNodeCondition(status, traceMsg.toString(), trace);
            if (status) {
                this.traceNodeCondition(status, "The transformation is applicable.", trace);
            } else {
                this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            }
        }
        return status;
    }

    public static Result doCreateMDXProperty(V5RoleValueFunction v5RoleValueFunction, StringBuilder traceMsg) {
        boolean status;
        boolean bl = status = !V5ToCogMDXUtilities.isDirectProjectedNode(v5RoleValueFunction);
        if (!status) {
            V5ValueSet v5ValueSet;
            if (traceMsg != null) {
                traceMsg.append("Target V5RoleValueFunction node is projected.");
            }
            if (v5RoleValueFunction.getParent().getType() == 101015 && v5RoleValueFunction.getParent().getParent().getType() == 101051 && (v5ValueSet = (V5ValueSet)v5RoleValueFunction.getAncestorOfType(101057)) != null && v5ValueSet.getPropertyValue("refDataItem") != null) {
                if (!ConvertV5RoleValueToMDXProperties.checkAncestorValueSets(v5RoleValueFunction)) {
                    if (traceMsg != null) {
                        traceMsg.append("At least one ancestor value set does not project an AbstractMDXNode.");
                    }
                    return Result.wait;
                }
                if (ConvertV5RoleValueToMDXProperties.isGoupBodyProjectingPeerlessLevelInfo(v5RoleValueFunction, traceMsg)) {
                    return Result.doCreate;
                }
            }
        }
        if (traceMsg != null) {
            traceMsg.append("Target V5RoleValueFunction node is not projected.");
        }
        if (status) {
            return Result.doCreate;
        }
        return Result.doNotCreate;
    }

    public static boolean isGoupBodyProjectingPeerlessLevelInfo(V5RoleValueFunction v5RoleValueFunction, StringBuilder traceMsg) {
        if (v5RoleValueFunction.getParent().getType() != 101015 || v5RoleValueFunction.getParent().getParent().getType() != 101051) {
            return false;
        }
        IXQEQueryNode second = v5RoleValueFunction.getChild(1);
        boolean secondIsCurrentMember = second.getType() == 1076;
        boolean foundMatchingValueSet = false;
        for (V5ValueSet v5ValueSet = (V5ValueSet)v5RoleValueFunction.getAncestorOfType(101057); v5ValueSet != null; v5ValueSet = (V5ValueSet)v5ValueSet.getAncestorOfType(101057)) {
            if (v5ValueSet.getPropertyValue("refDataItem") == null) {
                if (traceMsg != null) {
                    traceMsg.append("Ancestor value set projects detail group bodies.");
                }
                return false;
            }
            if (!v5ValueSet.getChild(0).isOfCategory(1001)) {
                if (traceMsg == null) break;
                traceMsg.append("Ancestor value set's projected expression is not yet an AbstractMDxNode.");
                break;
            }
            AbstractMDXNode valueSetProjSet = (AbstractMDXNode)v5ValueSet.getChild(0);
            MDXLevelInfo groupBodyLevelInfo = ((AbstractMDXNode)second).getLevelInfo();
            MDXHierInfo groupBodyHierInfo = groupBodyLevelInfo.getHierarchyInfo();
            MDXLevelInfo valueSetLevelInfo = valueSetProjSet.getLevelInfo();
            MDXHierInfo valueSetHierInfo = valueSetLevelInfo.getHierarchyInfo();
            if (secondIsCurrentMember && groupBodyHierInfo.compareProjectedHierarchies(valueSetHierInfo)) {
                if (traceMsg != null) {
                    traceMsg.append("Found an ancestor value set projecting the exact same level info as the target node.");
                }
                return false;
            }
            if (!groupBodyHierInfo.compareProjectedHierarchies(valueSetHierInfo)) break;
            if (!groupBodyLevelInfo.compareProjectedLevels(valueSetLevelInfo)) continue;
            foundMatchingValueSet = true;
            break;
        }
        if (!foundMatchingValueSet) {
            if (traceMsg != null) {
                traceMsg.append("Not a single ancestor value set projects the exact same level info as the target node.");
            }
            return true;
        }
        return false;
    }

    public static boolean validateV5RoleValueFunction(V5RoleValueFunction v5RoleValueFunction, StringBuilder traceMsg) {
        if (v5RoleValueFunction.getNumberChildren() != 2) {
            if (traceMsg != null) {
                traceMsg.append("Target V5RoleValueFunction node has not 2 children.");
            }
            return false;
        }
        IXQEQueryNode first = v5RoleValueFunction.getChild(0);
        if (first.getType() != 1127) {
            if (traceMsg != null) {
                traceMsg.append("The first child of the V5RoleValueFunction node is not a MDXStringConstant node.");
            }
            return false;
        }
        IXQEQueryNode second = v5RoleValueFunction.getChild(1);
        if (!second.isOfCategories(new int[]{1022, 1021})) {
            if (traceMsg != null) {
                traceMsg.append("The second child of the V5RoleValueFunction node can not be coerced to a AbstractMDXSet.");
            }
            return false;
        }
        if (traceMsg != null) {
            traceMsg.append("Target V5RoleValueFunction node is valid.");
        }
        return true;
    }

    public static boolean checkAncestorValueSets(V5RoleValueFunction v5RoleValueFunction) {
        for (V5ValueSet v5ValueSet = (V5ValueSet)v5RoleValueFunction.getAncestorOfType(101057); v5ValueSet != null; v5ValueSet = (V5ValueSet)v5ValueSet.getAncestorOfType(101057)) {
            if (v5ValueSet.getChild(0).isOfCategory(1001)) continue;
            return false;
        }
        return true;
    }

    public static enum Result {
        doCreate,
        doNotCreate,
        wait;

    }
}

