/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.ConvertV5RoleValueToMDXProperties;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5RoleValueToTNodePrjProperty
extends AbstractV5ToCogMDXTransformation {
    private static final String THE_TRANSFORMATION_IS_NOT_APPLICABLE = "The transformation is not applicable.";

    public ConvertV5RoleValueToTNodePrjProperty() {
        this.mName = "Convert a V5RoleValueFunction node into a TNodeProjProperty node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201098};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataItem rsapiRefDataItem;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5RoleValueFunction v5RoleValueFunction = (V5RoleValueFunction)node;
        RoleTypeEnum roleType = v5RoleValueFunction.getRoleType();
        MDXStringConstant mdxStringConstant = (MDXStringConstant)node.getChild(0);
        String propertyName = mdxStringConstant.getConstantValue();
        AbstractMDXNode contextSet = (AbstractMDXNode)node.detachChild(1);
        IQueryItem propertyMetadata = v5RoleValueFunction.getPropertyMetadata();
        if (propertyMetadata == null && (roleType == RoleTypeEnum.MEMBER_CUSTOM_PROPERTY || roleType == RoleTypeEnum.BUSINESS_KEY || roleType.getDataType() == null)) {
            propertyMetadata = ConvertV5RoleValueToMDXProperties.bindV5RoleValueMetadataProperty(v5RoleValueFunction, propertyName, contextSet);
        }
        if (propertyMetadata == null && roleType == RoleTypeEnum.MEMBER_CUSTOM_PROPERTY) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidRole, propertyName);
        }
        if (contextSet.isOfCategory(1022)) {
            AbstractMDXNode setFunction = (AbstractMDXNode)nodeFactory.createNode(1039);
            contextSet.insertParent(setFunction);
            contextSet = setFunction;
        }
        BaseProperty baseProperty = (BaseProperty)nodeFactory.createNode(1025);
        if (propertyMetadata != null) {
            baseProperty.bind(propertyMetadata);
        } else {
            String mdxName = v5RoleValueFunction.getMDXName();
            if (mdxName == null && roleType != RoleTypeEnum.MEMBER_CUSTOM_PROPERTY && roleType.toMDXKeyword() == null) {
                mdxName = "MEMBER_UNIQUE_NAME";
            }
            baseProperty.bind(v5RoleValueFunction.getRoleType(), v5RoleValueFunction.getDataType(), mdxName);
        }
        IXQEQueryNode newNode = nodeFactory.createNode(1116);
        newNode.addChild(contextSet);
        newNode.addChild(baseProperty);
        if (v5RoleValueFunction.getParent().getType() == 101015 && (rsapiRefDataItem = (RSAPIDataItem)((V5DataItemRef)v5RoleValueFunction.getParent()).getPropertyValue("RSAPIRefDataItem")).getDataType() == null) {
            throw new IllegalStateException();
        }
        node.getParent().exchangeChildNode(node, newNode);
        ((AbstractMDXNode)newNode).setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesQueryCondition(node, environment)) {
            this.traceQueryCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5RoleValueFunction v5RoleValueFunction = (V5RoleValueFunction)node;
        StringBuilder traceMsg = null;
        if (trace.getTraceLevel() != 0) {
            traceMsg = new StringBuilder();
        }
        boolean status = ConvertV5RoleValueToMDXProperties.validateV5RoleValueFunction(v5RoleValueFunction, traceMsg);
        if (trace.getTraceLevel() != 0) {
            this.traceNodeCondition(status, traceMsg.toString(), trace);
        }
        if (!status) {
            return false;
        }
        boolean bl = status = ConvertV5RoleValueToMDXProperties.doCreateMDXProperty(v5RoleValueFunction, traceMsg) == ConvertV5RoleValueToMDXProperties.Result.doNotCreate;
        if (trace.getTraceLevel() != 0) {
            this.traceNodeCondition(status, traceMsg.toString(), trace);
            if (status) {
                this.traceNodeCondition(status, "The transformation is applicable.", trace);
            } else {
                this.traceNodeCondition(status, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            }
        }
        return status;
    }
}

