/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;

public class AdjustUsageForCountFloatingCalc
extends Transformation {
    public static final String ADJUST_USAGE_FOR_NUMERIC_MEMBER_FUNCTIONS = "AdjustUsageForNumericMemberFunctions";

    public AdjustUsageForCountFloatingCalc() {
        this.mName = "Set usage to FACT for numeric member functions which cal defintion has been assigned to the measures.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberReference calcMemberReference = (MDXCalculatedMemberReference)node;
        CogMDXGroup group = (CogMDXGroup)calcMemberReference.getParent().getParent();
        RSAPIDataItem dataItem = group.getFirstRSAPIDataItem();
        dataItem.setUsage(RSAPIUsage.FACT);
        node.setPropertyValue(ADJUST_USAGE_FOR_NUMERIC_MEMBER_FUNCTIONS, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(ADJUST_USAGE_FOR_NUMERIC_MEMBER_FUNCTIONS) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation is not required.", trace);
            return false;
        }
        MDXCalculatedMemberReference calcMemberReference = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition definition = calcMemberReference.getDefinition();
        if (definition == null) {
            this.traceNodeCondition(false, "Target node has no definition.", trace);
            return false;
        }
        IHierarchy hier = definition.getHierarchy();
        if (hier == null || hier.getDimension() == null) {
            this.traceNodeCondition(false, "Target node has hierarchy or dimesnion.", trace);
            return false;
        }
        if (!hier.getDimension().isMeasuresDimension()) {
            this.traceNodeCondition(false, "Target node is not a measure.", trace);
            return false;
        }
        if (calcMemberReference.getParent() == null || calcMemberReference.getParent().getType() != 1039) {
            this.traceNodeCondition(false, "Target node's parent is not an mdx set.", trace);
            return false;
        }
        if (calcMemberReference.getParent().getParent() == null || !calcMemberReference.getParent().getParent().isOfCategory(1027)) {
            this.traceNodeCondition(false, "Target node's grandparent is not an mdx group.", trace);
            return false;
        }
        RSAPIDataItem dataItem = ((CogMDXGroup)calcMemberReference.getParent().getParent()).getFirstRSAPIDataItem();
        if (dataItem == null || dataItem.getUsage() == RSAPIUsage.FACT) {
            this.traceNodeCondition(false, "Target node's RSAPIDataItem is flagged as RSAPIUsage .FACT.", trace);
            return false;
        }
        if (definition.getChild(0) == null || !definition.getChild(0).isOfCategory(1062)) {
            this.traceNodeCondition(false, "Target node's definiton is not a numeric expression.", trace);
            return false;
        }
        AbstractMDXNode calcExpression = (AbstractMDXNode)definition.getChild(0);
        if (calcExpression.getType() != 1087 || calcExpression.getNumberChildren() > 1) {
            this.traceNodeCondition(false, "Target node's definiton is not a summary with a single child.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation is required.", trace);
        return true;
    }
}

