/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AbstractAssignHierToCalcMemberInValueSet;

public class AssignHierarchyToCalculatedMemberSiblingInSet
extends Transformation {
    public AssignHierarchyToCalculatedMemberSiblingInSet() {
        this.mName = "Assign a hierarchy to calculated member in the context of V5 set function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition = ((MDXCalculatedMemberReference)node).getDefinition();
        mdxCalculatedMemberDefinition.throwOnInvalidChildCategories();
        IHierarchy hierarchy = null;
        IXQEQueryNode setParent = node.getParent();
        for (int i = 0; i < setParent.getNumberChildren(); ++i) {
            IHierarchy currHierarchy;
            AbstractMDXNode sibling = (AbstractMDXNode)setParent.getChild(i);
            if (sibling == node || (currHierarchy = sibling.getHierarchyInfo().getProjectedHierarchy(0)).isShell()) continue;
            hierarchy = currHierarchy;
            break;
        }
        mdxCalculatedMemberDefinition.setHierarchy(hierarchy);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        String reason = "The hierarchy of the MDXCalculatedMemberReference node has already been resolved.";
        if (calcRef.getHierarchy() != null && !calcRef.getHierarchy().isShell()) {
            this.traceQueryCondition(false, "The hierarchy of the MDXCalculatedMemberReference node has already been resolved.", trace);
            return false;
        }
        if (!AbstractAssignHierToCalcMemberInValueSet.validateCalcDefinition((MDXCalculatedMemberReference)node, environment)) {
            this.traceQueryCondition(false, "The target node is not a valid planned node yet.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The MDXCalculatedMemberReference node is not within an MDXQuery node.", trace);
            return false;
        }
        MDXHierInfo mdxHierInfo = ((MDXCalculatedMemberReference)node).getHierarchyInfo();
        if (!mdxHierInfo.projectsShellHierarchy()) {
            this.traceNodeCondition(false, "The hierarchy of the calculated member has been resolved already.", trace);
            return false;
        }
        if (node.getParent().getType() != 201101 || node.getParent().getNumberChildren() <= 1) {
            this.traceNodeCondition(false, "The target node is not one of the many children of an V5FuntionSet.", trace);
            return false;
        }
        IXQEQueryNode setParent = node.getParent();
        boolean foundNonShellSibling = false;
        for (int i = 0; i < setParent.getNumberChildren(); ++i) {
            if (!setParent.getChild(i).isOfCategory(1001)) {
                this.traceNodeCondition(false, "Found a sibling that is not yet an AbstractMDXNode.", trace);
                return false;
            }
            if (foundNonShellSibling) continue;
            foundNonShellSibling = !((AbstractMDXNode)setParent.getChild(i)).getHierarchyInfo().projectsShellHierarchy();
        }
        if (!foundNonShellSibling) {
            this.traceNodeCondition(false, "All the siblings project shell hierarchies", trace);
            return false;
        }
        this.traceNodeCondition(true, "Hierarchy can be assigned to a sibling hierarchy", trace);
        return true;
    }
}

