/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AbstractAssignHierToCalcMemberInValueSet;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AssignHierarchyToCalculatedMemberInValueSetComplexSummary;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AssignHierarchyToCalculatedMemberInValueSetSimpleSummary;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.ChosenHierarchy;

public class AssignHierarchyToMeasureCalculatedMemberInValueSet
extends AbstractAssignHierToCalcMemberInValueSet {
    public AssignHierarchyToMeasureCalculatedMemberInValueSet() {
        this.mName = "Assign a hierarchy to a measure calculated member located in valueSet if is not defined by means of summary functions.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ChosenHierarchy result = this.resolveCalculationHierarchy(node);
        MDXCalculatedMemberReference calcMemberReference = (MDXCalculatedMemberReference)node;
        AssignHierarchyToMeasureCalculatedMemberInValueSet.applyHierarchy(calcMemberReference, environment, result, false);
    }

    @Override
    protected ChosenHierarchy resolveCalculationHierarchy(IXQEQueryNode node) {
        ChosenHierarchy result = new ChosenHierarchy();
        AssignHierarchyToMeasureCalculatedMemberInValueSet.isApplicable(node, result);
        return result;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return this.queryCondition(node, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return this.nodeCondition(node, environment);
    }

    public static boolean isApplicable(IXQEQueryNode node, ChosenHierarchy result) {
        V5Edge v5Edge = (V5Edge)node.getAncestorOfType(101049);
        if (v5Edge == null) {
            node.throwInternalError("");
        }
        boolean areMeasuresProjected = false;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] v5Edges = mdxQuery.getChildrenOfType(101049);
        for (int i = 0; i < v5Edges.length; ++i) {
            V5Edge currV5Edge = (V5Edge)v5Edges[i];
            MDXHierInfo patternHierInfo = currV5Edge.getPropertyPatternHierInfo();
            if (!patternHierInfo.projectsMeasures()) continue;
            areMeasuresProjected = true;
            break;
        }
        if (areMeasuresProjected) {
            if (result != null) {
                result.setTakenFrom("Measure Hierarchy is projected by some other edge.");
            }
            return false;
        }
        MDXCalculatedMemberReference calculatedMemberReference = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition definition = calculatedMemberReference.getDefinition();
        IHierarchy dummyHierarchy = definition.getHierarchy();
        MDXHierInfo aboveCalcHierInfo = v5Edge.getPropertyPatternHierInfo();
        if (!aboveCalcHierInfo.projectsHierarchy(dummyHierarchy)) {
            if (result != null) {
                result.setTakenFrom("Unable to resolve the hierarchy for the target calculated member.");
            }
            return false;
        }
        int dummyHierarchyIdx = aboveCalcHierInfo.getProjectedHierarchyIndex(dummyHierarchy);
        if (dummyHierarchyIdx != 0 && dummyHierarchyIdx < aboveCalcHierInfo.getNumProjectedHierarchies() - 1) {
            if (result != null) {
                result.setTakenFrom("Unable to resolve the hierarchy for the target calculated member.");
            }
            return false;
        }
        CogMDXGroup grandParentNode = AbstractAssignHierToCalcMemberInValueSet.getCogMDXGroupGrandparentOverTNodeSet(calculatedMemberReference);
        MDXHierInfo belowCalcHierInfo = null;
        try {
            belowCalcHierInfo = grandParentNode.getHierarchyInfo();
        }
        catch (XQERuntimeException e) {
            if (e.getMessageKey().getName().equals("PLN_InvalidHierarchies")) {
                belowCalcHierInfo = AssignHierarchyToMeasureCalculatedMemberInValueSet.getHierInfoFromGroupNestingBranchesWithCurrentMemberSetOfShellHier(grandParentNode);
            }
            throw e;
        }
        aboveCalcHierInfo.extractHierInfo(belowCalcHierInfo);
        IHierarchy nextAboveHierarchy = null;
        if (aboveCalcHierInfo.getNumProjectedHierarchies() > 0) {
            nextAboveHierarchy = aboveCalcHierInfo.getProjectedHierarchy(aboveCalcHierInfo.getNumProjectedHierarchies() - 1);
        }
        if (AssignHierarchyToCalculatedMemberInValueSetSimpleSummary.resolveCalcHierarchy(result, definition, belowCalcHierInfo, nextAboveHierarchy, grandParentNode)) {
            if (result != null) {
                result.setTakenFrom("The definition of the calculated member does reference summaries.");
            }
            return false;
        }
        StringBuilder msgStr = null;
        if (AssignHierarchyToCalculatedMemberInValueSetComplexSummary.queryCondition(node, msgStr) && AssignHierarchyToCalculatedMemberInValueSetComplexSummary.nodeCondition(node, msgStr)) {
            if (result != null) {
                result.setTakenFrom("The definition of the calculated member does reference summaries.");
            }
            return false;
        }
        MDXHierInfo calcRealHierInfo = AbstractAssignHierToCalcMemberInValueSet.resolveMDXHierInfoForCalculation(calculatedMemberReference);
        if (calcRealHierInfo.getNumProjectedHierarchies() == 1 && calcRealHierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
            if (result != null) {
                result.setChosenHiearchy(calcRealHierInfo.getProjectedHierarchy(0));
                result.setTakenFrom("the the only hiearchy in defition, a measure hierarchy.");
                result.setDefinition(definition);
            }
            return true;
        }
        if (result != null) {
            result.setTakenFrom("Unable to resolve the hierarchy for the target calculated member.");
        }
        return false;
    }
}

