/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AbstractAssignHierToCalcMemberInValueSet;

public class AssignHierarchyToNonProjectedCalculatedMember
extends Transformation {
    public AssignHierarchyToNonProjectedCalculatedMember() {
        this.mName = "Assign measure hierarchy to non-projected calculated member.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition = ((MDXCalculatedMemberReference)node).getDefinition();
        mdxCalculatedMemberDefinition.throwOnInvalidChildCategories();
        IHierarchy hierarchy = null;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        ICube cube = mdxQuery.getReferencedCube();
        hierarchy = cube.getMeasuresHierarchy();
        mdxCalculatedMemberDefinition.setHierarchy(hierarchy);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        String reason = "The hierarchy of the MDXCalculatedMemberReference node has already been resolved.";
        if (calcRef.getHierarchy() != null && !calcRef.getHierarchy().isShell()) {
            this.traceQueryCondition(false, "The hierarchy of the MDXCalculatedMemberReference node has already been resolved.", trace);
            return false;
        }
        boolean status = AbstractAssignHierToCalcMemberInValueSet.validateCalcDefinition((MDXCalculatedMemberReference)node, environment);
        if (!status) {
            this.traceQueryCondition(false, "The target node is not a valid planned node yet.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The MDXCalculatedMemberReference node is not within an MDXQuery node.", trace);
            return false;
        }
        MDXHierInfo mdxHierInfo = ((MDXCalculatedMemberReference)node).getHierarchyInfo();
        status = mdxHierInfo.projectsShellHierarchy();
        if (!mdxHierInfo.projectsShellHierarchy()) {
            this.traceNodeCondition(false, "The hierarchy of the calculated member has been resolved already.", trace);
            return false;
        }
        StringBuilder msgStr = new StringBuilder();
        msgStr.append("The MDXCalculatedMemberReference node is is not within a MDXQuery node.");
        msgStr.append(" Its hierarchy has not been resolved yet.");
        this.traceNodeCondition(true, msgStr.toString(), trace);
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode mdxEdge = node.getAncestorOfType(1006);
        IXQEQueryNode v5Edge = node.getAncestorOfType(101049);
        if (mdxEdge == null && v5Edge != null) {
            IXQEQueryNode parentNode = node.getParent();
            if (parentNode.getType() == 101015 && (parentNode.getParent().getType() == 101052 || parentNode.getParent().getType() == 101053)) {
                this.traceNodeCondition(true, "The MDXCalculatedMemberReference node is a footer/header's V5DataItemRef.", trace);
                return true;
            }
            this.traceNodeCondition(false, "The MDXCalculatedMemberReference node is under a V5Edge node.", trace);
            return false;
        }
        String isNotProjected = "The MDXCalculatedMemberReference node is not projected.";
        if (mdxEdge == null) {
            MDXCalculatedMemberDefinition definition = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            if (definition != null && mdxQuery.getProjectedReferences(definition).isEmpty()) {
                MDXHierInfo parentCalcHierInfo = definition.getHierarchyInfo();
                if (!parentCalcHierInfo.projectsShellHierarchy()) {
                    String calcRefETC = "calc reference under a non projected calc";
                    String definitonWhichETC = " definiton which hierarchy is defined already";
                    if (node.getParent().isOfCategory(1069)) {
                        MDXHierInfo tupleMDXHierInfo = ((MDXTuple)node.getParent()).getHierarchyInfo();
                        if (!tupleMDXHierInfo.projectsMeasures()) {
                            StringBuilder traceMsg = new StringBuilder("calc reference under a non projected calc");
                            traceMsg.append(" definiton which hierarchy is defined already");
                            traceMsg.append(" , its parent tuple has no measures.");
                            this.traceNodeCondition(true, traceMsg.toString(), trace);
                            return true;
                        }
                    } else {
                        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)node.getAncestorOfType(1030);
                        if (mdxCrossjoin != null) {
                            if (!mdxCrossjoin.getHierarchyInfo().projectsMeasures()) {
                                StringBuilder traceMsg = new StringBuilder("calc reference under a non projected calc");
                                traceMsg.append(" definiton which hierarchy is defined already");
                                traceMsg.append(" , its ancestor crossjoin has no measures.");
                                this.traceNodeCondition(true, traceMsg.toString(), trace);
                                return true;
                            }
                        } else {
                            this.traceNodeCondition(true, "The MDXCalculatedMemberReference node is not projected.", trace);
                            return true;
                        }
                    }
                }
                this.traceNodeCondition(false, "The hierarchy of the ancestor MDXCalculatedMemberDefinition has not been resolved.", trace);
                return false;
            }
        }
        if (mdxEdge != null && ((MDXEdge)mdxEdge).isProjectedDescendant((MDXCalculatedMemberReference)node)) {
            this.traceNodeCondition(false, "The MDXCalculatedMemberReference node is projected.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MDXCalculatedMemberReference node is not projected.", trace);
        return true;
    }
}

