/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class DetectUnnecessaryNormalizationGroups
extends Transformation {
    public DetectUnnecessaryNormalizationGroups() {
        this.mName = "Detect hierarchy normalizations groups that are no longer required.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode mdxEdge = node.getAncestorOfType(1006);
        Integer edgeId = mdxEdge.getId();
        String reason = "Found unrequired normalization node.";
        throw new XQERuntimeException(XQEMessageKeys.PLN_FailNormalizeEdgeHierarchies_INTERNAL, edgeId.toString(), reason);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode mdxEdge = node.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "the target node is not within an MDXEdge node.", trace);
            return false;
        }
        this.traceQueryCondition(true, "the target node is within an MDXEdge node.", trace);
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        String trueMsg = "The hierarchy normalization CogMDXGroup is not required.";
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        if (!targetGroup.isNormalizationGroup()) {
            this.traceNodeCondition(false, "Target CogMDXGroup is not a normalization node.", trace);
            return false;
        }
        MDXHierInfo targetHierInfo = ((AbstractMDXSet)targetGroup.getChild(0)).getHierarchyInfo();
        CogMDXGroup ancestorGroup = (CogMDXGroup)targetGroup.getAncestorOfType(1027);
        if (ancestorGroup != null) {
            MDXHierInfo ancestorHierInfo = ((AbstractMDXSet)ancestorGroup.getChild(0)).getHierarchyInfo();
            if (targetHierInfo.getProjectedHierarchy(0).equals(ancestorHierInfo.getProjectedHierarchy(0))) {
                this.traceNodeCondition(true, "The hierarchy normalization CogMDXGroup is not required.", trace);
                return true;
            }
        }
        if (targetGroup.getNumberChildren() == 2) {
            MDXHierInfo nestedSetHierInfo = ((AbstractMDXSet)targetGroup.getChild(1)).getHierarchyInfo();
            if (targetHierInfo.getProjectedHierarchy(0).equals(nestedSetHierInfo.getProjectedHierarchy(0))) {
                this.traceNodeCondition(true, "The hierarchy normalization CogMDXGroup is not required.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The hierarchy normalization CogMDXGroup is required.", trace);
        return false;
    }
}

