/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapPlanningException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ExpandNamedSetBoundMultiPartIdentifier
extends AbstractV5ToCogMDXTransformation {
    public static final String UNABLE_TO_EXPAND_NAMED_SET = "unableToExpandNamedSet";
    private static final String TRUE_STR = "true";

    public ExpandNamedSetBoundMultiPartIdentifier() {
        this.mName = "Replace bound identifier with MDX expression.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        INamedSet namedSet;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        if (metaData.getObjectType() == MetadataType.NAMED_SET && (namedSet = (INamedSet)metaData).getDimension().getCube().getType() == ICube.CubeTypeEnum.TMR) {
            node.setPropertyValue(UNABLE_TO_EXPAND_NAMED_SET, TRUE_STR);
            return;
        }
        AbstractMDXNode newNode = ExpandNamedSetBoundMultiPartIdentifier.createAbstractMDXNodeFromMetadata(environment, metaData, mdxQuery);
        if (newNode != null) {
            node.getParent().exchangeChildNode(node, newNode, false);
            newNode.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        } else {
            node.setPropertyValue(UNABLE_TO_EXPAND_NAMED_SET, TRUE_STR);
        }
    }

    public static AbstractMDXNode createAbstractMDXNodeFromMetadata(PlanningEnvironment environment, IMetadata metaData, MDXQuery mdxQuery) {
        IXQEQueryNode newNode = null;
        try {
            if (metaData.getObjectType() == MetadataType.CALCULATION) {
                ICalculation namedSet = (ICalculation)metaData;
                newNode = namedSet.getSet(environment, metaData.getConnection(), mdxQuery);
            } else if (metaData.getObjectType() == MetadataType.NAMED_SET) {
                INamedSet namedSet = (INamedSet)metaData;
                newNode = namedSet.getSet(environment, metaData.getConnection(), mdxQuery);
            }
        }
        catch (XQEOlapPlanningException e) {
            XQETrace trace = environment.getTrace();
            ExpandNamedSetBoundMultiPartIdentifier.traceExceptionMessage(e, trace);
        }
        return (AbstractMDXNode)newNode;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        if (metaData == null) {
            this.traceNodeCondition(false, "Unable to replace bound object which is null.", trace);
            return false;
        }
        boolean status = false;
        StringBuilder msgStr = new StringBuilder("The node is");
        String s1 = "a cube namedSet.";
        if (metaData.getObjectType() == MetadataType.CALCULATION) {
            String calcType = ((ICalculation)metaData).getCalcType();
            if (calcType.equals("namedSet") && node.getPropertyValue(UNABLE_TO_EXPAND_NAMED_SET) == null) {
                status = true;
            }
        } else if (metaData.getObjectType() == MetadataType.NAMED_SET && node.getPropertyValue(UNABLE_TO_EXPAND_NAMED_SET) == null) {
            status = true;
        }
        if (!status) {
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append(s1);
        } else {
            msgStr.append(" ");
            msgStr.append(s1);
        }
        this.traceNodeCondition(status, msgStr.toString(), trace);
        return status;
    }
}

