/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ReplaceNamedSetBoundMultiPartIdentifier
extends AbstractV5ToCogMDXTransformation {
    public ReplaceNamedSetBoundMultiPartIdentifier() {
        this.mName = "Replace bound identifier with an OLAP BaseSet node.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        this.checkForInvalidProjectedMeasureSet(node, metaData);
        AbstractMDXNode newNode = ReplaceNamedSetBoundMultiPartIdentifier.createAbstractMDXNodeFromMetadata(environment, metaData, mdxQuery);
        if (newNode != null) {
            node.getParent().exchangeChildNode(node, newNode, false);
            newNode.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        } else {
            node.throwInternalError("");
        }
    }

    private void checkForInvalidProjectedMeasureSet(IXQEQueryNode node, IMetadata metaData) {
        V5ValueSet valueSet;
        V5DataItem v5DataItem;
        INamedSet namedSet = (INamedSet)metaData;
        if (!namedSet.getDimension().isMeasuresDimension()) {
            return;
        }
        V5DataItemRef v5DataItemRef = (V5DataItemRef)node.getAncestorOfType(101015);
        String dataItemName = null;
        boolean isDetailFilter = false;
        boolean bl = isDetailFilter = node.getAncestorOfType(1010) != null;
        if (!isDetailFilter && (v5DataItem = (V5DataItem)ASTUtil.getFirstNodeOfTypeFromAncestorQueryLineage(node, 101003)) != null) {
            dataItemName = v5DataItem.getNameProperty();
        }
        if (v5DataItemRef != null && (valueSet = (V5ValueSet)node.getAncestorOfType(101057)).getRefDataItemProperty() == null) {
            IXQEQueryNode ancestor = node.getParent();
            while (ancestor != v5DataItemRef && (ancestor = ancestor.getParent()).isOfCategory(201122)) {
            }
            if (ancestor == v5DataItemRef) {
                if (dataItemName == null) {
                    dataItemName = v5DataItemRef.getDataItemRefProperty();
                }
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedMeasureSetExpressionInDetailColumn, dataItemName);
            }
        }
    }

    public static AbstractMDXNode createAbstractMDXNodeFromMetadata(PlanningEnvironment environment, IMetadata metaData, MDXQuery mdxQuery) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        INamedSet namedSet = (INamedSet)metaData;
        BaseSet baseSet = (BaseSet)nodeFactory.createNode(1148);
        baseSet.bindHierarchy(namedSet.getHierarchy());
        baseSet.bindExternalName(namedSet.getUniqueName());
        baseSet.setLevelInfo(namedSet.getLevels());
        return baseSet;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        boolean status = false;
        StringBuilder msgStr = new StringBuilder("The node is");
        String s1 = "a cube namedSet whose definition we are unable to expand.";
        if (metaData.getObjectType() == MetadataType.CALCULATION) {
            String calcType = ((ICalculation)metaData).getCalcType();
            if (calcType.equals("namedSet") && node.getPropertyValue("unableToExpandNamedSet") != null) {
                status = true;
            }
        } else if (metaData.getObjectType() == MetadataType.NAMED_SET) {
            status = true;
        }
        if (!status) {
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append(s1);
        } else {
            msgStr.append(" ");
            msgStr.append(s1);
        }
        this.traceNodeCondition(status, msgStr.toString(), trace);
        return status;
    }
}

