/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public final class ConvertV5AncestorsToMDXAncestors
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5AncestorsToMDXAncestors() {
        this.mName = "Convert the V5 Ancestors function by the MDX Ancestors function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201046};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxAncestorsNode = nodeFactory.createNode(1044);
        node.getParent().exchangeChildNode(node, mdxAncestorsNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 2 && node.getChild(0).isOfCategory(1022) && (node.getChild(1).isOfCategory(1023) || V5ToCogMDXUtilities.isCoercableToNumericValueExpression(node.getChild(1)))) {
            if (node.getChild(1).isOfCategory(1023)) {
                MDXHierInfo secondExprHierInfo;
                MDXHierInfo firstExprHierInfo = ((AbstractMDXNode)node.getChild(0)).getHierarchyInfo();
                if (firstExprHierInfo.compareProjectedHierarchies(secondExprHierInfo = ((AbstractMDXNode)node.getChild(1)).getHierarchyInfo())) {
                    status = true;
                    this.traceNodeCondition(status, "The V5 Ancestors function has valid number of arguments, expression type and referenced hierarchy.", trace);
                } else {
                    this.traceNodeCondition(status, "The member expression (first arguments) and the level expression (second argument) are not from the same hierarchy.", trace);
                }
            } else {
                status = true;
                this.traceNodeCondition(status, "The V5 Ancestors function has valid number of arguments and expression type.", trace);
            }
        } else {
            this.traceNodeCondition(status, "The V5 Ancestors expression doesn't have 2 arguments.", trace);
        }
        return status;
    }
}

