/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public final class ConvertV5HeadToMDXHead
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5HeadToMDXHead() {
        this.mName = "Convert the V5 Head function by the MDX Head function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201071};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxHeadNode = nodeFactory.createNode(1042);
        node.getParent().exchangeChildNode(node, mdxHeadNode, true);
        ((MDXHeadTailFunction)mdxHeadNode).setOperatorType(1);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int nbrArguments = node.getNumberChildren();
        if (nbrArguments == 1) {
            if (node.getChild(0).isOfCategory(1021)) {
                status = true;
                this.traceNodeCondition(status, "The Head function has single valid argument.", trace);
            } else {
                this.traceNodeCondition(status, "The first argument is not of a valid set expression.", trace);
            }
        } else if (nbrArguments == 2) {
            if (node.getChild(0).isOfCategory(1021) && V5ToCogMDXUtilities.isCoercableToNumericValueExpression(node.getChild(1))) {
                status = true;
                this.traceNodeCondition(status, "The Head function has 2 valid arguments.", trace);
            } else {
                this.traceNodeCondition(status, "One of the argument is not of a valid expression type.", trace);
            }
        } else {
            this.traceNodeCondition(status, "The V5 Head expression doesn't have valid number of arguments.", trace);
        }
        return status;
    }
}

