/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5HierarchyToMDXBaseHierarchy
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5HierarchyToMDXBaseHierarchy() {
        this.mName = "Convert V5Hierarchy To BaseHierarchy.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201073};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXHierInfo hierInfo = ((AbstractMDXNode)node.getChild(0)).getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        BaseHierarchy baseHierarchy = MDXBuilder.buildMDXBaseHierarchyExpr(factory, hierarchy);
        node.getParent().exchangeChildNode(node, baseHierarchy);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The target V5HierarchyFunction node does not a single child node.", trace);
            return false;
        }
        if (!(node.getChild(0).isOfCategory(1021) || node.getChild(0).isOfCategory(1022) || node.getChild(0).isOfCategory(1023) || node.getChild(0).isOfCategory(1072))) {
            this.traceNodeCondition(false, "The first child of the target V5HierarchyFunction node is not an AbstractMDXSet, AbstractMDXMember, AbstractMDXHierarchy or AbstractMDXLevel expression.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((AbstractMDXNode)node.getChild(0)).getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The projected hierarchy cannot be determined for the first child of the target V5HierarchyFunction node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target node.", trace);
        return true;
    }
}

