/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5IntersectFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5IntersectToMDXIntersect
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5IntersectToMDXIntersect() {
        this.mName = "Convert the V5 Intersect function by the MDX Intersect function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201074};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxIntersectNode = nodeFactory.createNode(1038);
        if (((V5IntersectFunction)node).getAll()) {
            ((MDXIntersect)mdxIntersectNode).setAll(true);
        }
        node.getParent().exchangeChildNode(node, mdxIntersectNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 2) {
            if (node.getChild(0).isOfCategory(1021) && node.getChild(1).isOfCategory(1021)) {
                MDXHierInfo firstExprHierInfo = ((AbstractMDXNode)node.getChild(0)).getHierarchyInfo();
                MDXHierInfo secondExprHierInfo = ((AbstractMDXNode)node.getChild(1)).getHierarchyInfo();
                if (firstExprHierInfo.getNumProjectedHierarchies() == 1 && secondExprHierInfo.getNumProjectedHierarchies() == 1 && firstExprHierInfo.compareProjectedHierarchies(secondExprHierInfo)) {
                    status = true;
                    this.traceNodeCondition(status, "The V5 Intersect has valid arguments.", trace);
                } else {
                    this.traceNodeCondition(status, "The both argument are not from the same single hierarchy or at least one argument involve more than one hierarchy.", trace);
                }
            } else {
                this.traceNodeCondition(status, "One of the argument is not from a valid expression type.", trace);
            }
        } else {
            this.traceNodeCondition(status, "The V5 Intersect expression doesn't have a 2 arguments", trace);
        }
        return status;
    }
}

