/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXDateTimeConstant;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.SmallintValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5LiteralValueToMDXConstant
extends AbstractV5ToCogMDXTransformation {
    public static final int TEN = 10;

    public ConvertV5LiteralValueToMDXConstant() {
        this.mName = "Convert a V5 Value Expression to MDX Constant.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IDataType dataType = ((V5LiteralValue)node).getDataType();
        IXQEQueryNode newNode = null;
        Value value = ((V5LiteralValue)node).getValue();
        if (value.isNull()) {
            newNode = nodeFactory.createNode(1089);
        } else {
            DataSubType subType = dataType.getSubType();
            switch (subType) {
                case NUMERICTYPE: {
                    newNode = nodeFactory.createNode(1064);
                    if (value instanceof BigDecimalValue) {
                        ((MDXNumericConstant)newNode).setConstantValue(((BigDecimalValue)value).getBigDecimal());
                        break;
                    }
                    if (value instanceof SmallintValue) {
                        ((MDXNumericConstant)newNode).setConstantValue(value.getShort());
                        break;
                    }
                    ((MDXNumericConstant)newNode).setConstantValue(value.getObject());
                    break;
                }
                case DATETIMETYPE: {
                    MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
                    String dataSource = mdxQuery.getDataSourceType();
                    if (dataSource.equals("BW") && value instanceof DateValue) {
                        DateValue dateValue = (DateValue)value;
                        StringBuilder buffer = new StringBuilder();
                        buffer.append(dateValue.getYear());
                        if (dateValue.getMonth() < 10) {
                            buffer.append(0);
                        }
                        buffer.append(dateValue.getMonth());
                        if (dateValue.getDay() < 10) {
                            buffer.append(0);
                        }
                        buffer.append(dateValue.getDay());
                        newNode = nodeFactory.createNode(1127);
                        ((MDXStringConstant)newNode).setConstantValue(buffer.toString());
                        break;
                    }
                    newNode = nodeFactory.createNode(1151);
                    ((MDXDateTimeConstant)newNode).setConstantValue(value);
                    break;
                }
                case TEXTTYPE: {
                    newNode = nodeFactory.createNode(1127);
                    ((MDXStringConstant)newNode).setConstantValue(value.getString());
                    break;
                }
            }
        }
        ((AbstractMDXNode)newNode).setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        node.getParent().exchangeChildNode(node, newNode, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (super.passesQueryCondition(node, environment)) {
            CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
            if (mdxDetailFilter != null && mdxDetailFilter.pushDetailFilterToRelationalProvider()) {
                XQETrace trace = environment.getTrace();
                this.traceNodeCondition(false, "The node is for a relational construct.", trace);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 0) {
            IDataType dataType = ((V5LiteralValue)node).getDataType();
            DataSubType subType = dataType.getSubType();
            switch (subType) {
                case NUMERICTYPE: {
                    byte cclTypeCode = dataType.getCCLTypeCode();
                    if (cclTypeCode != 6 && cclTypeCode != 11 && cclTypeCode != 4 && cclTypeCode != 8 && cclTypeCode != 12) break;
                    status = true;
                    this.traceNodeCondition(status, "It is a supported numeric type.", trace);
                    break;
                }
                case DATETIMETYPE: {
                    status = true;
                    this.traceNodeCondition(status, "It is a supported datetime type.", trace);
                    break;
                }
                case TEXTTYPE: {
                    status = true;
                    this.traceNodeCondition(status, "It is a supported string type.", trace);
                    break;
                }
                default: {
                    status = false;
                    this.traceNodeCondition(status, "It is not a supported constant type.", trace);
                }
            }
        }
        return status;
    }
}

